/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.logger;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.components.logger.SimpleLoggerStoreFactory;
import org.apache.avalon.phoenix.components.util.ResourceUtil;
import org.apache.avalon.phoenix.interfaces.LogManager;
import org.realityforge.configkit.PropertyExpander;
import org.realityforge.configkit.ResolverFactory;
import org.realityforge.loggerstore.DOMLog4JLoggerStoreFactory;
import org.realityforge.loggerstore.InitialLoggerStoreFactory;
import org.realityforge.loggerstore.LogKitLoggerStoreFactory;
import org.realityforge.loggerstore.LoggerStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class DefaultLogManager
extends AbstractLogEnabled
implements LogManager,
Contextualizable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$logger$DefaultLogManager == null ? (class$org$apache$avalon$phoenix$components$logger$DefaultLogManager = DefaultLogManager.class$("org.apache.avalon.phoenix.components.logger.DefaultLogManager")) : class$org$apache$avalon$phoenix$components$logger$DefaultLogManager));
    private final PropertyExpander m_expander = new PropertyExpander();
    private final InitialLoggerStoreFactory m_factory = new InitialLoggerStoreFactory();
    private File m_phoenixHome;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$logger$DefaultLogManager;
    static /* synthetic */ Class class$org$realityforge$loggerstore$PropertyLog4JLoggerStoreFactory;
    static /* synthetic */ Class class$org$realityforge$loggerstore$DOMLog4JLoggerStoreFactory;
    static /* synthetic */ Class class$org$realityforge$loggerstore$Jdk14LoggerStoreFactory;
    static /* synthetic */ Class class$org$realityforge$loggerstore$LogKitLoggerStoreFactory;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Context;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$java$util$Properties;

    public void contextualize(Context context) throws ContextException {
        this.m_phoenixHome = (File)context.get((Object)"phoenix.home");
    }

    private Map createLoggerManagerContext(Map appContext) {
        HashMap<String, File> data = new HashMap<String, File>();
        data.putAll(appContext);
        data.put("phoenix.home", this.m_phoenixHome);
        return data;
    }

    public LoggerStore createHierarchy(Configuration logs, File homeDirectory, File workDirectory, Map context) throws Exception {
        SimpleLoggerStoreFactory loggerManager;
        String message;
        Map map = this.createLoggerManagerContext(context);
        if (null == logs) {
            LoggerStore store = null;
            store = this.scanForLoggerConfig("SAR-INF/log4j.properties", (class$org$realityforge$loggerstore$PropertyLog4JLoggerStoreFactory == null ? (class$org$realityforge$loggerstore$PropertyLog4JLoggerStoreFactory = DefaultLogManager.class$("org.realityforge.loggerstore.PropertyLog4JLoggerStoreFactory")) : class$org$realityforge$loggerstore$PropertyLog4JLoggerStoreFactory).getName(), homeDirectory, workDirectory, map);
            if (null != store) {
                return store;
            }
            store = this.scanForLoggerConfig("SAR-INF/log4j.xml", (class$org$realityforge$loggerstore$DOMLog4JLoggerStoreFactory == null ? (class$org$realityforge$loggerstore$DOMLog4JLoggerStoreFactory = DefaultLogManager.class$("org.realityforge.loggerstore.DOMLog4JLoggerStoreFactory")) : class$org$realityforge$loggerstore$DOMLog4JLoggerStoreFactory).getName(), homeDirectory, workDirectory, map);
            if (null != store) {
                return store;
            }
            store = this.scanForLoggerConfig("SAR-INF/logging.properties", (class$org$realityforge$loggerstore$Jdk14LoggerStoreFactory == null ? (class$org$realityforge$loggerstore$Jdk14LoggerStoreFactory = DefaultLogManager.class$("org.realityforge.loggerstore.Jdk14LoggerStoreFactory")) : class$org$realityforge$loggerstore$Jdk14LoggerStoreFactory).getName(), homeDirectory, workDirectory, map);
            if (null != store) {
                return store;
            }
            store = this.scanForLoggerConfig("SAR-INF/excalibur-logger.xml", (class$org$realityforge$loggerstore$LogKitLoggerStoreFactory == null ? (class$org$realityforge$loggerstore$LogKitLoggerStoreFactory = DefaultLogManager.class$("org.realityforge.loggerstore.LogKitLoggerStoreFactory")) : class$org$realityforge$loggerstore$LogKitLoggerStoreFactory).getName(), homeDirectory, workDirectory, map);
            if (null != store) {
                return store;
            }
            String message2 = "Unable to locate any logging configuration";
            throw new IllegalStateException("Unable to locate any logging configuration");
        }
        String version = logs.getAttribute("version", "1.0");
        if (this.getLogger().isDebugEnabled()) {
            message = REZ.getString("logger-create", context.get("app.name"), (Object)version);
            this.getLogger().debug(message);
        }
        if (version.equals("1.0")) {
            loggerManager = new SimpleLoggerStoreFactory();
            ContainerUtil.enableLogging((Object)((Object)loggerManager), (Logger)this.getLogger());
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put((class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = DefaultLogManager.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger).getName(), this.getLogger());
            config.put((class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultLogManager.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context).getName(), new DefaultContext(map));
            config.put((class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = DefaultLogManager.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration).getName(), logs);
            return loggerManager.createLoggerStore(config);
        }
        if (version.equals("1.1")) {
            loggerManager = new LogKitLoggerStoreFactory();
            ContainerUtil.enableLogging((Object)((Object)loggerManager), (Logger)this.getLogger());
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put((class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = DefaultLogManager.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger).getName(), this.getLogger());
            config.put((class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultLogManager.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context).getName(), new DefaultContext(map));
            config.put((class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = DefaultLogManager.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration).getName(), logs);
            return loggerManager.createLoggerStore(config);
        }
        if (version.equals("log4j")) {
            loggerManager = new DOMLog4JLoggerStoreFactory();
            ContainerUtil.enableLogging((Object)((Object)loggerManager), (Logger)this.getLogger());
            HashMap<String, Element> config = new HashMap<String, Element>();
            Element element = this.buildLog4JConfiguration(logs);
            this.m_expander.expandValues(element, map);
            config.put((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = DefaultLogManager.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getName(), element);
            return loggerManager.createLoggerStore(config);
        }
        message = "Unknown logger version '" + version + "' in environment.xml";
        throw new IllegalStateException(message);
    }

    private Element buildLog4JConfiguration(Configuration logs) {
        Element element = ConfigurationUtil.toElement((Configuration)logs);
        Document document = element.getOwnerDocument();
        Element newElement = document.createElement("log4j:configuration");
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = childNodes.item(i);
            Node newNode = node.cloneNode(true);
            newElement.appendChild(newNode);
        }
        document.appendChild(newElement);
        return newElement;
    }

    private LoggerStore scanForLoggerConfig(String location, String classname, File homeDirectory, File workDirectory, Map context) throws Exception {
        boolean isPropertiesFile = location.endsWith("properties");
        File file = ResourceUtil.getFileForResource(location, homeDirectory, workDirectory);
        LoggerStore store = null;
        if (null != file) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (isPropertiesFile) {
                Properties properties = new Properties();
                properties.load(file.toURL().openStream());
                Properties newProperties = this.m_expander.expandValues(properties, context);
                config.put((class$java$util$Properties == null ? (class$java$util$Properties = DefaultLogManager.class$("java.util.Properties")) : class$java$util$Properties).getName(), newProperties);
            } else if (!location.equals("SAR-INF/excalibur-logger.xml")) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                EntityResolver resolver = ResolverFactory.createResolver((ClassLoader)this.getClass().getClassLoader());
                builder.setEntityResolver(resolver);
                Document document = builder.parse(file);
                Element element = document.getDocumentElement();
                this.m_expander.expandValues(element, context);
                config.put((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = DefaultLogManager.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getName(), element);
            } else {
                config.put("org.realityforge.loggerstore.url", file.toURL());
            }
            config.put("org.realityforge.loggerstore.factory", classname);
            store = this.m_factory.createLoggerStore(config);
        }
        return store;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

