/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.components.configuration.ConfigurationDirectoryFilter;
import org.apache.avalon.phoenix.components.configuration.ConfigurationFileFilter;
import org.apache.avalon.phoenix.components.configuration.merger.ConfigurationMerger;
import org.apache.avalon.phoenix.components.util.PropertyUtil;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.xml.sax.SAXException;

public class FileSystemPersistentConfigurationRepository
extends AbstractLogEnabled
implements ConfigurationRepository,
Contextualizable,
Configurable,
Initializable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$configuration$FileSystemPersistentConfigurationRepository == null ? (class$org$apache$avalon$phoenix$components$configuration$FileSystemPersistentConfigurationRepository = FileSystemPersistentConfigurationRepository.class$("org.apache.avalon.phoenix.components.configuration.FileSystemPersistentConfigurationRepository")) : class$org$apache$avalon$phoenix$components$configuration$FileSystemPersistentConfigurationRepository));
    private final Map m_persistedConfigurations = new HashMap();
    private Context m_context;
    private File m_storageDirectory;
    private String m_debugPath;
    private DefaultConfigurationSerializer m_serializer;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$configuration$FileSystemPersistentConfigurationRepository;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_storageDirectory = new File(this.constructStoragePath(configuration));
        try {
            FileUtil.forceMkdir((File)this.m_storageDirectory);
        }
        catch (IOException e) {
            String message = REZ.getString("config.error.dir.invalid", (Object)this.m_storageDirectory);
            throw new ConfigurationException(message, (Throwable)e);
        }
        this.m_debugPath = configuration.getChild("debug-output-path").getValue(null);
    }

    public Configuration processConfiguration(String application, String block, Configuration configuration) throws ConfigurationException {
        Configuration processedConfiguration = this.doProcessConfiguration(application, block, configuration);
        if (null != this.m_debugPath) {
            this.writeDebugConfiguration(application, block, processedConfiguration);
        }
        return processedConfiguration;
    }

    private Configuration doProcessConfiguration(String application, String block, Configuration configuration) throws ConfigurationException {
        Configuration persistedConfiguration = (Configuration)this.m_persistedConfigurations.get(this.genKey(application, block));
        if (null != persistedConfiguration) {
            return ConfigurationMerger.merge(persistedConfiguration, configuration);
        }
        return configuration;
    }

    private String constructStoragePath(Configuration configuration) throws ConfigurationException {
        String path = configuration.getChild("storage-directory").getValue("${phoenix.home}/conf/apps");
        try {
            Object opath = PropertyUtil.resolveProperty(path, this.m_context, false);
            if (opath instanceof String) {
                return FileUtil.normalize((String)((String)opath));
            }
            String message = REZ.getString("config.error.nonstring", (Object)opath.getClass().getName());
            throw new ConfigurationException(message);
        }
        catch (Exception e) {
            String message = REZ.getString("config.error.missingproperty", (Object)configuration.getLocation());
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    public void initialize() throws Exception {
        this.loadConfigurations();
        if (null != this.m_debugPath) {
            FileUtil.forceMkdir((File)new File(this.m_debugPath));
            this.m_serializer = new DefaultConfigurationSerializer();
            this.m_serializer.setIndent(true);
        }
    }

    private void loadConfigurations() throws IOException, SAXException, ConfigurationException {
        File[] apps = this.m_storageDirectory.listFiles(new ConfigurationDirectoryFilter());
        for (int i = 0; i < apps.length; ++i) {
            this.loadConfigurations(apps[i]);
        }
    }

    private void loadConfigurations(File appPath) throws IOException, SAXException, ConfigurationException {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        String app = appPath.getName();
        File[] blocks = appPath.listFiles(new ConfigurationFileFilter());
        for (int i = 0; i < blocks.length; ++i) {
            String block = blocks[i].getName().substring(0, blocks[i].getName().indexOf(".xml"));
            this.m_persistedConfigurations.put(this.genKey(app, block), builder.buildFromFile(blocks[i]));
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("Loaded persistent configuration [app: " + app + ", block: " + block + "]");
        }
    }

    private String genKey(String app, String block) {
        return app + '-' + block;
    }

    private void writeDebugConfiguration(String application, String block, Configuration configuration) {
        try {
            File temp = File.createTempFile(application + "-" + block + "-", ".xml", new File(this.m_debugPath));
            this.m_serializer.serializeToFile(temp, configuration);
            if (this.getLogger().isDebugEnabled()) {
                String message = "Configuration written at: " + temp;
                this.getLogger().debug(message);
            }
        }
        catch (Exception e) {
            String message = "Unable to write debug output";
            this.getLogger().error("Unable to write debug output", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

