/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.Collection;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.DNSService;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.dao.DNSDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.DNSService")
public class DNSServiceImpl
implements DNSService {
    private static final Log log = LogFactory.getLog(DNSServiceImpl.class);
    private DNSDao dao;

    public void init() {
        log.info((Object)"DNSService initialized");
    }

    @Override
    public void addDNS(Collection<DNSRecord> records) throws ConfigurationServiceException {
        this.dao.add(records);
    }

    @Override
    public Collection<DNSRecord> getDNSByName(String name) throws ConfigurationServiceException {
        return this.dao.get(name);
    }

    @Override
    public Collection<DNSRecord> getDNSByNameAndType(String name, int type) throws ConfigurationServiceException {
        return this.dao.get(name, type);
    }

    @Override
    public DNSRecord getDNSByRecordId(long recordId) throws ConfigurationServiceException {
        return this.dao.get(recordId);
    }

    @Override
    public Collection<DNSRecord> getDNSByRecordIds(long[] recordIds) throws ConfigurationServiceException {
        return this.dao.get(recordIds);
    }

    @Override
    public Collection<DNSRecord> getDNSByType(int type) throws ConfigurationServiceException {
        return this.dao.get(type);
    }

    @Override
    public int getDNSCount() throws ConfigurationServiceException {
        return this.dao.count();
    }

    @Override
    public void removeDNS(Collection<DNSRecord> records) throws ConfigurationServiceException {
        this.dao.remove(records);
    }

    @Override
    public void removeDNSByRecordId(long recordId) throws ConfigurationServiceException {
        this.dao.remove(recordId);
    }

    @Override
    public void removeDNSByRecordIds(long[] recordIds) throws ConfigurationServiceException {
        this.dao.remove(recordIds);
    }

    @Override
    public void updateDNS(long recordId, DNSRecord record) throws ConfigurationServiceException {
        this.dao.update(recordId, record);
    }

    @Autowired
    public void setDao(DNSDao dao) {
        this.dao = dao;
    }

    public DNSDao getDao() {
        return this.dao;
    }
}

