/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.Handler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.BundleThumbprint;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.dao.TrustBundleDao;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class DefaultBundleRefreshProcessorImpl
implements BundleRefreshProcessor {
    public static final String BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED = "BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED";
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    private static final Log log = LogFactory.getLog(DefaultBundleRefreshProcessorImpl.class);
    protected TrustBundleDao dao;

    public static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED, "org.nhindirect.config.processor.impl.bundlerefresh.AllowNonVerifiedSSL");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    public DefaultBundleRefreshProcessorImpl() {
        OptionsParameter allowNonVerSSLParam = OptionsManager.getInstance().getParameter(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED);
        if (OptionsParameter.getParamValueAsBoolean((OptionsParameter)allowNonVerSSLParam, (boolean)false)) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDao(TrustBundleDao dao) {
        this.dao = dao;
    }

    @Override
    @Handler
    public void refreshBundle(TrustBundle bundle) {
        Calendar processAttempStart = Calendar.getInstance(Locale.getDefault());
        byte[] rawBundle = this.downloadBundleToByteArray(bundle, processAttempStart);
        if (rawBundle == null) {
            return;
        }
        boolean update = false;
        String checkSum = "";
        if (bundle.getCheckSum() == null) {
            update = true;
        } else {
            try {
                checkSum = BundleThumbprint.toThumbprint((byte[])rawBundle).toString();
                update = !bundle.getCheckSum().equals(BundleThumbprint.toThumbprint((byte[])rawBundle).toString());
            }
            catch (NoSuchAlgorithmException ex) {
                this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.INVALID_BUNDLE_FORMAT);
                log.error((Object)"Failed to generate downloaded bundle thumbprint ", (Throwable)ex);
            }
        }
        if (!update) {
            this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.SUCCESS);
            return;
        }
        Collection<X509Certificate> bundleCerts = this.convertRawBundleToAnchorCollection(rawBundle, bundle, processAttempStart);
        if (bundleCerts == null) {
            return;
        }
        HashSet<X509Certificate> downloadedSet = new HashSet<X509Certificate>(bundleCerts);
        try {
            ArrayList<TrustBundleAnchor> newAnchors = new ArrayList<TrustBundleAnchor>();
            for (X509Certificate downloadedAnchor : downloadedSet) {
                try {
                    TrustBundleAnchor anchorToAdd = new TrustBundleAnchor();
                    anchorToAdd.setData(downloadedAnchor.getEncoded());
                    anchorToAdd.setTrustBundle(bundle);
                    newAnchors.add(anchorToAdd);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to convert downloaded anchor to byte array. ", (Throwable)e);
                }
            }
            bundle.setTrustBundleAnchors(newAnchors);
            this.dao.updateTrustBundleAnchors(bundle.getId(), processAttempStart, newAnchors, checkSum);
            this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.SUCCESS);
        }
        catch (ConfigurationStoreException e) {
            this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.INVALID_BUNDLE_FORMAT);
            log.error((Object)"Failed to write updated bundle anchors to data store ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Collection<X509Certificate> convertRawBundleToAnchorCollection(byte[] rawBundle, TrustBundle existingBundle, Calendar processAttempStart) {
        Collection<? extends Certificate> bundleCerts = null;
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(rawBundle);
            bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((InputStream)inStream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        if (bundleCerts == null) {
            try {
                CMSSignedData signed = new CMSSignedData(rawBundle);
                if (existingBundle.getSigningCertificateData() != null) {
                    boolean sigVerified = false;
                    X509Certificate signingCert = existingBundle.toSigningCertificate();
                    for (SignerInformation sigInfo : signed.getSignerInfos().getSigners()) {
                        try {
                            if (!sigInfo.verify(signingCert, CryptoExtensions.getJCEProviderName())) continue;
                            sigVerified = true;
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (!sigVerified) {
                        this.dao.updateLastUpdateError(existingBundle.getId(), processAttempStart, BundleRefreshError.UNMATCHED_SIGNATURE);
                        log.warn((Object)"Downloaded bundle signature did not match configured signing certificate.");
                        Collection<X509Certificate> collection = null;
                        return collection;
                    }
                }
                CMSProcessableByteArray signedContent = (CMSProcessableByteArray)signed.getSignedContent();
                inStream = new ByteArrayInputStream((byte[])signedContent.getContent());
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
            }
            catch (Exception e) {
                this.dao.updateLastUpdateError(existingBundle.getId(), processAttempStart, BundleRefreshError.INVALID_BUNDLE_FORMAT);
                log.warn((Object)("Failed to extract anchors from downloaded bundle at URL " + existingBundle.getBundleURL()));
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
        return bundleCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] downloadBundleToByteArray(TrustBundle bundle, Calendar processAttempStart) {
        InputStream inputStream = null;
        byte[] retVal = null;
        ByteArrayOutputStream ouStream = new ByteArrayOutputStream();
        try {
            URL certURL = new URL(bundle.getBundleURL());
            URLConnection connection = certURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            inputStream = connection.getInputStream();
            int BUF_SIZE = 2048;
            int count = 0;
            byte[] buf = new byte[BUF_SIZE];
            while ((count = inputStream.read(buf)) > -1) {
                ouStream.write(buf, 0, count);
            }
            retVal = ouStream.toByteArray();
        }
        catch (SocketTimeoutException e) {
            this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.DOWNLOAD_TIMEOUT);
            log.warn((Object)("Failed to download bundle from URL " + bundle.getBundleURL()), (Throwable)e);
        }
        catch (Exception e) {
            this.dao.updateLastUpdateError(bundle.getId(), processAttempStart, BundleRefreshError.NOT_FOUND);
            log.warn((Object)("Failed to download bundle from URL " + bundle.getBundleURL()), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)ouStream);
        }
        return retVal;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DefaultBundleRefreshProcessorImpl.initJVMParams();
    }
}

