/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.operations;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.ClinicalStatement;
import org.openhealthtools.mdht.uml.cda.Component4;
import org.openhealthtools.mdht.uml.cda.Encounter;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.ObservationMedia;
import org.openhealthtools.mdht.uml.cda.Organizer;
import org.openhealthtools.mdht.uml.cda.Procedure;
import org.openhealthtools.mdht.uml.cda.RegionOfInterest;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.Supply;
import org.openhealthtools.mdht.uml.cda.operations.ClinicalStatementOperations;
import org.openhealthtools.mdht.uml.hl7.vocab.x_ActRelationshipEntryRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizerOperations
extends ClinicalStatementOperations {
    protected OrganizerOperations() {
    }

    public static void addAct(Organizer organizer, Act act) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setAct(act);
        organizer.getComponents().add((Object)component4);
    }

    public static void addEncounter(Organizer organizer, Encounter encounter) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setEncounter(encounter);
        organizer.getComponents().add((Object)component4);
    }

    public static void addObservation(Organizer organizer, Observation observation) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setObservation(observation);
        organizer.getComponents().add((Object)component4);
    }

    public static void addObservationMedia(Organizer organizer, ObservationMedia observationMedia) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setObservationMedia(observationMedia);
        organizer.getComponents().add((Object)component4);
    }

    public static void addOrganizer(Organizer organizer, Organizer newOrganizer) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setOrganizer(newOrganizer);
        organizer.getComponents().add((Object)component4);
    }

    public static void addProcedure(Organizer organizer, Procedure procedure) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setProcedure(procedure);
        organizer.getComponents().add((Object)component4);
    }

    public static void addRegionOfInterest(Organizer organizer, RegionOfInterest regionOfInterest) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setRegionOfInterest(regionOfInterest);
        organizer.getComponents().add((Object)component4);
    }

    public static void addSubstanceAdministration(Organizer organizer, SubstanceAdministration substanceAdministration) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setSubstanceAdministration(substanceAdministration);
        organizer.getComponents().add((Object)component4);
    }

    public static void addSupply(Organizer organizer, Supply supply) {
        Component4 component4 = CDAFactory.eINSTANCE.createComponent4();
        component4.setSupply(supply);
        organizer.getComponents().add((Object)component4);
    }

    public static EList<Act> getActs(Organizer organizer) {
        ArrayList<Act> acts = new ArrayList<Act>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getAct() == null) continue;
            acts.add(component.getAct());
        }
        return new BasicEList.UnmodifiableEList(acts.size(), acts.toArray());
    }

    public static EList<Encounter> getEncounters(Organizer organizer) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getEncounter() == null) continue;
            encounters.add(component.getEncounter());
        }
        return new BasicEList.UnmodifiableEList(encounters.size(), encounters.toArray());
    }

    public static EList<Observation> getObservations(Organizer organizer) {
        ArrayList<Observation> observations = new ArrayList<Observation>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getObservation() == null) continue;
            observations.add(component.getObservation());
        }
        return new BasicEList.UnmodifiableEList(observations.size(), observations.toArray());
    }

    public static EList<ObservationMedia> getObservationMedia(Organizer organizer) {
        ArrayList<ObservationMedia> observationMedia = new ArrayList<ObservationMedia>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getObservationMedia() == null) continue;
            observationMedia.add(component.getObservationMedia());
        }
        return new BasicEList.UnmodifiableEList(observationMedia.size(), observationMedia.toArray());
    }

    public static EList<Organizer> getOrganizers(Organizer organizer) {
        ArrayList<Organizer> organizers = new ArrayList<Organizer>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getOrganizer() == null) continue;
            organizers.add(component.getOrganizer());
        }
        return new BasicEList.UnmodifiableEList(organizers.size(), organizers.toArray());
    }

    public static EList<Procedure> getProcedures(Organizer organizer) {
        ArrayList<Procedure> procedures = new ArrayList<Procedure>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getProcedure() == null) continue;
            procedures.add(component.getProcedure());
        }
        return new BasicEList.UnmodifiableEList(procedures.size(), procedures.toArray());
    }

    public static EList<RegionOfInterest> getRegionsOfInterest(Organizer organizer) {
        ArrayList<RegionOfInterest> regionsOfInterest = new ArrayList<RegionOfInterest>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getRegionOfInterest() == null) continue;
            regionsOfInterest.add(component.getRegionOfInterest());
        }
        return new BasicEList.UnmodifiableEList(regionsOfInterest.size(), regionsOfInterest.toArray());
    }

    public static EList<SubstanceAdministration> getSubstanceAdministrations(Organizer organizer) {
        ArrayList<SubstanceAdministration> substanceAdministrations = new ArrayList<SubstanceAdministration>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getSubstanceAdministration() == null) continue;
            substanceAdministrations.add(component.getSubstanceAdministration());
        }
        return new BasicEList.UnmodifiableEList(substanceAdministrations.size(), substanceAdministrations.toArray());
    }

    public static EList<Supply> getSupplies(Organizer organizer) {
        ArrayList<Supply> supplies = new ArrayList<Supply>();
        for (Component4 component : organizer.getComponents()) {
            if (component.getSupply() == null) continue;
            supplies.add(component.getSupply());
        }
        return new BasicEList.UnmodifiableEList(supplies.size(), supplies.toArray());
    }

    public static EList<ClinicalStatement> getEntryRelationshipTargets(Organizer organizer, x_ActRelationshipEntryRelationship typeCode, Object targetClass) {
        throw new UnsupportedOperationException("This clinical statement does not have entryRelationship");
    }

    public static EList<ClinicalStatement> getEntryRelationshipTargets(Organizer organizer, Object targetClass) {
        throw new UnsupportedOperationException("This clinical statement does not have entryRelationship");
    }
}

