/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust.provider;

import com.google.inject.Provider;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.provider.TrustAnchorCertificateStoreProvider;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;

public class MultiDomainTrustAnchorResolverProvider
implements Provider<TrustAnchorResolver> {
    private final Map<String, Collection<X509Certificate>> incomingAnchors;
    private final Map<String, Collection<X509Certificate>> outgoingAnchors;

    public MultiDomainTrustAnchorResolverProvider(Map<String, Collection<X509Certificate>> incomingAnchors, Map<String, Collection<X509Certificate>> outgoingAnchors) {
        this.incomingAnchors = incomingAnchors;
        this.outgoingAnchors = outgoingAnchors;
    }

    public TrustAnchorResolver get() {
        Provider<CertificateResolver> incomingProvider = this.getTrustAnchorStoreProvider(this.incomingAnchors);
        Provider<CertificateResolver> outgoingProvider = this.getTrustAnchorStoreProvider(this.outgoingAnchors);
        return new DefaultTrustAnchorResolver((CertificateResolver)outgoingProvider.get(), (CertificateResolver)incomingProvider.get());
    }

    private Provider<CertificateResolver> getTrustAnchorStoreProvider(Map<String, Collection<X509Certificate>> certs) {
        return new TrustAnchorCertificateStoreProvider(certs);
    }
}

