/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.xmlpolicy.reader;

import java.util.ArrayList;
import org.realityforge.xmlpolicy.metadata.GrantMetaData;
import org.realityforge.xmlpolicy.metadata.KeyStoreMetaData;
import org.realityforge.xmlpolicy.metadata.PermissionMetaData;
import org.realityforge.xmlpolicy.metadata.PolicyMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PolicyReader {
    public PolicyMetaData readPolicy(Element element) throws Exception {
        String version = element.getAttribute("version");
        if (!"1.0".equals(version)) {
            String message = "Bad version:" + version;
            throw new Exception(message);
        }
        NodeList keyStoreConfigs = element.getElementsByTagName("keystore");
        KeyStoreMetaData[] keyStores = this.buildKeyStores(keyStoreConfigs);
        NodeList grantConfigs = element.getElementsByTagName("grant");
        GrantMetaData[] grants = this.buildGrants(grantConfigs);
        return new PolicyMetaData(keyStores, grants);
    }

    private GrantMetaData[] buildGrants(NodeList elements) throws Exception {
        ArrayList<GrantMetaData> grants = new ArrayList<GrantMetaData>();
        int length = elements.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)elements.item(i);
            GrantMetaData grant = this.buildGrant(element);
            grants.add(grant);
            ++i;
        }
        return grants.toArray(new GrantMetaData[grants.size()]);
    }

    private GrantMetaData buildGrant(Element element) throws Exception {
        String codeBase = this.getAttribute(element, "code-base");
        String signedBy = this.getAttribute(element, "signed-by");
        String keyStore = this.getAttribute(element, "key-store");
        if (null != signedBy && null == keyStore) {
            keyStore = "default";
        }
        NodeList permissionElements = element.getElementsByTagName("permission");
        PermissionMetaData[] permissions = this.buildPermissions(permissionElements);
        return new GrantMetaData(codeBase, signedBy, keyStore, permissions);
    }

    private PermissionMetaData[] buildPermissions(NodeList elements) throws Exception {
        ArrayList<PermissionMetaData> grants = new ArrayList<PermissionMetaData>();
        int length = elements.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)elements.item(i);
            PermissionMetaData permission = this.buildPermission(element);
            grants.add(permission);
            ++i;
        }
        return grants.toArray(new PermissionMetaData[grants.size()]);
    }

    private PermissionMetaData buildPermission(Element element) throws Exception {
        String classname = this.getAttribute(element, "class");
        String target = this.getAttribute(element, "target");
        String action = this.getAttribute(element, "action");
        String signedBy = this.getAttribute(element, "signed-by");
        String keyStore = this.getAttribute(element, "key-store");
        if (null != signedBy && null == keyStore) {
            keyStore = "default";
        }
        return new PermissionMetaData(classname, target, action, signedBy, keyStore);
    }

    private KeyStoreMetaData[] buildKeyStores(NodeList elements) throws Exception {
        ArrayList<KeyStoreMetaData> keyStores = new ArrayList<KeyStoreMetaData>();
        int length = elements.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)elements.item(i);
            KeyStoreMetaData keyStore = this.buildKeyStore(element);
            keyStores.add(keyStore);
            ++i;
        }
        return keyStores.toArray(new KeyStoreMetaData[keyStores.size()]);
    }

    private KeyStoreMetaData buildKeyStore(Element element) throws Exception {
        String name = element.getAttribute("name");
        String location = this.getAttribute(element, "location");
        String type = this.getAttribute(element, "type");
        return new KeyStoreMetaData(name, location, type);
    }

    private String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if ("".equals(value)) {
            return null;
        }
        return value;
    }
}

