/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.validator.DefaultLSResourceResolver;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.validation.ValidatingProcessor;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;

public class ValidatorComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(ValidatorComponent.class);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String resourceUri = remaining;
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)resourceUri);
        StreamSource source = new StreamSource(is);
        ValidatingProcessor validator = new ValidatingProcessor();
        validator.setSchemaSource((Source)source);
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        this.configureValidator(validator, uri, remaining, parameters);
        validator.loadSchema();
        return new ProcessorEndpoint(uri, (Component)this, (Processor)validator);
    }

    protected void configureValidator(ValidatingProcessor validator, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LSResourceResolver resourceResolver = (LSResourceResolver)this.resolveAndRemoveReferenceParameter(parameters, "resourceResolver", LSResourceResolver.class);
        if (resourceResolver != null) {
            validator.setResourceResolver(resourceResolver);
        } else {
            validator.setResourceResolver((LSResourceResolver)new DefaultLSResourceResolver(this.getCamelContext(), remaining));
        }
        this.setProperties(validator, parameters);
    }
}

