/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.salt.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.realityforge.salt.io.EndianUtil;

public class SwappedDataInputStream
implements DataInput {
    private InputStream m_input;

    public SwappedDataInputStream(InputStream input) {
        this.m_input = input;
    }

    public boolean readBoolean() throws IOException, EOFException {
        return 0 != this.readByte();
    }

    public byte readByte() throws IOException, EOFException {
        return (byte)this.m_input.read();
    }

    public int readUnsignedByte() throws IOException, EOFException {
        return this.m_input.read();
    }

    public char readChar() throws IOException, EOFException {
        return (char)this.readShort();
    }

    public short readShort() throws IOException, EOFException {
        return EndianUtil.readSwappedShort(this.m_input);
    }

    public int readUnsignedShort() throws IOException, EOFException {
        return EndianUtil.readSwappedUnsignedShort(this.m_input);
    }

    public int readInt() throws IOException, EOFException {
        return EndianUtil.readSwappedInteger(this.m_input);
    }

    public long readLong() throws IOException, EOFException {
        return EndianUtil.readSwappedLong(this.m_input);
    }

    public float readFloat() throws IOException, EOFException {
        return EndianUtil.readSwappedFloat(this.m_input);
    }

    public double readDouble() throws IOException, EOFException {
        return EndianUtil.readSwappedDouble(this.m_input);
    }

    public void readFully(byte[] data) throws IOException, EOFException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) throws IOException, EOFException {
        int remaining = length;
        while (remaining > 0) {
            int location = offset + (length - remaining);
            int count = this.read(data, location, remaining);
            if (-1 == count) {
                throw new EOFException();
            }
            remaining -= count;
        }
    }

    public String readLine() throws IOException, EOFException {
        throw new IOException("Operation not supported");
    }

    public String readUTF() throws IOException, EOFException {
        throw new IOException("Operation not supported");
    }

    public int skipBytes(int count) throws IOException, EOFException {
        return (int)this.skip(count);
    }

    public int available() throws IOException, EOFException {
        return this.m_input.available();
    }

    public int read() throws IOException, EOFException {
        return this.m_input.read();
    }

    public int read(byte[] data) throws IOException, EOFException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int offset, int length) throws IOException, EOFException {
        return this.m_input.read(data, offset, length);
    }

    public long skip(long count) throws IOException, EOFException {
        return this.m_input.skip(count);
    }

    public void mark(int readLimit) {
        this.m_input.mark(readLimit);
    }

    public boolean markSupported() {
        return this.m_input.markSupported();
    }

    public void reset() throws IOException {
        this.m_input.reset();
    }

    public void close() throws IOException, EOFException {
        this.m_input.close();
    }
}

