/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.metagenerate;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avalon.phoenix.tools.metagenerate.MxinfoHelper;
import org.apache.avalon.phoenix.tools.metagenerate.NamedXmlSnippet;

public class MxinfoFactory {
    private JavaClass m_javaClass;
    private File m_destDir;
    private ArrayList m_attributes = new ArrayList();
    private ArrayList m_operations = new ArrayList();
    private MxinfoHelper m_mxinfo;

    public MxinfoFactory(File destDir, JavaClass javaClass) {
        this.m_javaClass = javaClass;
        this.m_destDir = destDir;
    }

    public void generate() throws IOException {
        int j;
        File file = new File(this.m_destDir, this.m_javaClass.getFullyQualifiedName().replace('.', File.separatorChar) + ".mxinfo");
        file.getParentFile().mkdirs();
        this.m_mxinfo = new MxinfoHelper(file);
        this.m_mxinfo.writeHeader(this.m_javaClass.getTagByName("phoenix:mx-topic").getNamedParameter("name"));
        JavaMethod[] methods = this.m_javaClass.getMethods();
        for (j = 0; j < methods.length; ++j) {
            this.makeAttribute(methods[j], this.m_mxinfo);
        }
        this.writeAttributes();
        this.m_mxinfo.writeOperationsHeader();
        methods = this.m_javaClass.getMethods();
        for (j = 0; j < methods.length; ++j) {
            this.makeOperation(methods[j], this.m_mxinfo);
        }
        this.writeOperations();
        this.m_mxinfo.writeFooter();
        this.m_mxinfo.close();
    }

    private void writeOperations() throws IOException {
        this.m_mxinfo.writeOperations(this.m_operations);
    }

    private void makeAttribute(JavaMethod method, MxinfoHelper mxinfo) {
        DocletTag attribute = method.getTagByName("phoenix:mx-attribute");
        if (attribute != null) {
            String attributeName = this.getName(method.getName());
            DocletTag tag = method.getTagByName("phoenix:mx-description");
            String comment = tag == null ? method.getComment() : tag.getValue();
            Type attributeType = method.getReturns();
            String attributeTypeString = attributeType.getValue() + (attributeType.isArray() ? "[]" : "");
            NamedXmlSnippet attr = mxinfo.makeAttrLines(attributeName, "\"" + comment + "\"", attributeTypeString);
            this.m_attributes.add(attr);
        }
    }

    private void writeAttributes() throws IOException {
        this.m_mxinfo.writeAttributes(this.m_attributes);
    }

    private void makeOperation(JavaMethod method, MxinfoHelper mxinfo) throws IOException {
        String xml = "";
        DocletTag attribute = method.getTagByName("phoenix:mx-operation");
        if (attribute != null) {
            String operationName = method.getName();
            String description = method.getComment();
            Type type = method.getReturns();
            String typeString = type.getValue() + (type.isArray() ? "[]" : "");
            xml = xml + mxinfo.makeOperationHeader(operationName, description, typeString);
            JavaParameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                xml = xml + this.makeOperationParameter(params[i], method, mxinfo);
            }
            xml = xml + mxinfo.makeOperationFooter();
            NamedXmlSnippet operation = new NamedXmlSnippet(operationName, xml);
            this.m_operations.add(operation);
        }
    }

    private String makeOperationParameter(JavaParameter param, JavaMethod method, MxinfoHelper mxinfo) throws IOException {
        String paramName = param.getName();
        DocletTag[] paramTags = method.getTagsByName("param");
        String paramDescription = "";
        for (int k = 0; k < paramTags.length; ++k) {
            String paramTagValue = paramTags[k].getValue().trim();
            if (!paramTagValue.startsWith(paramName)) continue;
            paramDescription = paramTagValue.substring(paramTagValue.indexOf(" ") + 1, paramTagValue.length());
        }
        Type paramType = param.getType();
        String paramTypeString = paramType.getValue() + (paramType.isArray() ? "[]" : "");
        return mxinfo.makeOperationParameter(paramName, paramDescription, paramTypeString);
    }

    private String getName(String name) {
        String retval = name;
        if (retval.startsWith("set") || retval.startsWith("get")) {
            retval = retval.substring(3, retval.length());
            retval = retval.substring(0, 1).toLowerCase() + retval.substring(1, retval.length());
        } else if (retval.startsWith("is")) {
            retval = retval.substring(2, retval.length());
            retval = retval.substring(0, 1).toLowerCase() + retval.substring(1, retval.length());
        }
        return retval;
    }
}

