/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.EntryDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoWriter;

public class XMLInfoWriter
implements InfoWriter {
    private static final String CONTEXT_CLASS = "org.apache.avalon.framework.context.Context";

    public void writeComponentInfo(ComponentInfo info, OutputStream outputStream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        this.writeHeader(writer);
        this.writeDoctype(writer, "component-info");
        writer.write("<component-info>");
        this.writeComponent(writer, info.getDescriptor());
        this.writeLoggers(writer, info.getLoggers());
        this.writeContext(writer, info.getContext());
        this.writeServices(writer, info.getServices());
        this.writeDependencies(writer, info.getDependencies());
        this.writeSchema(writer, "configuration", info.getConfigurationSchema());
        this.writeSchema(writer, "parameters", info.getParametersSchema());
        writer.write("</component-info>");
        ((Writer)writer).flush();
    }

    private void writeSchema(Writer writer, String category, SchemaDescriptor schema) throws IOException {
        String type;
        if (null == schema) {
            return;
        }
        writer.write("<" + category + "-schema");
        String location = schema.getLocation();
        if (!"".equals(location)) {
            writer.write(" location=\"");
            writer.write(location);
            writer.write("\"");
        }
        if (!"".equals(type = schema.getType())) {
            writer.write(" type=\"");
            writer.write(type);
            writer.write("\"");
        }
        writer.write("/>");
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>");
    }

    private void writeDoctype(Writer writer, String root) throws IOException {
        String doctype = "<!DOCTYPE " + root + " PUBLIC \"-//AVALON/Component Info DTD Version 1.0//EN\" " + "\"http://jakarta.apache.org/avalon/dtds/info/componentinfo_1_0.dtd\" >";
        writer.write(doctype);
    }

    private void writeComponent(Writer writer, ComponentDescriptor component) throws IOException {
        writer.write("<component type=\"");
        writer.write(component.getImplementationKey());
        Attribute[] attributes = component.getAttributes();
        if (0 == attributes.length) {
            writer.write("\"/>");
        } else {
            writer.write("\">");
            this.writeAttributes(writer, attributes);
            writer.write("</component>");
        }
    }

    private void writeLoggers(Writer writer, LoggerDescriptor[] loggers) throws IOException {
        if (0 == loggers.length) {
            return;
        }
        writer.write("<loggers>");
        for (int i = 0; i < loggers.length; ++i) {
            this.writeLogger(writer, loggers[i]);
        }
        writer.write("</loggers>");
    }

    private void writeLogger(Writer writer, LoggerDescriptor logger) throws IOException {
        writer.write("<logger name=\"");
        writer.write(logger.getName());
        Attribute[] attributes = logger.getAttributes();
        if (0 == attributes.length) {
            writer.write("\"/>");
        } else {
            writer.write("\">");
            this.writeAttributes(writer, attributes);
            writer.write("</logger>");
        }
    }

    private void writeContext(Writer writer, ContextDescriptor context) throws IOException {
        String type = context.getType();
        Attribute[] attributes = context.getAttributes();
        EntryDescriptor[] entrys = context.getEntrys();
        if (CONTEXT_CLASS.equals(type) && 0 == attributes.length && 0 == entrys.length) {
            return;
        }
        writer.write("<context");
        if (!CONTEXT_CLASS.equals(type)) {
            writer.write(" type=\"");
            writer.write(type);
            writer.write("\"");
        }
        if (0 == attributes.length && 0 == entrys.length) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (int i = 0; i < entrys.length; ++i) {
                this.writeEntry(writer, entrys[i]);
            }
            this.writeAttributes(writer, attributes);
            writer.write("</context>");
        }
    }

    private void writeEntry(Writer writer, EntryDescriptor entry) throws IOException {
        Attribute[] attributes;
        writer.write("<entry key=\"");
        writer.write(entry.getKey());
        writer.write("\" type=\"");
        writer.write(entry.getType());
        if (entry.isOptional()) {
            writer.write("\" optional=\"true");
        }
        if (0 == (attributes = entry.getAttributes()).length) {
            writer.write("\"/>");
        } else {
            writer.write("\">");
            this.writeAttributes(writer, attributes);
            writer.write("</entry>");
        }
    }

    private void writeServices(Writer writer, ServiceDescriptor[] services) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("<services>");
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            writer.write("<service type=\"");
            writer.write(service.getType());
            Attribute[] attributes = service.getAttributes();
            if (0 == attributes.length) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, attributes);
            writer.write("</service>");
        }
        writer.write("</services>");
    }

    private void writeDependencies(Writer writer, DependencyDescriptor[] dependencies) throws IOException {
        if (0 == dependencies.length) {
            return;
        }
        writer.write("<dependencies>");
        for (int i = 0; i < dependencies.length; ++i) {
            Attribute[] attributes;
            DependencyDescriptor dependency = dependencies[i];
            writer.write("<dependency ");
            if (!dependency.getKey().equals(dependency.getType())) {
                writer.write("key=\"");
                writer.write(dependency.getKey());
                writer.write("\" ");
            }
            writer.write("type=\"");
            writer.write(dependency.getType());
            if (dependency.isOptional()) {
                writer.write("\" optional=\"true");
            }
            if (0 == (attributes = dependency.getAttributes()).length) {
                writer.write("\"/>");
                continue;
            }
            writer.write("\">");
            this.writeAttributes(writer, attributes);
            writer.write("</dependency>");
        }
        writer.write("</dependencies>");
    }

    private void writeAttributes(Writer writer, Attribute[] attributes) throws IOException {
        for (int i = 0; i < attributes.length; ++i) {
            this.writeAttribute(writer, attributes[i]);
        }
    }

    private void writeAttribute(Writer writer, Attribute attribute) throws IOException {
        writer.write("<attribute name=\"");
        writer.write(attribute.getName());
        writer.write("\">");
        String[] names = attribute.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value = attribute.getParameter(name);
            writer.write("<param name=\"");
            writer.write(name);
            writer.write("\" value=\"");
            writer.write(value);
            writer.write("\"/>");
        }
        writer.write("</attribute>");
    }
}

