/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.FeatureDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoWriter;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;

public class LegacyBlockInfoWriter
implements InfoWriter {
    public void writeComponentInfo(ComponentInfo info, OutputStream outputStream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        this.writeHeader(writer);
        this.writeDoctype(writer);
        writer.write("<blockinfo>");
        this.writeBlock(writer, info);
        this.writeServices(writer, info.getServices());
        this.writeMxServices(writer, info.getServices());
        this.writeDependencies(writer, info.getDependencies());
        writer.write("</blockinfo>");
        ((Writer)writer).flush();
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>");
    }

    private void writeDoctype(Writer writer) throws IOException {
        String doctype = "<!DOCTYPE blockinfo PUBLIC \"-//PHOENIX/Block Info DTD Version 1.0//EN\" \"http://jakarta.apache.org/avalon/dtds/phoenix/blockinfo_1_0.dtd\">";
        writer.write("<!DOCTYPE blockinfo PUBLIC \"-//PHOENIX/Block Info DTD Version 1.0//EN\" \"http://jakarta.apache.org/avalon/dtds/phoenix/blockinfo_1_0.dtd\">");
    }

    private void writeBlock(Writer writer, ComponentInfo info) throws IOException {
        writer.write("<block>\n");
        writer.write("  <version>1.0</version>");
        SchemaDescriptor schema = info.getConfigurationSchema();
        if (null != schema) {
            String output = "  <schema-type>" + schema.getType() + "</schema-type>";
            writer.write(output);
        }
        writer.write("</block>");
    }

    private void writeServices(Writer writer, ServiceDescriptor[] services) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("<services>");
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (LegacyUtil.isMxService(service)) continue;
            this.writeService(writer, service.getType(), service);
        }
        writer.write("</services>");
    }

    private void writeMxServices(Writer writer, ServiceDescriptor[] services) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("<management-access-points>");
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!LegacyUtil.isMxService(service)) continue;
            this.writeService(writer, service.getType(), service);
        }
        writer.write("</management-access-points>");
    }

    private void writeDependencies(Writer writer, DependencyDescriptor[] dependencies) throws IOException {
        if (0 == dependencies.length) {
            return;
        }
        writer.write("<dependencies>");
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyDescriptor dependency = dependencies[i];
            if (dependency.isOptional()) continue;
            writer.write("<dependency>");
            String key = dependency.getKey();
            String type = dependency.getType();
            if (!key.equals(type)) {
                writer.write("<role>");
                writer.write(key);
                writer.write("</role>");
            }
            this.writeService(writer, type, dependency);
            writer.write("</dependency>");
        }
        writer.write("</dependencies>");
    }

    private void writeService(Writer writer, String type, FeatureDescriptor feature) throws IOException {
        writer.write("<service name=\"");
        writer.write(type);
        String version = LegacyUtil.getVersionString(feature);
        if (null != version) {
            writer.write("\" version=\"");
            writer.write(version);
        }
        writer.write("\"/>");
    }
}

