/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.infobuilder;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoReader;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;
import org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder;
import org.xml.sax.InputSource;

public final class LegacyBlockInfoReader
extends AbstractLogEnabled
implements InfoReader {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$framework$tools$infobuilder$LegacyBlockInfoReader == null ? (class$org$apache$avalon$phoenix$framework$tools$infobuilder$LegacyBlockInfoReader = LegacyBlockInfoReader.class$("org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyBlockInfoReader")) : class$org$apache$avalon$phoenix$framework$tools$infobuilder$LegacyBlockInfoReader));
    static /* synthetic */ Class class$org$apache$avalon$phoenix$framework$tools$infobuilder$LegacyBlockInfoReader;

    public ComponentInfo createComponentInfo(String implementationKey, InputStream inputStream) throws Exception {
        InputSource input = new InputSource(inputStream);
        Configuration configuration = ConfigurationBuilder.build(input, "-//PHOENIX/Block Info DTD Version 1.0//EN", this.getLogger());
        return this.build(implementationKey, configuration);
    }

    private ComponentInfo build(String classname, Configuration info) throws Exception {
        String topLevelName;
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("builder.creating-info.notice", (Object)classname);
            this.getLogger().debug(message);
        }
        if (!(topLevelName = info.getName()).equals("blockinfo")) {
            String message = REZ.getString("legacy.bad-toplevel-element.error", (Object)classname, (Object)topLevelName);
            throw new ConfigurationException(message);
        }
        Configuration configuration = null;
        configuration = info.getChild("block");
        ComponentDescriptor descriptor = this.buildComponentDescriptor(classname, configuration);
        String implementationKey = descriptor.getImplementationKey();
        ServiceDescriptor[] services = this.buildServices(info);
        configuration = info.getChild("dependencies");
        DependencyDescriptor[] dependencies = this.buildDependencies(implementationKey, configuration);
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("legacy.created-info.notice", (Object)classname, (Object)new Integer(services.length), (Object)new Integer(dependencies.length));
            this.getLogger().debug(message);
        }
        configuration = info.getChild("block");
        SchemaDescriptor schema = this.buildConfigurationSchema(classname, configuration);
        return new ComponentInfo(descriptor, services, LoggerDescriptor.EMPTY_SET, LegacyUtil.CONTEXT_DESCRIPTOR, dependencies, schema, null);
    }

    private SchemaDescriptor buildConfigurationSchema(String classname, Configuration configuration) {
        String schemaType = configuration.getChild("schema-type").getValue("");
        if ("".equals(schemaType)) {
            return null;
        }
        String location = LegacyUtil.getSchemaLocationFor(classname);
        return new SchemaDescriptor(location, schemaType, Attribute.EMPTY_SET);
    }

    private DependencyDescriptor[] buildDependencies(String classname, Configuration configuration) throws ConfigurationException {
        Configuration[] elements = configuration.getChildren("dependency");
        ArrayList<DependencyDescriptor> dependencies = new ArrayList<DependencyDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            DependencyDescriptor dependency = this.buildDependency(classname, elements[i]);
            dependencies.add(dependency);
        }
        return dependencies.toArray(DependencyDescriptor.EMPTY_SET);
    }

    private DependencyDescriptor buildDependency(String classname, Configuration dependency) throws ConfigurationException {
        String implementationKey = dependency.getChild("service").getAttribute("name");
        String key = dependency.getChild("role").getValue(null);
        if (null == key) {
            key = implementationKey;
        } else if (key.equals(implementationKey)) {
            String message = REZ.getString("builder.redundent-key.notice", (Object)classname, (Object)key);
            this.getLogger().warn(message);
        }
        return new DependencyDescriptor(key, implementationKey, false, Attribute.EMPTY_SET);
    }

    private ServiceDescriptor[] buildServices(Configuration info) throws ConfigurationException {
        ServiceDescriptor service;
        int i;
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        Configuration[] elements = info.getChild("services").getChildren("service");
        for (i = 0; i < elements.length; ++i) {
            service = this.buildService(elements[i], false);
            services.add(service);
        }
        elements = info.getChild("management-access-points").getChildren("service");
        for (i = 0; i < elements.length; ++i) {
            service = this.buildService(elements[i], true);
            services.add(service);
        }
        return services.toArray(ServiceDescriptor.EMPTY_SET);
    }

    private ServiceDescriptor buildService(Configuration service, boolean isManagement) throws ConfigurationException {
        String implementationKey = service.getAttribute("name");
        String version = service.getAttribute("version", null);
        ArrayList<Attribute> attributeSet = new ArrayList<Attribute>();
        if (null != version) {
            attributeSet.add(LegacyUtil.createVersionAttribute(version));
        }
        if (isManagement) {
            attributeSet.add(LegacyUtil.MX_ATTRIBUTE);
        }
        Attribute[] attributes = attributeSet.toArray(new Attribute[attributeSet.size()]);
        return new ServiceDescriptor(implementationKey, attributes);
    }

    private ComponentDescriptor buildComponentDescriptor(String classname, Configuration config) {
        String version = config.getChild("version").getValue("1.0");
        ArrayList<Attribute> attributeSet = new ArrayList<Attribute>();
        attributeSet.add(LegacyUtil.createVersionAttribute(version));
        Attribute[] attributes = attributeSet.toArray(new Attribute[attributeSet.size()]);
        return new ComponentDescriptor(classname, attributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

