/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.profile;

import org.apache.avalon.phoenix.containerkit.metadata.PartitionMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;

public class PartitionProfile {
    public static final PartitionProfile[] EMPTY_SET = new PartitionProfile[0];
    private final PartitionMetaData m_metaData;
    private final PartitionProfile[] m_partitions;
    private final ComponentProfile[] m_components;

    public PartitionProfile(PartitionMetaData metaData, PartitionProfile[] partitions, ComponentProfile[] components) {
        if (null == metaData) {
            throw new NullPointerException("metaData");
        }
        if (null == partitions) {
            throw new NullPointerException("partitions");
        }
        if (null == components) {
            throw new NullPointerException("components");
        }
        this.m_metaData = metaData;
        this.m_partitions = partitions;
        this.m_components = components;
    }

    public PartitionMetaData getMetaData() {
        return this.m_metaData;
    }

    public PartitionProfile[] getPartitions() {
        return this.m_partitions;
    }

    public ComponentProfile[] getComponents() {
        return this.m_components;
    }

    public PartitionProfile getPartition(String name) {
        for (int i = 0; i < this.m_partitions.length; ++i) {
            PartitionProfile partition = this.m_partitions[i];
            if (!partition.getMetaData().getName().equals(name)) continue;
            return partition;
        }
        return null;
    }

    public ComponentProfile getComponent(String name) {
        for (int i = 0; i < this.m_components.length; ++i) {
            ComponentProfile component = this.m_components[i];
            if (!component.getMetaData().getName().equals(name)) continue;
            return component;
        }
        return null;
    }
}

