/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.metadata;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.FeatureDescriptor;

public class ComponentMetaData
extends FeatureDescriptor {
    private final String m_name;
    private final String m_implementationKey;
    private final DependencyMetaData[] m_dependencies;
    private final Parameters m_parameters;
    private final Configuration m_configuration;

    public ComponentMetaData(String name, String implementationKey, DependencyMetaData[] dependencies, Parameters parameters, Configuration configuration, Attribute[] attributes) {
        super(attributes);
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (null == dependencies) {
            throw new NullPointerException("dependencies");
        }
        if (null == implementationKey) {
            throw new NullPointerException("implementationKey");
        }
        this.m_name = name;
        this.m_dependencies = dependencies;
        this.m_parameters = parameters;
        this.m_configuration = configuration;
        this.m_implementationKey = implementationKey;
    }

    public String getName() {
        return this.m_name;
    }

    public String getImplementationKey() {
        return this.m_implementationKey;
    }

    public DependencyMetaData[] getDependencies() {
        return this.m_dependencies;
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public DependencyMetaData getDependency(String key) {
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            if (!this.m_dependencies[i].getKey().equals(key)) continue;
            return this.m_dependencies[i];
        }
        return null;
    }

    public DependencyMetaData[] getDependencies(String key) {
        ArrayList<DependencyMetaData> result = new ArrayList<DependencyMetaData>();
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            DependencyMetaData dependency = this.m_dependencies[i];
            if (!dependency.getKey().equals(key)) continue;
            result.add(dependency);
        }
        return result.toArray(new DependencyMetaData[result.size()]);
    }
}

