/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.nhindirect.gateway.smtp.james.mailet.SendMail;
import org.openhealthtools.mdht.uml.cda.Author;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Patient;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.hl7.datatypes.ENXP;
import org.openhealthtools.mdht.uml.hl7.datatypes.ON;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;

public class StoreMail
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(StoreMail.class);

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = null;
        String sender = null;
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        JSONObject attachmentInfo = null;
        long size = 0L;
        Date date = null;
        long time = 0L;
        String subject = null;
        String attachments = null;
        String body = null;
        String html = null;
        Enumeration headers = null;
        String message_id = null;
        JSONObject header = new JSONObject();
        String to = null;
        String cc = null;
        String bcc = null;
        int priority = 3;
        String mailtype = "html";
        byte[] sermessage = null;
        boolean request_dispatched = false;
        try {
            message = mail.getMessage();
            recipients.addAll(mail.getRecipients());
            sender = mail.getSender().toString();
            size = mail.getMessageSize();
            date = mail.getLastUpdated();
            time = date != null ? date.getTime() / 1000L : new Date().getTime() / 1000L;
            subject = message.getSubject();
            attachmentInfo = this.parseAttachments(message);
            if (attachmentInfo != null) {
                attachments = (String)attachmentInfo.remove((Object)"json");
            }
            message_id = message.getHeader("message-id", null);
            headers = message.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header head = (Header)headers.nextElement();
                header.put((Object)head.getName(), (Object)head.getValue());
                if (head.getName().equalsIgnoreCase("to")) {
                    to = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("cc")) {
                    cc = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("bcc")) {
                    bcc = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("X-Priority")) {
                    priority = Integer.parseInt(head.getValue().replaceAll("[\\D]", ""));
                    continue;
                }
                if (head.getName().equalsIgnoreCase("original-id")) {
                    message_id = head.getValue();
                    continue;
                }
                if (head.getName().equalsIgnoreCase("mdn-message")) {
                    LOGGER.info((Object)("message is an mdn with disposition " + head.getValue()));
                    return;
                }
                if (!head.getName().equalsIgnoreCase("Disposition-Notification-Options")) continue;
                request_dispatched = head.getValue().toUpperCase().contains("X-DIRECT-FINAL-DESTINATION-DELIVERY");
            }
            try {
                body = this.parseBody(message.getContent(), message.getContentType(), "text/plain", 0);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Messaging execption while retrieving body.");
            }
            try {
                html = this.parseBody(message.getContent(), message.getContentType(), "text/html", 0);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Messaging execption while retrieving html.");
            }
            try {
                sermessage = this.serialize(message);
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Failed to serizlize message");
            }
            if (html == null) {
                mailtype = "html";
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving message.");
        }
        SendMail.sendMessage(recipients, sender, attachments, subject, body, html, time, size, header.toJSONString(), sermessage, message_id, to, cc, bcc, priority, mailtype, null, attachmentInfo, request_dispatched);
    }

    private JSONObject parseAttachments(MimeMessage message) {
        JSONObject attachmentInfo;
        JSONArray attachmentTypes;
        block9: {
            attachmentTypes = new JSONArray();
            attachmentInfo = new JSONObject();
            int count = 1;
            try {
                if (message.getContentType().contains("text/plain")) break block9;
                MimeMultipart attachments = new MimeMultipart();
                try {
                    attachments = (MimeMultipart)message.getContent();
                }
                catch (ClassCastException ce) {
                    attachments = null;
                }
                catch (IOException ie) {
                    LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.getCount(); ++i) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension((String)part.getFileName()) == null) continue;
                        attachmentInfo.put((Object)("patient" + count++), StoreMail.parseCCD(part, part.getFileName()));
                        attachmentTypes.add((Object)part.getFileName());
                    }
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        if (attachmentTypes.isEmpty()) {
            return null;
        }
        attachmentInfo.put((Object)"json", (Object)attachmentTypes.toJSONString());
        return attachmentInfo;
    }

    private String parseBody(Object content, String type, String get, int depth) throws IOException {
        try {
            if (!type.contains(get)) {
                MimeMultipart attachments;
                if (type.contains("multipart") && depth < 5) {
                    try {
                        attachments = (MimeMultipart)content;
                    }
                    catch (ClassCastException ce) {
                        return null;
                    }
                } else {
                    return null;
                }
                for (int i = 0; i < attachments.getCount(); ++i) {
                    BodyPart part = attachments.getBodyPart(i);
                    String body = this.parseBody(part.getContent(), part.getContentType(), get, depth + 1);
                    if (body == null) continue;
                    return body;
                }
                return null;
            }
            return content.toString();
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            return null;
        }
    }

    private byte[] serialize(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        message.writeTo((OutputStream)b);
        return b.toByteArray();
    }

    private static HashMap<String, String> parseCCD(BodyPart doc, String filename) {
        try {
            ClinicalDocument clinicalDocument = CDAUtil.load((InputStream)doc.getInputStream());
            HashMap<String, String> person = new HashMap<String, String>();
            if (clinicalDocument.getPatients() != null && clinicalDocument.getPatients().size() > 0) {
                Patient patient = (Patient)clinicalDocument.getPatients().get(0);
                if (patient.getNames() != null && patient.getNames().size() > 0 && ((PN)patient.getNames().get(0)).hasContent()) {
                    PN name = (PN)patient.getNames().get(0);
                    if (name.getGivens() != null && name.getGivens().size() > 0 && ((ENXP)name.getGivens().get(0)).hasContent()) {
                        person.put("given_name", ((ENXP)name.getGivens().get(0)).getText());
                    }
                    if (name.getFamilies() != null && name.getFamilies().size() > 0 && ((ENXP)name.getFamilies().get(0)).hasContent()) {
                        person.put("family_name", ((ENXP)name.getFamilies().get(0)).getText());
                    }
                }
                if (patient.getBirthTime() != null && patient.getBirthTime().hasContent()) {
                    person.put("date_of_birth", patient.getBirthTime().getValue());
                }
            }
            if (clinicalDocument.getTitle() != null) {
                person.put("title", clinicalDocument.getTitle().getText());
            }
            if (clinicalDocument.getAuthors() != null && clinicalDocument.getAuthors().size() > 0 && ((Author)clinicalDocument.getAuthors().get(0)).getAssignedAuthor().getRepresentedOrganization() != null && ((Author)clinicalDocument.getAuthors().get(0)).getAssignedAuthor().getRepresentedOrganization().getNames().size() > 0) {
                person.put("organization", ((ON)((Author)clinicalDocument.getAuthors().get(0)).getAssignedAuthor().getRepresentedOrganization().getNames().get(0)).getText());
            } else if (clinicalDocument.getCustodian() != null && clinicalDocument.getCustodian().getAssignedCustodian() != null && clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() != null && clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization().getName() != null) {
                person.put("organization", clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization().getName().getText());
            }
            person.put("file_hash", StoreMail.hashFile(doc.getInputStream(), filename));
            return person;
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)"Not a health document");
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Unkown error while parsing file");
        }
        return null;
    }

    private static String hashFile(InputStream is, String filename) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            filename = filename + new String(bytes);
            byte[] digest = sha1.digest(filename.getBytes());
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Failed to read file for hash");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.debug((Object)"SHA one could not been used");
        }
        return null;
    }
}

