/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.nhindirect.gateway.smtp.james.mailet.AddressCheck;
import org.nhindirect.gateway.smtp.james.mailet.LogMessage;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;
import org.nhindirect.gateway.smtp.james.mailet.SendErrors;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;

public class SendMail {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SendMail.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(ArrayList<MailAddress> recipients, String sender, String attachments, String subject, String body, String html, long time, long size, String headers, byte[] message, String message_id, String to, String cc, String bcc, int priority, String mailtype, AddressCheck lefttosend, JSONObject attachmentInfo, boolean request_dispatched) {
        block46: {
            Map<String, String> properties = MailetProperties.getPropertiesList();
            String db_hostname = properties.get("mailet.db.hostname");
            String db_port = properties.get("mailet.db.port");
            String db_name = properties.get("mailet.db.mailname");
            String db_instance = properties.get("mailet.db.instance");
            String db_userid = properties.get("mailet.db.mailusername");
            String product = properties.get("productname");
            String db_password = properties.get("mailet.db.mailpassword");
            String folder_path = properties.get("mailet.error.folder");
            String aes = properties.get("mailet.error.aes");
            String domainsProperty = properties.get("mailet.domain");
            String[] domainsList = domainsProperty.split(",");
            Connection conn = null;
            try {
                try {
                    conn = SendMail.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                }
                catch (SQLException e) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
                String sqlQuery = "INSERT INTO messages ([recipients], [sender], [mailbox_id] ,[attachments], [subject], [plain],[html],[timestamp], [folder_id], [size], [flags],[headers] ,[raw_mime],  [message_id],  [seen], [draft], [sent],[archived],[to],[cc],[bcc],[priority],[mailtype]) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?,?,?,?,?,?)";
                PreparedStatement prepQuery = null;
                try {
                    if (conn != null) {
                        prepQuery = conn.prepareStatement(sqlQuery, 1);
                    }
                    if (prepQuery != null) {
                        if (recipients != null) {
                            JSONArray rjson = new JSONArray();
                            Iterator<MailAddress> riterator = recipients.iterator();
                            while (riterator.hasNext()) {
                                rjson.add((Object)riterator.next().toString());
                            }
                            prepQuery.setString(1, rjson.toJSONString());
                        } else {
                            prepQuery.setString(1, null);
                        }
                        prepQuery.setString(2, sender);
                        prepQuery.setString(4, attachments);
                        prepQuery.setString(5, subject);
                        prepQuery.setString(6, body);
                        prepQuery.setString(7, html);
                        prepQuery.setLong(8, time);
                        prepQuery.setString(9, null);
                        prepQuery.setLong(10, size);
                        prepQuery.setString(11, null);
                        prepQuery.setString(12, headers);
                        prepQuery.setString(13, new String(message));
                        prepQuery.setString(14, message_id);
                        prepQuery.setInt(15, 0);
                        prepQuery.setInt(16, 0);
                        prepQuery.setInt(17, 0);
                        prepQuery.setInt(18, 0);
                        prepQuery.setString(19, to);
                        prepQuery.setString(20, cc);
                        prepQuery.setString(21, bcc);
                        prepQuery.setInt(22, priority);
                        prepQuery.setString(23, mailtype);
                        if (lefttosend == null) {
                            lefttosend = new AddressCheck(recipients, domainsList);
                        }
                        if (!lefttosend.getFailed()) {
                            HashMap<MailAddress, Integer> mailboxes = new HashMap<MailAddress, Integer>(lefttosend.getMailbox());
                            int atPosition = sender.indexOf("@") + 1;
                            String currentdomain = sender.substring(atPosition);
                            boolean isLocal = Arrays.asList(domainsList).contains(currentdomain);
                            for (Map.Entry<MailAddress, Integer> mailbox : mailboxes.entrySet()) {
                                prepQuery.setInt(3, mailbox.getValue());
                                if (prepQuery.executeUpdate() == 0) {
                                    SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend, attachmentInfo, request_dispatched);
                                    return;
                                }
                                if (request_dispatched) {
                                    if (isLocal) {
                                        LogMessage.setMessageStatus(message_id, mailbox.getKey().toString(), 5, new Date().getTime() / 1000L);
                                    } else {
                                        SendMail.send_mdn(sender, NotificationType.Dispatched, mailbox.getKey().toString(), message_id, mailbox.getKey().getDomain(), product, subject, "Your message was successfully delivered");
                                    }
                                }
                                lefttosend.removeAddress(mailbox.getKey());
                                ResultSet rs = null;
                                int genKey = -1;
                                try {
                                    rs = prepQuery.getGeneratedKeys();
                                    if (rs.next()) {
                                        genKey = rs.getInt(1);
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                                if (genKey <= 0 || attachmentInfo == null) continue;
                                SendMail.addPatients(conn, genKey, (HashMap<String, Object>)attachmentInfo);
                            }
                            break block46;
                        }
                        SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend, attachmentInfo, request_dispatched);
                        break block46;
                    }
                    SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend, attachmentInfo, request_dispatched);
                }
                catch (SQLException e) {
                    SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend, attachmentInfo, request_dispatched);
                }
                finally {
                    if (prepQuery != null) {
                        try {
                            prepQuery.close();
                        }
                        catch (SQLException e) {
                            LOGGER.debug((Object)"Did not close prepQuery");
                        }
                    }
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    LOGGER.debug((Object)"Failed to close connection");
                }
            }
        }
    }

    private static Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn = null;
        if (db_hostname == null) {
            return null;
        }
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            return null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void localStore(ArrayList<MailAddress> recipients, String sender, String attachments, String subject, String body, String html, long time, long size, String headers, byte[] message, String message_id, String folder_path, String to, String cc, String bcc, int priority, String mailtype, String aes, AddressCheck lefttosend, JSONObject attachmentInfo, boolean request_dispatched) {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] key = (SendMail.sha256(aes) + salt).getBytes();
        key = Arrays.copyOf(key, 32);
        random.nextBytes(iv);
        String path = folder_path + "message" + message_id.hashCode() + System.currentTimeMillis() + ".ser";
        ArrayList<Object> ar = new ArrayList<Object>();
        IvParameterSpec IV = new IvParameterSpec(iv);
        ar.add(iv);
        ar.add(salt);
        ar.add(recipients);
        ar.add(SendMail.encrypt_String(sender, key, IV));
        ar.add(SendMail.encrypt_String(attachments, key, IV));
        ar.add(SendMail.encrypt_String(subject, key, IV));
        ar.add(SendMail.encrypt_String(body, key, IV));
        ar.add(SendMail.encrypt_String(html, key, IV));
        ar.add(SendMail.encrypt_String("" + time, key, IV));
        ar.add(SendMail.encrypt_String("" + size, key, IV));
        ar.add(SendMail.encrypt_String(headers, key, IV));
        ar.add(SendMail.encrypt(message, key, IV));
        ar.add(SendMail.encrypt_String(message_id, key, IV));
        ar.add(SendMail.encrypt_String(to, key, IV));
        ar.add(SendMail.encrypt_String(cc, key, IV));
        ar.add(SendMail.encrypt_String(bcc, key, IV));
        ar.add(SendMail.encrypt_String("" + priority, key, IV));
        ar.add(SendMail.encrypt_String(mailtype, key, IV));
        ar.add(SendMail.encrypt_String(request_dispatched ? "true" : "false", key, IV));
        ar.add(lefttosend);
        if (attachmentInfo != null) {
            ar.add(SendMail.encrypt_String(attachmentInfo.toJSONString(), key, IV));
        } else {
            ar.add(null);
        }
        SendErrors.lock();
        FileOutputStream fos = null;
        try {
            File file;
            URL url = new URL("file:" + path);
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.error((Object)"Path not found");
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.debug((Object)"failed to close out file");
                }
                SendErrors.unlock();
                return;
            }
            fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(ar);
            oos.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File Not Found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException in local store");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"failed to close out file");
            }
            SendErrors.unlock();
        }
    }

    private static byte[] encrypt_String(String plainText, byte[] encryptionKey, IvParameterSpec IV) {
        if (plainText == null) {
            return null;
        }
        byte[] enc = null;
        try {
            enc = SendMail.encrypt(plainText.getBytes("UTF-8"), encryptionKey, IV);
        }
        catch (UnsupportedEncodingException ex) {
            enc = SendMail.encrypt(plainText.getBytes(), encryptionKey, IV);
        }
        return enc;
    }

    private static byte[] encrypt(byte[] plainText, byte[] encryptionKey, IvParameterSpec IV) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error((Object)"No such algorithm exception while encrypting");
        }
        catch (NoSuchProviderException ex) {
            LOGGER.error((Object)"No such provider exception while encrypting");
        }
        catch (NoSuchPaddingException ex) {
            LOGGER.error((Object)"No such padding exception while encrypting");
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
        try {
            if (cipher == null) {
                return null;
            }
            cipher.init(1, (Key)key, IV);
        }
        catch (InvalidKeyException ex) {
            LOGGER.error((Object)"Invalid key exception while encrypting");
        }
        catch (InvalidAlgorithmParameterException ex) {
            LOGGER.error((Object)"Invalid algorithm paranerter exception while encrypting");
        }
        try {
            return cipher.doFinal(plainText);
        }
        catch (IllegalBlockSizeException ex) {
            LOGGER.error((Object)"Illegal block size exception while encrypting");
        }
        catch (BadPaddingException ex) {
            LOGGER.error((Object)"Bad padding exception while encrypting");
        }
        return null;
    }

    public static boolean isValidEmailAddress(String email) {
        if (email.contains("*")) {
            return false;
        }
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    private static String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void send_mdn(String to, NotificationType disposition, String from, String original_message_id, String domain, String product, String subject, String message) {
        try {
            Disposition disp = new Disposition(disposition);
            SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
            dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            message = "Your message: \r\n    From.....: " + to + " \r\n" + "    Subject..: " + StringEscapeUtils.escapeHtml((String)subject) + " \r\n" + message + " on " + new Date();
            MimeMultipartReport multiPart = new MimeMultipartReport();
            multiPart.setReportType("disposition-notification");
            Notification not = new Notification(disp);
            not.setOriginalMessageId(original_message_id);
            not.setFinalRecipient(from);
            not.setExtensions(Arrays.asList("X-DIRECT-FINAL-DESTINATION-DELIVERY"));
            ReportingUserAgent rua = new ReportingUserAgent(domain, MailetProperties.getPropertiesList().get("productname"));
            not.setReportingAgent(rua);
            not.setExplanation(message);
            NotificationMessage msg = new NotificationMessage(to, not);
            msg.setSubject(disposition + ": " + StringEscapeUtils.escapeHtml((String)subject));
            msg.setFrom((Address)new InternetAddress(from));
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            LOGGER.debug((Object)("Failed to send out " + disposition + " MDN to " + to));
        }
    }

    private static void addPatients(Connection conn, int message_id, HashMap<String, Object> patients) {
        String sqlQuery = "INSERT INTO patients (message_id,given_name,family_name,date_of_birth,title,organization,file_hash) VALUES (?,?,?,?,?,?,?)";
        PreparedStatement prepQuery = null;
        try {
            prepQuery = conn.prepareStatement(sqlQuery, 1);
            String[] inputs = new String[]{"given_name", "family_name", "date_of_birth", "title", "organization", "file_hash"};
            for (Map.Entry<String, Object> entry : patients.entrySet()) {
                HashMap patient = (HashMap)entry.getValue();
                if (patient == null) continue;
                prepQuery.clearParameters();
                prepQuery.setInt(1, message_id);
                int index = 2;
                for (String input : inputs) {
                    if (patient.containsKey(input)) {
                        prepQuery.setString(index, (String)patient.get(input));
                    } else {
                        prepQuery.setString(index, null);
                    }
                    ++index;
                }
                prepQuery.executeUpdate();
            }
        }
        catch (SQLException ex) {
            LOGGER.debug((Object)("Could not store patients for " + message_id));
        }
    }
}

