/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nhindirect.gateway.smtp.james.mailet.AddressCheck;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;
import org.nhindirect.gateway.smtp.james.mailet.SendMail;

public class SendErrors
implements Runnable {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SendErrors.class);
    private static Lock wrlock = new ReentrantLock();
    private static ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1);
    private static final Integer MAX_TIME = 10080;
    private static final Integer MIN_TIME = 1;

    public static void lock() {
        wrlock.lock();
    }

    public static void unlock() {
        wrlock.unlock();
    }

    private SendErrors() {
    }

    public static void startThread() throws MailetPropertiesException {
        Integer wait_time;
        Map<String, String> properties = MailetProperties.updatedPropertiesList();
        if (properties != null) {
            MailetProperties.setPropertiesList(properties);
            wait_time = MIN_TIME;
            try {
                wait_time = Integer.parseInt(properties.get("mailet.error.refresh"));
            }
            catch (NumberFormatException e) {
                wait_time = MIN_TIME;
            }
            if (wait_time < MIN_TIME) {
                wait_time = MIN_TIME;
            } else if (wait_time > MAX_TIME) {
                wait_time = MAX_TIME;
            }
        } else {
            throw new MailetPropertiesException("Failed to load properties");
        }
        SendErrors mm = new SendErrors();
        stpe.scheduleAtFixedRate(mm, wait_time.intValue(), wait_time.intValue(), TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        try {
            Map<String, String> properties = MailetProperties.updatedPropertiesList();
            if (properties != null) {
                MailetProperties.setPropertiesList(properties);
            }
            this.send();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unexpected Exception in SendErrors: Exception " + e.getClass() + " " + e.getMessage()));
        }
    }

    private void send() {
        File folder;
        Map<String, String> properties = MailetProperties.updatedPropertiesList();
        String folder_path = properties.get("mailet.error.folder");
        String aes = properties.get("mailet.error.aes");
        int sent = 0;
        SendErrors.lock();
        if (folder_path == null) {
            LOGGER.error((Object)"Folder path is null");
            SendErrors.unlock();
            return;
        }
        try {
            URL url = new URL("file:" + folder_path);
            folder = new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            SendErrors.unlock();
            LOGGER.error((Object)"Path not found");
            return;
        }
        catch (MalformedURLException ex) {
            SendErrors.unlock();
            LOGGER.error((Object)"Malformed Path");
            return;
        }
        File[] listOfFiles = null;
        try {
            listOfFiles = folder.listFiles();
        }
        catch (SecurityException se) {
            SendErrors.unlock();
            LOGGER.error((Object)"You do not have read permissions on the folder");
        }
        SendErrors.unlock();
        if (listOfFiles == null || listOfFiles.length == 0) {
            return;
        }
        if (aes != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!this.sendMessge(aes, listOfFiles[i])) continue;
                try {
                    if (!listOfFiles[i].delete()) {
                        LOGGER.error((Object)"Failed to delete message from local.");
                        continue;
                    }
                    ++sent;
                    continue;
                }
                catch (SecurityException se) {
                    LOGGER.error((Object)"You do not have permission to delete the file");
                }
            }
            LOGGER.info((Object)(sent + " messages were sent and deleted localy."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessge(String key, File file) {
        ObjectInputStream inobj = null;
        ArrayList arl = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            inobj = new ObjectInputStream(fis);
            Object obj = null;
            try {
                obj = inobj.readObject();
            }
            catch (ClassNotFoundException ex2) {
                LOGGER.error((Object)("Can't get object from file " + file));
                boolean bl = false;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug((Object)("Could not close file " + file));
                }
                return bl;
            }
            arl = (ArrayList)obj;
            inobj.close();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to load file " + file));
            boolean ex2 = false;
            return ex2;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Could not close file " + file));
            }
        }
        if (arl != null) {
            byte[] salt = (byte[])arl.get(1);
            byte[] aes = (SendErrors.sha256(key) + salt).getBytes();
            if ((aes = Arrays.copyOf(aes, 32)) != null) {
                IvParameterSpec IV = new IvParameterSpec((byte[])arl.get(0));
                ArrayList recipients = (ArrayList)arl.get(2);
                AddressCheck lefttosend = (AddressCheck)arl.get(19);
                try {
                    String sender = this.decryptString((byte[])arl.get(3), aes, IV);
                    String attachments = this.decryptString((byte[])arl.get(4), aes, IV);
                    String subject = this.decryptString((byte[])arl.get(5), aes, IV);
                    String body = this.decryptString((byte[])arl.get(6), aes, IV);
                    String html = this.decryptString((byte[])arl.get(7), aes, IV);
                    String timestring = this.decryptString((byte[])arl.get(8), aes, IV);
                    String sizestring = this.decryptString((byte[])arl.get(9), aes, IV);
                    String headers = this.decryptString((byte[])arl.get(10), aes, IV);
                    byte[] message = this.decrypt((byte[])arl.get(11), aes, IV);
                    String message_id = this.decryptString((byte[])arl.get(12), aes, IV);
                    String to = this.decryptString((byte[])arl.get(13), aes, IV);
                    String cc = this.decryptString((byte[])arl.get(14), aes, IV);
                    String bcc = this.decryptString((byte[])arl.get(15), aes, IV);
                    String prioritystring = this.decryptString((byte[])arl.get(16), aes, IV);
                    String mailtype = this.decryptString((byte[])arl.get(17), aes, IV);
                    JSONObject attachmentInfo = null;
                    String attachString = this.decryptString((byte[])arl.get(20), aes, IV);
                    if (attachString != null) {
                        try {
                            attachmentInfo = (JSONObject)new JSONParser().parse(attachString);
                        }
                        catch (ParseException ex) {
                            LOGGER.debug((Object)"Could not get attachmentInfo");
                        }
                    }
                    boolean request_dispatched = this.decryptString((byte[])arl.get(18), aes, IV).equals("true");
                    long time = 0L;
                    try {
                        time = Long.parseLong(timestring);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug((Object)"could not parse time");
                        time = new Date().getTime() / 1000L;
                    }
                    long size = 0L;
                    try {
                        size = Long.parseLong(sizestring);
                    }
                    catch (NumberFormatException e) {
                        size = message.length * 8;
                        LOGGER.debug((Object)"could not parse size");
                    }
                    int priority = 3;
                    try {
                        priority = Integer.parseInt(prioritystring);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug((Object)"could not parse priority");
                    }
                    SendMail.sendMessage(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, to, cc, bcc, priority, mailtype, lefttosend, attachmentInfo, request_dispatched);
                    return true;
                }
                catch (DecryptionException e1) {
                    LOGGER.debug((Object)"Failed to decrypt");
                    return false;
                }
            }
        } else {
            LOGGER.error((Object)"Failed to create send message.  No array");
        }
        return false;
    }

    private byte[] decrypt(byte[] cipherText, byte[] encryptionKey, IvParameterSpec IV) throws DecryptionException {
        Cipher cipher;
        if (cipherText == null) {
            return null;
        }
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecryptionException("No Such Algorithm for decryption");
        }
        catch (NoSuchProviderException e) {
            throw new DecryptionException("No Such Provider for decryption");
        }
        catch (NoSuchPaddingException e) {
            throw new DecryptionException("No Such Padding for decryption");
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
        try {
            cipher.init(2, (Key)key, IV);
        }
        catch (InvalidKeyException e) {
            throw new DecryptionException("Invalid Key For decryption");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new DecryptionException("Invalid Algorithm for decryption");
        }
        byte[] ret = null;
        try {
            ret = cipher.doFinal(cipherText);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptionException("Illegal block size for decryption");
        }
        catch (BadPaddingException e) {
            throw new DecryptionException("Bad Padding for decryption");
        }
        return ret;
    }

    private String decryptString(byte[] cipherText, byte[] encryptionKey, IvParameterSpec IV) throws DecryptionException {
        byte[] decrypted = this.decrypt(cipherText, encryptionKey, IV);
        if (decrypted != null) {
            String ret = null;
            try {
                ret = new String(decrypted, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                ret = new String(decrypted);
            }
            return ret;
        }
        return null;
    }

    private static String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class TimeException
    extends Exception {
        public TimeException(String message) {
            super(message);
        }
    }

    public static class DecryptionException
    extends Exception {
        public DecryptionException() {
        }

        public DecryptionException(String message) {
            super(message);
        }
    }

    public static class MailetPropertiesException
    extends Exception {
        public MailetPropertiesException() {
        }

        public MailetPropertiesException(String message) {
            super(message);
        }
    }
}

