/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.nhindirect.gateway.smtp.james.mailet.AddressCheck;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;

public class LogMessage {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(LogMessage.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int logMessageToLog(Mail mail, Connection conn, int log_success, int inbound_outbound, int mdn) {
        int genKey;
        block26: {
            String sqlQuery = mdn >= 0 ? "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success, mdn, storage_id,  protected_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success) VALUES (?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement prepQuery = null;
            genKey = -1;
            try {
                try {
                    prepQuery = conn.prepareStatement(sqlQuery, 1);
                }
                catch (SQLException se) {
                    LOGGER.trace((Object)"Failed to prepare SQL Server statement when logging to webmail.");
                }
                if (prepQuery == null) break block26;
                MimeMessage message = null;
                String log_inboundOutbound = Integer.toString(inbound_outbound);
                try {
                    message = mail.getMessage();
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message for logging to webmail.");
                }
                try {
                    Long log_time = System.currentTimeMillis() / 1000L;
                    int log_size = message != null ? message.getSize() / 1024 : 0;
                    String log_sender = LogMessage.parseFromAddress(message);
                    String log_recipient = LogMessage.parseRecipientsToJSON(message);
                    String log_attachmentTypes = LogMessage.parseAttachments(message);
                    try {
                        prepQuery.setString(1, Long.toString(log_time));
                        prepQuery.setString(2, Integer.toString(log_size));
                        prepQuery.setString(3, "" + log_sender);
                        prepQuery.setString(4, log_recipient);
                        prepQuery.setString(5, log_attachmentTypes);
                        prepQuery.setString(6, log_inboundOutbound);
                        prepQuery.setString(7, Integer.toString(log_success));
                        if (mdn >= 0) {
                            prepQuery.setString(8, Integer.toString(mdn));
                            if (inbound_outbound == 0 && mdn == 0 && message != null) {
                                LogMessage.storeMessageID(message);
                                prepQuery.setString(9, message.getHeader("storage-id", null));
                                prepQuery.setString(10, message.getHeader("protected-data", null));
                            } else {
                                prepQuery.setString(9, null);
                                prepQuery.setString(10, null);
                            }
                        }
                        try {
                            prepQuery.executeUpdate();
                            ResultSet rs = null;
                            try {
                                rs = prepQuery.getGeneratedKeys();
                                if (rs.next()) {
                                    genKey = rs.getInt(1);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (SQLException query_ex) {
                            LOGGER.trace((Object)"Failed to log message.");
                        }
                    }
                    catch (SQLException sql_ex) {
                        LOGGER.debug((Object)"Failed to prepare SQL statement when logging to webmail.");
                    }
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message variables for logging to webmail.");
                }
            }
            finally {
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.debug((Object)"failed to close query");
                    }
                }
            }
        }
        return genKey;
    }

    public static String parseFromAddress(MimeMessage message) {
        String from = null;
        try {
            Address[] froms = message.getFrom();
            if (froms != null) {
                String personal = ((InternetAddress)froms[0]).getPersonal();
                String from_address = ((InternetAddress)froms[0]).getAddress();
                from = personal != null ? "\"" + personal + "\" <" + from_address + ">" : from_address;
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving sender for logging.");
        }
        return from;
    }

    private static String parseRecipientsToJSON(MimeMessage message) {
        String log_recipient = "";
        try {
            Address[] recipsAddr = message.getAllRecipients();
            log_recipient = "[";
            if (recipsAddr != null) {
                for (Address addr : recipsAddr) {
                    InternetAddress inet_addr_recip = (InternetAddress)addr;
                    String cur_recip = "";
                    cur_recip = inet_addr_recip.getPersonal() != null ? cur_recip + "\"" + inet_addr_recip.getPersonal() + "\" <" + inet_addr_recip.getAddress() + ">" : cur_recip + inet_addr_recip.getAddress();
                    String escaped_recipients = cur_recip.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                    log_recipient = log_recipient + "\"" + escaped_recipients + "\",";
                }
            }
            log_recipient = log_recipient.substring(0, log_recipient.length() - 1);
            log_recipient = log_recipient + "]";
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving recipients for logging.");
        }
        return log_recipient;
    }

    public static String parseAttachments(MimeMessage message) {
        String attachmentTypes;
        block8: {
            attachmentTypes = "";
            try {
                MimeMultipart attachments;
                if (message.getContentType().equals("text/plain")) break block8;
                try {
                    attachments = (MimeMultipart)message.getContent();
                }
                catch (ClassCastException ce) {
                    attachments = null;
                }
                catch (IOException ie) {
                    LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                    attachments = null;
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                    attachments = null;
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.getCount(); ++i) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension((String)part.getFileName()) == null) continue;
                        attachmentTypes = attachmentTypes + FilenameUtils.getExtension((String)part.getFileName()) + " ";
                    }
                    attachmentTypes = attachmentTypes.trim();
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        return attachmentTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeMessageID(MimeMessage message) {
        block37: {
            try {
                PreparedStatement prepQuery;
                String sqlQuery;
                Connection conn;
                String db_password;
                String db_userid;
                String db_instance;
                String db_name;
                String db_port;
                String db_hostname;
                String storage_id;
                String message_id;
                block36: {
                    message_id = message.getHeader("message-id", null);
                    storage_id = message.getHeader("storage-id", null);
                    Map<String, String> properties = MailetProperties.getPropertiesList();
                    db_hostname = properties.get("mailet.db.hostname");
                    db_port = properties.get("mailet.db.port");
                    db_name = properties.get("mailet.db.mailname");
                    db_instance = properties.get("mailet.db.instance");
                    db_userid = properties.get("mailet.db.mailusername");
                    db_password = properties.get("mailet.db.mailpassword");
                    conn = null;
                    try {
                        try {
                            conn = LogMessage.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                        }
                        catch (SQLException e) {
                            LOGGER.trace((Object)"Failed to connect to SQL Server");
                        }
                        if (conn == null) break block36;
                        sqlQuery = "update messages set [message_id] = ? where [id] = ?";
                        prepQuery = null;
                        try {
                            try {
                                prepQuery = conn.prepareStatement(sqlQuery, 1);
                                if (prepQuery != null) {
                                    prepQuery.setString(1, message_id);
                                    prepQuery.setString(2, storage_id);
                                    prepQuery.executeUpdate();
                                }
                            }
                            finally {
                                if (prepQuery != null) {
                                    prepQuery.close();
                                }
                            }
                        }
                        catch (SQLException ex) {
                            LOGGER.trace((Object)"Failed to connect to SQL Server");
                        }
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                LOGGER.trace((Object)"Failed to close SQL Server");
                            }
                        }
                    }
                }
                try {
                    try {
                        conn = LogMessage.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                    }
                    catch (SQLException e) {
                        LOGGER.trace((Object)"Failed to connect to SQL Server");
                    }
                    if (conn == null) break block37;
                    sqlQuery = "update accounting_disclosure set [message_id] = ? where [messages_table_id] = ?";
                    prepQuery = null;
                    try {
                        try {
                            prepQuery = conn.prepareStatement(sqlQuery, 1);
                            if (prepQuery != null) {
                                prepQuery.setString(1, message_id);
                                prepQuery.setString(2, storage_id);
                                prepQuery.executeUpdate();
                            }
                        }
                        finally {
                            if (prepQuery != null) {
                                prepQuery.close();
                            }
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.trace((Object)"Failed to connect to SQL Server");
                    }
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            LOGGER.trace((Object)"Failed to close SQL Server");
                        }
                    }
                }
            }
            catch (MessagingException ex) {
                LOGGER.debug((Object)"Could not get messageID");
            }
        }
    }

    private static Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn;
        if (db_hostname == null) {
            return null;
        }
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            return null;
        }
        return conn;
    }

    public static ArrayList<MailAddress> sendExternalNotification(Connection conn, Mail mail) {
        Transport transport = null;
        Map<String, String> properties = MailetProperties.getPropertiesList();
        Properties system_properties = new Properties();
        system_properties.putAll(properties);
        Session session = Session.getInstance((Properties)system_properties);
        try {
            transport = session.getTransport();
            transport.connect();
        }
        catch (MessagingException m) {
            LOGGER.trace((Object)"Could not connect to mail server");
        }
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(mail.getRecipients());
        String ldap_protocol = properties.get("mailet.ldap.protocol");
        String ldap_host = properties.get("mailet.ldap.host");
        String ldap_port = properties.get("mailet.ldap.port");
        String ldap_domain = properties.get("mailet.ldap.domain");
        String ldap_user_dn = properties.get("mailet.ldap.user_dn");
        String ldap_prd = properties.get("mailet.ldap.password");
        String domainsProperty = properties.get("mailet.domain");
        String[] domainsList = domainsProperty.split(",");
        AddressCheck addresses = new AddressCheck(recipients, domainsList);
        InitialDirContext ctx = LogMessage.ldapConnect(ldap_host, ldap_port, ldap_protocol, ldap_domain, ldap_user_dn, ldap_prd);
        HashMap<MailAddress, Integer> mailboxes = addresses.getMailbox();
        for (Map.Entry<MailAddress, Integer> mailbox : mailboxes.entrySet()) {
            String username = mailbox.getKey().getLocalPart();
            if (addresses.isGroup(mailbox.getKey())) {
                ArrayList<String> memberList = LogMessage.getGroupMembership(ctx, username);
                ArrayList<String> external_addresses = LogMessage.getGroupExternalAddresses(ctx, conn, ldap_domain, memberList);
                for (int j = 0; j < external_addresses.size(); ++j) {
                    String externalMailAddress = external_addresses.get(j);
                    if (externalMailAddress == null || externalMailAddress.equals("")) continue;
                    MimeMessage message = LogMessage.createExternalNotification(ctx, mail, username, externalMailAddress, true);
                    try {
                        if (transport != null) {
                            Transport.send((Message)message);
                            continue;
                        }
                        LOGGER.info((Object)("Failed to send external notification to: " + username));
                        continue;
                    }
                    catch (MessagingException name_ex) {
                        LOGGER.debug((Object)"Exception when sending external notification.");
                    }
                }
                continue;
            }
            String external_address = LogMessage.getExternalAddress(conn, username);
            if (external_address == null || external_address.equals("")) continue;
            MimeMessage message = LogMessage.createExternalNotification(ctx, mail, username, external_address, false);
            try {
                if (transport != null) {
                    Transport.send((Message)message);
                    continue;
                }
                LOGGER.info((Object)("Failed to send external notification to: " + username));
            }
            catch (MessagingException name_ex) {
                LOGGER.debug((Object)"Exception when sending external notification.");
            }
        }
        return addresses.getBadAddress();
    }

    public static void proccessMessagesStatus(Mail mail, ArrayList<MailAddress> BadAddress) {
        String message_id;
        Map<String, String> properties = MailetProperties.getPropertiesList();
        MailAddress sender = mail.getSender();
        String domainsProperty = properties.get("mailet.domain");
        List<String> domains = Arrays.asList(domainsProperty.split(","));
        boolean isLocal = domains.contains(sender.getDomain());
        try {
            message_id = mail.getMessage().getHeader("message-id", null);
        }
        catch (MessagingException ex) {
            LOGGER.debug((Object)"Failed to get message id");
            return;
        }
        if (isLocal) {
            long time = mail.getLastUpdated().getTime() / 1000L;
            Collection recipients = mail.getRecipients();
            for (MailAddress recip : recipients) {
                if (domains.contains(recip.getDomain())) {
                    LogMessage.setMessageStatus(message_id, recip.toString(), 1, time);
                    LogMessage.update_accounting_disclosure(message_id, recip.toString(), time);
                    if (!BadAddress.contains(recip)) continue;
                    LogMessage.setMessageStatus(message_id, recip.toString(), 4, time);
                    continue;
                }
                LogMessage.setMessageStatus(message_id, recip.toString(), 0, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getExternalAddress(Connection conn, String username) {
        String address = null;
        String sqlQuery = "SELECT user_mail FROM users WHERE user_deleted_flag <> 1 AND user_ext_notify_flag = 1 AND user_name = ?";
        PreparedStatement prepQuery = null;
        try {
            prepQuery = conn.prepareStatement(sqlQuery);
            prepQuery.setString(1, username);
            ResultSet rs = null;
            try {
                rs = prepQuery.executeQuery();
                while (rs.next()) {
                    String externalMailAddress;
                    address = externalMailAddress = rs.getString("user_mail");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException sql_ex) {
            LOGGER.debug((Object)"Query for group member external email address failed.");
        }
        finally {
            if (prepQuery != null) {
                try {
                    prepQuery.close();
                }
                catch (SQLException sql_close_ex) {
                    LOGGER.debug((Object)"Failed to close prepared statement for external address lookup query.");
                }
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getGroupExternalAddresses(InitialDirContext ctx, Connection conn, String ldap_domain, ArrayList<String> users) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (int j = 0; j < users.size(); ++j) {
            String membername = users.get(j).toString().replace("uid=", "").replace(",ou=accounts," + ldap_domain, "");
            String sqlQuery = "SELECT user_mail,user_is_group FROM users WHERE user_deleted_flag <> 1 AND user_ext_group_notify_flag = 1 AND user_name = ?";
            PreparedStatement prepQuery = null;
            try {
                prepQuery = conn.prepareStatement(sqlQuery);
                prepQuery.setString(1, membername);
                ResultSet rs = null;
                try {
                    rs = prepQuery.executeQuery();
                    while (rs.next()) {
                        String externalMailAddress = rs.getString("user_mail");
                        addresses.add(externalMailAddress);
                    }
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException sql_ex) {
                LOGGER.debug((Object)"Query for group member external email address failed.");
                continue;
            }
            finally {
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    }
                    catch (SQLException sql_close_ex) {
                        LOGGER.debug((Object)"Failed to close prepared statement for external address lookup query.");
                    }
                }
            }
        }
        return addresses;
    }

    private static ArrayList<String> getGroupMembership(InitialDirContext ctx, String groupname) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {
                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            }
            catch (NamingException name_ex) {
                LOGGER.debug((Object)"Naming exception encountered while getting group membership.");
            }
            String group_cn = "";
            if (list != null) {
                while (list.hasMore()) {
                    String attr = ((Attribute)list.next()).toString();
                    if (attr.indexOf("member") != 0) continue;
                    String[] members = attr.replace("member: ", "").split(", ");
                    groups = new ArrayList<String>(Arrays.asList(members));
                    for (int j = 0; j < groups.size(); ++j) {
                        if (groups.get(j).toString().indexOf("uid=") == 0) continue;
                        groups.remove(j);
                    }
                }
            }
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered looking up group members.");
        }
        return groups;
    }

    private static InitialDirContext ldapConnect(String ldap_host, String ldap_port, String ldap_protocol, String ldap_domain, String ldap_user_dn, String ldap_prd) {
        InitialDirContext ctx = null;
        String ldapUrl = ldap_protocol + "://" + ldap_host + ":" + ldap_port + "/" + ldap_domain;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ht.put("java.naming.provider.url", ldapUrl);
        ht.put("java.naming.security.authentication", "simple");
        ht.put("java.naming.security.principal", ldap_user_dn);
        ht.put("java.naming.security.credentials", ldap_prd);
        try {
            ctx = new InitialDirContext(ht);
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered while sending group external notifications.");
            return null;
        }
        return ctx;
    }

    private static MimeMessage createExternalNotification(InitialDirContext ctx, Mail mail, String username, String address, boolean isGroup) {
        Map<String, String> properties = MailetProperties.getPropertiesList();
        Properties system_properties = new Properties();
        system_properties.putAll(properties);
        Session session = Session.getInstance((Properties)system_properties);
        String notificationSender = system_properties.getProperty("mailet.notification.sender");
        String supportEmail = system_properties.getProperty("mailet.supportEmail");
        String senderEmail = mail.getSender().toString();
        MimeMessage message = null;
        try {
            message = mail.getMessage();
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging Exception while creating external notifiction message.");
        }
        try {
            if (address != null && username != null && !address.equals("") && !username.equals("")) {
                String to = address;
                String host = system_properties.getProperty("mail.smtp.host");
                String product = system_properties.getProperty("productname");
                system_properties.setProperty("localhost", host);
                message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(notificationSender));
                message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(to));
                if (isGroup) {
                    String group_cn = LogMessage.getGroupCommonName(ctx, username);
                    message.setSubject(group_cn + " has a " + product + " message from: " + senderEmail);
                } else {
                    message.setSubject("You have a " + product + " message from: " + senderEmail);
                }
                message.setText("Hello,\r\n\r\nYou have received a new message from ");
                if (isGroup) {
                    message.setContent((Object)("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">" + product + "</h1><p>Hello,</p><p>Your group has received a new message from [" + senderEmail + "]. Please login to <a href=\"https://" + system_properties.get("mailet.domain") + "\">https://" + system_properties.get("mailet.domain") + "</a> to view the message.</p><p>Thank you,<br/>" + product + " Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>"), "text/html");
                } else {
                    message.setContent((Object)("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">" + product + "</h1><p>Hello,</p><p>You have received a new message from [" + senderEmail + "]. Please login to <a href=\"https://" + system_properties.get("mailet.domain") + "\">https://" + system_properties.get("mailet.domain") + "</a> to view the message.</p><p>Thank you,<br/>" + product + " Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>"), "text/html");
                }
                message.addHeader("DirectNotification", "localhost");
                if (isGroup) {
                    LOGGER.info((Object)"Sent external notifcation to group member");
                } else {
                    LOGGER.info((Object)"Sent external notifcation to user");
                }
            }
        }
        catch (MessagingException mex) {
            LOGGER.debug((Object)"Messaging exception encountered while sending group external notifications.");
        }
        return message;
    }

    private static String getGroupCommonName(InitialDirContext ctx, String groupname) {
        String cn = null;
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {
                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            }
            catch (NamingException name_ex) {
                LOGGER.debug((Object)"Naming exception encountered while getting group name.");
            }
            if (list != null) {
                while (list.hasMore()) {
                    String attr = ((Attribute)list.next()).toString();
                    if (attr.indexOf("cn") != 0) continue;
                    cn = attr.replace("cn: ", "");
                }
            }
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered looking up group name.");
        }
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessageStatus(String message_id, String recipt, int status_code, long time) {
        block17: {
            Map<String, String> properties = MailetProperties.getPropertiesList();
            String db_hostname = properties.get("mailet.db.hostname");
            String db_port = properties.get("mailet.db.port");
            String db_name = properties.get("mailet.db.mailname");
            String db_instance = properties.get("mailet.db.instance");
            String db_userid = properties.get("mailet.db.mailusername");
            String db_password = properties.get("mailet.db.mailpassword");
            Connection conn = null;
            try {
                try {
                    conn = LogMessage.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                }
                catch (SQLException e) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
                if (conn == null) break block17;
                String sqlQuery = "INSERT INTO message_status ([message_id],[status_code],[recipient],[timestamp]) values (?,?,?,?)";
                PreparedStatement prepQuery = null;
                try {
                    try {
                        prepQuery = conn.prepareStatement(sqlQuery);
                        if (prepQuery != null) {
                            prepQuery.setString(1, message_id);
                            prepQuery.setInt(2, status_code);
                            prepQuery.setString(3, recipt);
                            prepQuery.setLong(4, time);
                            prepQuery.executeUpdate();
                        }
                    }
                    finally {
                        if (prepQuery != null) {
                            prepQuery.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        LOGGER.trace((Object)"Failed to close SQL Server");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update_accounting_disclosure(String message_id, String sender, long time) {
        block18: {
            Map<String, String> properties = MailetProperties.getPropertiesList();
            String db_hostname = properties.get("mailet.db.hostname");
            String db_port = properties.get("mailet.db.port");
            String db_name = properties.get("mailet.db.mailname");
            String db_instance = properties.get("mailet.db.instance");
            String db_userid = properties.get("mailet.db.mailusername");
            String db_password = properties.get("mailet.db.mailpassword");
            Connection conn = null;
            try {
                try {
                    conn = LogMessage.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                }
                catch (SQLException e) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
                if (conn == null) break block18;
                String sqlQuery = "update accounting_disclosure set [received] = ? where [message_id] = ? and recipient = ?";
                PreparedStatement prepQuery = null;
                try {
                    try {
                        if (conn != null) {
                            prepQuery = conn.prepareStatement(sqlQuery);
                        }
                        if (prepQuery != null) {
                            prepQuery.setLong(1, time);
                            prepQuery.setString(2, message_id);
                            prepQuery.setString(3, sender);
                            prepQuery.executeUpdate();
                        }
                    }
                    finally {
                        if (prepQuery != null) {
                            prepQuery.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    LOGGER.trace((Object)"Failed to connect to SQL Server");
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        LOGGER.trace((Object)"Failed to close SQL Server");
                    }
                }
            }
        }
    }
}

