/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.util;

import java.util.ArrayList;
import org.apache.avalon.framework.Version;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.FeatureDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;
import org.apache.avalon.phoenix.metainfo.BlockDescriptor;
import org.apache.avalon.phoenix.metainfo.BlockInfo;
import org.apache.avalon.phoenix.metainfo.ServiceDescriptor;

public class ComponentInfoConverter {
    private ComponentInfoConverter() {
    }

    public static BlockInfo toBlockInfo(ComponentInfo component) {
        BlockDescriptor descriptor = ComponentInfoConverter.toBlockDescriptor(component);
        ServiceDescriptor[] services = ComponentInfoConverter.toPhoenixServices(component.getServices());
        ServiceDescriptor[] mxServices = ComponentInfoConverter.getMXServices(component.getServices());
        org.apache.avalon.phoenix.metainfo.DependencyDescriptor[] dependencys = ComponentInfoConverter.toPhoenixDependencys(component.getDependencies());
        return new BlockInfo(descriptor, services, mxServices, dependencys);
    }

    private static ServiceDescriptor[] getMXServices(org.apache.avalon.phoenix.framework.info.ServiceDescriptor[] services) {
        ArrayList<ServiceDescriptor> serviceSet = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < services.length; ++i) {
            if (!LegacyUtil.isMxService((org.apache.avalon.phoenix.framework.info.ServiceDescriptor)services[i])) continue;
            serviceSet.add(ComponentInfoConverter.toPhoenixService(services[i]));
        }
        return serviceSet.toArray(new ServiceDescriptor[serviceSet.size()]);
    }

    private static ServiceDescriptor[] toPhoenixServices(org.apache.avalon.phoenix.framework.info.ServiceDescriptor[] services) {
        ArrayList<ServiceDescriptor> serviceSet = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < services.length; ++i) {
            if (LegacyUtil.isMxService((org.apache.avalon.phoenix.framework.info.ServiceDescriptor)services[i])) continue;
            serviceSet.add(ComponentInfoConverter.toPhoenixService(services[i]));
        }
        return serviceSet.toArray(new ServiceDescriptor[serviceSet.size()]);
    }

    private static ServiceDescriptor toPhoenixService(org.apache.avalon.phoenix.framework.info.ServiceDescriptor service) {
        Version version = LegacyUtil.toVersion((FeatureDescriptor)service);
        return new ServiceDescriptor(service.getType(), version);
    }

    private static org.apache.avalon.phoenix.metainfo.DependencyDescriptor[] toPhoenixDependencys(DependencyDescriptor[] dependencies) {
        ArrayList<org.apache.avalon.phoenix.metainfo.DependencyDescriptor> depends = new ArrayList<org.apache.avalon.phoenix.metainfo.DependencyDescriptor>();
        for (int i = 0; i < dependencies.length; ++i) {
            depends.add(ComponentInfoConverter.toPhoenixDependency(dependencies[i]));
        }
        return depends.toArray(new org.apache.avalon.phoenix.metainfo.DependencyDescriptor[depends.size()]);
    }

    private static org.apache.avalon.phoenix.metainfo.DependencyDescriptor toPhoenixDependency(DependencyDescriptor dependency) {
        Version version = LegacyUtil.toVersion((FeatureDescriptor)dependency);
        ServiceDescriptor service = new ServiceDescriptor(dependency.getType(), version);
        return new org.apache.avalon.phoenix.metainfo.DependencyDescriptor(dependency.getKey(), service);
    }

    private static BlockDescriptor toBlockDescriptor(ComponentInfo component) {
        ComponentDescriptor descriptor = component.getDescriptor();
        Version version = LegacyUtil.toVersion((FeatureDescriptor)descriptor);
        SchemaDescriptor schema = component.getConfigurationSchema();
        String schemaType = null;
        if (null != schema) {
            schemaType = schema.getType();
        }
        return new BlockDescriptor(null, descriptor.getImplementationKey(), schemaType, version);
    }
}

