/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.deployer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.components.deployer.PhoenixProfileBuilder;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.containerkit.profile.ProfileBuilder;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;
import org.apache.avalon.phoenix.interfaces.ClassLoaderSet;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.ConfigurationValidator;
import org.apache.avalon.phoenix.interfaces.Deployer;
import org.apache.avalon.phoenix.interfaces.DeployerMBean;
import org.apache.avalon.phoenix.interfaces.DeploymentException;
import org.apache.avalon.phoenix.interfaces.InstallationException;
import org.apache.avalon.phoenix.interfaces.Installer;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.LogManager;
import org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder;
import org.apache.avalon.phoenix.tools.verifier.SarVerifier;
import org.realityforge.loggerstore.LoggerStore;
import org.xml.sax.InputSource;

public class DefaultDeployer
extends AbstractLogEnabled
implements Deployer,
Serviceable,
Initializable,
Disposable,
DeployerMBean {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$deployer$DefaultDeployer == null ? (class$org$apache$avalon$phoenix$components$deployer$DefaultDeployer = DefaultDeployer.class$("org.apache.avalon.phoenix.components.deployer.DefaultDeployer")) : class$org$apache$avalon$phoenix$components$deployer$DefaultDeployer));
    private final SarVerifier m_verifier = new SarVerifier();
    private final ProfileBuilder m_builder = new PhoenixProfileBuilder();
    private final Map m_installations = new Hashtable();
    private LogManager m_logManager;
    private Kernel m_kernel;
    private Installer m_installer;
    private ConfigurationRepository m_repository;
    private ClassLoaderManager m_classLoaderManager;
    private ConfigurationValidator m_validator;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$deployer$DefaultDeployer;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_kernel = (Kernel)serviceManager.lookup(Kernel.ROLE);
        this.m_repository = (ConfigurationRepository)serviceManager.lookup(ConfigurationRepository.ROLE);
        this.m_classLoaderManager = (ClassLoaderManager)serviceManager.lookup(ClassLoaderManager.ROLE);
        this.m_logManager = (LogManager)serviceManager.lookup(LogManager.ROLE);
        this.m_validator = (ConfigurationValidator)serviceManager.lookup(ConfigurationValidator.ROLE);
        this.m_installer = (Installer)serviceManager.lookup(Installer.ROLE);
    }

    public void initialize() throws Exception {
        this.setupLogger(this.m_builder);
        this.setupLogger(this.m_verifier);
    }

    public void dispose() {
        Set set = this.m_installations.keySet();
        String[] applications = set.toArray(new String[set.size()]);
        for (int i = 0; i < applications.length; ++i) {
            String name = applications[i];
            try {
                this.undeploy(name);
                continue;
            }
            catch (DeploymentException de) {
                String message = REZ.getString("deploy.undeploy-indispose.error", (Object)name, (Object)de.getMessage());
                this.getLogger().error(message, (Throwable)((Object)de));
            }
        }
    }

    public void redeploy(String name) throws DeploymentException {
        Map installation = (Map)this.m_installations.get(name);
        if (null == installation) {
            String message = REZ.getString("deploy.no-deployment.error", (Object)name);
            throw new DeploymentException(message);
        }
        try {
            File source = (File)installation.get("install:source");
            this.redeploy(name, source.toURL());
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void redeploy(String name, URL location) throws DeploymentException {
        this.m_kernel.lock();
        try {
            this.undeploy(name);
            this.deploy(name, location);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        finally {
            this.m_kernel.unlock();
        }
    }

    public void undeploy(String name) throws DeploymentException {
        Map installation = (Map)this.m_installations.remove(name);
        if (null == installation) {
            String message = REZ.getString("deploy.no-deployment.error", (Object)name);
            throw new DeploymentException(message);
        }
        try {
            this.m_kernel.removeApplication(name);
            this.m_installer.uninstall(installation);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void deploy(String name, String sarURL) throws DeploymentException {
        try {
            this.deploy(name, new URL(sarURL));
        }
        catch (MalformedURLException mue) {
            throw new DeploymentException(mue.getMessage(), mue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(String name, URL location) throws DeploymentException {
        if (this.m_installations.containsKey(name)) {
            String message = REZ.getString("deploy.already-deployed.error", (Object)name);
            throw new DeploymentException(message);
        }
        ResourceManager.clearResourceCache();
        Map installation = null;
        boolean success = false;
        try {
            try {
                installation = this.m_installer.install(name, location);
                Configuration config = this.getConfigurationFor(installation, "install:config", null);
                Configuration environment = this.getConfigurationFor(installation, "install:environment", null);
                Configuration assembly = this.getConfigurationFor(installation, "install:assembly", "-//PHOENIX/Assembly DTD Version 1.0//EN");
                File homeDirectory = (File)installation.get("install:home");
                File workDirectory = (File)installation.get("install:work");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("app.name", name);
                data.put("app.home", homeDirectory);
                Configuration logs = environment.getChild("logs", false);
                LoggerStore store = this.m_logManager.createHierarchy(logs, homeDirectory, workDirectory, data);
                ClassLoaderSet classLoaderSet = this.m_classLoaderManager.createClassLoaderSet(environment, data, homeDirectory, workDirectory);
                ClassLoader classLoader = classLoaderSet.getDefaultClassLoader();
                Configuration newConfig = this.processConfiguration(name, config);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("phoenix:assembly-name", name);
                parameters.put("phoenix:assembly", assembly);
                parameters.put("phoenix:config", newConfig);
                parameters.put("phoenix:classloader", classLoader);
                PartitionProfile profile = this.m_builder.buildProfile(parameters);
                this.m_verifier.verifySar(profile, classLoader);
                this.verifyConfiguration(profile, newConfig);
                this.validateConfiguration(profile, classLoader);
                this.m_kernel.addApplication(profile, homeDirectory, workDirectory, classLoader, store, classLoaderSet.getClassLoaders());
                this.m_installations.put(name, installation);
                String message = REZ.getString("deploy.notice.sar.add", (Object)name);
                this.getLogger().debug(message);
                return;
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (success || null == installation) throw throwable;
            try {
                this.m_installer.uninstall(installation);
                throw throwable;
            }
            catch (InstallationException ie) {
                this.getLogger().error(ie.getMessage(), (Throwable)((Object)ie));
            }
            throw throwable;
        }
    }

    private Configuration getConfigurationFor(Map install, String key, String schema) throws DeploymentException {
        String location = (String)install.get(key);
        try {
            return ConfigurationBuilder.build((InputSource)new InputSource(location), (String)schema, (Logger)this.getLogger());
        }
        catch (Exception e) {
            String message = REZ.getString("deploy.error.config.create", (Object)location);
            this.getLogger().error(message, (Throwable)e);
            throw new DeploymentException(message, e);
        }
    }

    private Configuration processConfiguration(String application, Configuration configuration) throws DeploymentException {
        DefaultConfiguration newConfiguration = new DefaultConfiguration("config");
        Configuration[] configurations = configuration.getChildren();
        for (int i = 0; i < configurations.length; ++i) {
            Configuration config = configurations[i];
            try {
                Configuration newConfig = this.m_repository.processConfiguration(application, config.getName(), config);
                newConfiguration.addChild(newConfig);
                continue;
            }
            catch (ConfigurationException ce) {
                throw new DeploymentException(ce.getMessage(), ce);
            }
        }
        return newConfiguration;
    }

    private void verifyConfiguration(PartitionProfile profile, Configuration config) throws DeploymentException {
        Configuration[] configurations = config.getChildren();
        PartitionProfile listenerPartition = profile.getPartition("listener");
        PartitionProfile blockPartition = profile.getPartition("block");
        for (int i = 0; i < configurations.length; ++i) {
            Configuration configuration = configurations[i];
            String name = configuration.getName();
            ComponentProfile component = listenerPartition.getComponent(name);
            if (null == component) {
                component = blockPartition.getComponent(name);
            }
            if (null != component) continue;
            String message = REZ.getString("deploy.error.extra.config", (Object)name);
            throw new DeploymentException(message);
        }
    }

    private void validateConfiguration(PartitionProfile profile, ClassLoader classLoader) throws DeploymentException {
        PartitionProfile[] partitions = profile.getPartitions();
        for (int i = 0; i < partitions.length; ++i) {
            this.validateConfiguration(partitions[i], classLoader);
        }
        ComponentProfile[] components = profile.getComponents();
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile component = components[i];
            boolean isValid = false;
            try {
                isValid = this.m_validator.isValid(component, classLoader);
            }
            catch (ConfigurationException e) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
            if (isValid) continue;
            String message = "Unable to validate configuration of component " + component.getMetaData().getName() + " of type " + component.getInfo().getDescriptor().getImplementationKey();
            throw new DeploymentException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

