/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.security.Policy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.components.classloader.SarLoaderResolver;
import org.apache.avalon.phoenix.components.classloader.SarPolicyResolver;
import org.apache.avalon.phoenix.components.classloader.SarPolicyVerifier;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.ExtensionManager;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.PackageManager;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;
import org.apache.avalon.phoenix.interfaces.ClassLoaderSet;
import org.realityforge.classman.builder.LoaderBuilder;
import org.realityforge.classman.builder.LoaderResolver;
import org.realityforge.classman.metadata.ClassLoaderMetaData;
import org.realityforge.classman.metadata.ClassLoaderSetMetaData;
import org.realityforge.classman.metadata.FileSetMetaData;
import org.realityforge.classman.metadata.JoinMetaData;
import org.realityforge.classman.reader.ClassLoaderSetReader;
import org.realityforge.classman.verifier.ClassLoaderVerifier;
import org.realityforge.configkit.PropertyExpander;
import org.realityforge.xmlpolicy.builder.PolicyBuilder;
import org.realityforge.xmlpolicy.builder.PolicyResolver;
import org.realityforge.xmlpolicy.metadata.PolicyMetaData;
import org.realityforge.xmlpolicy.reader.PolicyReader;
import org.w3c.dom.Element;

public class DefaultClassLoaderManager
extends AbstractLogEnabled
implements ClassLoaderManager,
Contextualizable,
Serviceable,
Initializable {
    private static final String CLASSLOADERS_ELEMENT = "classloaders";
    private PackageManager m_packageManager;
    private ClassLoader m_commonClassLoader;
    private final ClassLoaderVerifier m_verifier = new ClassLoaderVerifier();
    private final LoaderBuilder m_builder = new LoaderBuilder();
    private final ClassLoaderSetReader m_reader = new ClassLoaderSetReader();
    private Map m_predefinedLoaders;
    private final Map m_data = new HashMap();
    private final PropertyExpander m_expander = new PropertyExpander();

    public void contextualize(Context context) throws ContextException {
        this.m_commonClassLoader = (ClassLoader)context.get((Object)"common.classloader");
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        ExtensionManager extensionManager = (ExtensionManager)serviceManager.lookup(ExtensionManager.ROLE);
        this.m_packageManager = new PackageManager(extensionManager);
    }

    public void initialize() throws Exception {
        this.m_data.putAll(System.getProperties());
        HashMap<String, ClassLoader> defined = new HashMap<String, ClassLoader>();
        defined.put("*system*", this.m_commonClassLoader);
        this.m_predefinedLoaders = Collections.unmodifiableMap(defined);
    }

    public ClassLoaderSet createClassLoaderSet(Configuration environment, Map data, File homeDirectory, File workDirectory) throws Exception {
        Configuration policyConfig = environment.getChild("policy");
        Policy policy = this.configurePolicy(policyConfig, data, homeDirectory, workDirectory);
        ClassLoaderSetMetaData metaData = this.getLoaderMetaData(environment);
        this.m_verifier.verifyClassLoaderSet(metaData);
        SarLoaderResolver resolver = new SarLoaderResolver(this.m_packageManager, policy, homeDirectory, workDirectory);
        this.setupLogger(resolver);
        Map map = this.m_builder.buildClassLoaders(metaData, (LoaderResolver)resolver, this.m_predefinedLoaders);
        ClassLoader defaultClassLoader = (ClassLoader)map.get(metaData.getDefault());
        return new ClassLoaderSet(defaultClassLoader, map);
    }

    private ClassLoaderSetMetaData getLoaderMetaData(Configuration environment) throws Exception {
        boolean loaderDefined = this.isClassLoaderDefined(environment);
        if (!loaderDefined) {
            return this.createDefaultLoaderMetaData();
        }
        Configuration loaderConfig = environment.getChild(CLASSLOADERS_ELEMENT);
        Element element = ConfigurationUtil.toElement((Configuration)loaderConfig);
        return this.m_reader.build(element);
    }

    private ClassLoaderSetMetaData createDefaultLoaderMetaData() {
        String[] includes = new String[]{"SAR-INF/lib/*.jar"};
        String[] excludes = new String[]{};
        FileSetMetaData fileSet = new FileSetMetaData(".", includes, excludes);
        String name = "default";
        String parent = "*system*";
        String[] entrys = new String[]{"SAR-INF/classes/"};
        Extension[] extensions = new Extension[]{};
        FileSetMetaData[] filesets = new FileSetMetaData[]{fileSet};
        ClassLoaderMetaData loader = new ClassLoaderMetaData("default", "*system*", entrys, extensions, filesets);
        String[] predefined = new String[]{"*system*"};
        ClassLoaderMetaData[] classLoaders = new ClassLoaderMetaData[]{loader};
        JoinMetaData[] joins = new JoinMetaData[]{};
        return new ClassLoaderSetMetaData("default", predefined, classLoaders, joins);
    }

    private boolean isClassLoaderDefined(Configuration environment) {
        return null != environment.getChild(CLASSLOADERS_ELEMENT, false);
    }

    private Policy configurePolicy(Configuration configuration, Map data, File baseDirectory, File workDirectory) throws Exception {
        SarPolicyResolver resolver = new SarPolicyResolver(baseDirectory, workDirectory);
        this.setupLogger((Object)resolver);
        PolicyBuilder builder = new PolicyBuilder();
        PolicyReader reader = new PolicyReader();
        SarPolicyVerifier verifier = new SarPolicyVerifier();
        this.setupLogger((Object)verifier);
        Element element = ConfigurationUtil.toElement((Configuration)configuration);
        HashMap<String, String> newData = new HashMap<String, String>();
        newData.putAll(this.m_data);
        newData.putAll(data);
        newData.put("/", File.separator);
        this.m_expander.expandValues(element, newData);
        element.setAttribute("version", "1.0");
        try {
            PolicyMetaData policy = reader.readPolicy(element);
            verifier.verifyPolicy(policy);
            return builder.buildPolicy(policy, (PolicyResolver)resolver);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }
}

