/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSStore;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverConfig;

public class ProxyDNSStore
implements DNSStore {
    private static final int DEFAULT_RESOLVER_PORT = 53;
    private final String[] servers;
    private final int port;

    public ProxyDNSStore() {
        this(53);
    }

    public ProxyDNSStore(int port) {
        this(null, 53);
    }

    public ProxyDNSStore(Collection<String> servers) {
        this(servers, 53);
    }

    public ProxyDNSStore(Collection<String> servers, int port) {
        if (servers == null || servers.size() == 0) {
            String[] configedServers = ResolverConfig.getCurrentConfig().servers();
            this.servers = configedServers != null ? configedServers : null;
        } else {
            this.servers = new String[servers.size()];
            servers.toArray(this.servers);
        }
        this.port = port;
    }

    @Override
    public Message get(Message dnsMsg) throws DNSException {
        ExtendedResolver resolver = this.createExResolver(this.servers, this.port, 2, 2000);
        Message response = null;
        try {
            response = resolver.send(dnsMsg);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (response == null) {
            resolver.setTCP(true);
            try {
                response = resolver.send(dnsMsg);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return response;
    }

    private ExtendedResolver createExResolver(String[] servers, int port, int retries, int timeout) {
        ExtendedResolver retVal = null;
        try {
            retVal = new ExtendedResolver(servers);
            retVal.setRetries(retries);
            retVal.setTimeout(timeout);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return retVal;
    }
}

