/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.avalon.excalibur.io.IOUtil;

public final class FileUtil {
    public static final boolean contentEquals(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = IOUtil.contentEquals(input1, input2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            IOUtil.shutdownStream(input1);
            IOUtil.shutdownStream(input2);
            throw throwable;
        }
        IOUtil.shutdownStream(input1);
        IOUtil.shutdownStream(input2);
        return bl;
    }

    public static final File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static final URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = files[i].toURL();
            ++i;
        }
        return urls;
    }

    public static final String removeExtention(String filename) {
        return FileUtil.removeExtension(filename);
    }

    public static final String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static final String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static final String removePath(String filepath) {
        return FileUtil.removePath(filepath, File.separatorChar);
    }

    public static final String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static final String getPath(String filepath) {
        return FileUtil.getPath(filepath, File.separatorChar);
    }

    public static final String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static final void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static final void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static final void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy((InputStream)input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    public static final void copyURLToFile(URL source, File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy(input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
    }

    public static final String normalize(String path) {
        char firstChar;
        if (path.length() < 2) {
            return path;
        }
        StringBuffer buff = new StringBuffer(path);
        int length = path.length();
        String prefix = null;
        if (length > 2 && buff.charAt(1) == ':') {
            prefix = path.substring(0, 2);
            buff.delete(0, 2);
            path = path.substring(2);
            length -= 2;
        }
        boolean startsWithSlash = length > 0 && (buff.charAt(0) == '/' || buff.charAt(0) == '\\');
        boolean expStart = true;
        int ptCount = 0;
        int lastSlash = length + 1;
        int upLevel = 0;
        int i = length - 1;
        while (i >= 0) {
            switch (path.charAt(i)) {
                case '\\': {
                    buff.setCharAt(i, '/');
                }
                case '/': {
                    if (lastSlash == i + 1) {
                        buff.deleteCharAt(i);
                    }
                    switch (ptCount) {
                        case 1: {
                            buff.delete(i, lastSlash);
                            break;
                        }
                        case 2: {
                            ++upLevel;
                            break;
                        }
                        default: {
                            if (upLevel <= 0 || lastSlash == i + 1) break;
                            buff.delete(i, lastSlash + 3);
                            --upLevel;
                            break;
                        }
                    }
                    ptCount = 0;
                    expStart = true;
                    lastSlash = i;
                    break;
                }
                case '.': {
                    if (!expStart) break;
                    ++ptCount;
                    break;
                }
                default: {
                    ptCount = 0;
                    expStart = false;
                    break;
                }
            }
            --i;
        }
        switch (ptCount) {
            case 1: {
                buff.delete(0, lastSlash);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (upLevel > 0) {
                    if (startsWithSlash) {
                        return null;
                    }
                    upLevel = 1;
                }
                while (upLevel > 0) {
                    buff.delete(0, lastSlash + 3);
                    --upLevel;
                }
                break block9;
            }
        }
        length = buff.length();
        boolean isLengthNull = length == 0;
        char c = firstChar = isLengthNull ? (char)'\u0000' : buff.charAt(0);
        if (!startsWithSlash && !isLengthNull && firstChar == '/') {
            buff.deleteCharAt(0);
        } else if (startsWithSlash && (isLengthNull || !isLengthNull && firstChar != '/')) {
            buff.insert(0, '/');
        }
        if (prefix != null) {
            buff.insert(0, prefix);
        }
        return buff.toString();
    }

    public static final String catPath(String lookupPath, String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (!lookupPath.endsWith("/")) {
            int index = lookupPath.lastIndexOf("/");
            lookupPath = index < 0 ? "" : lookupPath.substring(0, index + 1);
        }
        return FileUtil.normalize(lookupPath + path);
    }

    public static final File resolveFile(File baseFile, String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        int i = start;
        while (i < chars.length) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (!doubleSeparator) {
                sb.append(chars[i]);
            }
            ++i;
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static final void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static final void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            String message = "File " + file + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static final void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static final void deleteDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectoryOnExit(directory);
        directory.deleteOnExit();
    }

    private static final void cleanDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                FileUtil.forceDeleteOnExit(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static final void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                String message = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file.mkdirs()) {
            String message = "Unable to create directory " + file;
            throw new IOException(message);
        }
    }

    public static final void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static final void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static final void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                FileUtil.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static final long sizeOfDirectory(String directory) {
        return FileUtil.sizeOfDirectory(new File(directory));
    }

    public static final long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }

    private FileUtil() {
    }
}

