/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.asn1.DERObject;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.x509.AbstractTBSField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.TBSFieldName;

public abstract class AbstractExtensionField<P>
extends AbstractTBSField<P>
implements ExtensionField<P> {
    static final long serialVersionUID = 5312652953460972702L;

    public AbstractExtensionField(boolean required) {
        super(required);
    }

    @Override
    public TBSFieldName getFieldName() {
        return TBSFieldName.EXTENSIONS;
    }

    @Override
    public boolean isCritical() {
        if (this.certificate == null) {
            throw new IllegalStateException("Certificate value is null");
        }
        Set<String> criticalOIDs = this.certificate.getCriticalExtensionOIDs();
        return criticalOIDs.contains(this.getExtentionIdentifier().getId());
    }

    protected DERObject getExtensionValue(X509Certificate cert) throws PolicyProcessException {
        String oid = this.getExtentionIdentifier().getId();
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return this.getObject(bytes);
    }
}

