/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.util.Collection;
import org.nhindirect.policy.IntegerPolicyOperatorExecutor;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;

public class UnaryIntegerPolicyOperatorExecutor<O>
implements IntegerPolicyOperatorExecutor<O> {
    protected final PolicyValue<O> operand;
    protected final PolicyOperator operator;

    public UnaryIntegerPolicyOperatorExecutor(PolicyValue<O> operand, PolicyOperator operator) {
        if (!operator.equals((Object)PolicyOperator.SIZE)) {
            throw new IllegalArgumentException("Operator " + operator.getOperatorText() + " is not allowed for this executor type.");
        }
        this.operand = operand;
        this.operator = operator;
    }

    @Override
    public PolicyValue<Integer> execute() {
        int retVal;
        switch (this.operator) {
            case SIZE: {
                Collection coll = (Collection)Collection.class.cast(this.operand.getPolicyValue());
                retVal = coll.size();
                break;
            }
            default: {
                retVal = 0;
            }
        }
        return PolicyValueFactory.getInstance(retVal);
    }
}

