/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import org.fusesource.hawtdb.api.Allocator;
import org.fusesource.hawtdb.api.OutOfSpaceException;
import org.fusesource.hawtdb.internal.page.Logging;
import org.fusesource.hawtdb.internal.util.Ranges;

public class SimpleAllocator
implements Allocator {
    private final Ranges freeRanges = new Ranges();
    private volatile int limit;

    public SimpleAllocator(int limit) {
        this.limit = limit;
        this.freeRanges.add(0, limit);
    }

    private void op_trace(String op, int page, int count) {
        if (Logging.traced(page)) {
            Logging.trace("%s: %d : %d", op, page, count);
        }
    }

    public synchronized int alloc(int size) throws OutOfSpaceException {
        for (Ranges.Range r : this.freeRanges) {
            if (r.size() < size) continue;
            int rc = r.start;
            this.op_trace("ALLOC", rc, size);
            this.freeRanges.remove(rc, size);
            return rc;
        }
        throw new OutOfSpaceException();
    }

    public synchronized void free(int pageId, int count) {
        this.freeRanges.add(pageId, count);
        this.op_trace("FREE", pageId, count);
    }

    public synchronized void unfree(int pageId, int count) {
        this.freeRanges.remove(pageId, count);
    }

    public synchronized void clear() throws UnsupportedOperationException {
        this.freeRanges.clear();
        this.freeRanges.add(0, this.limit);
    }

    public synchronized void setFreeRanges(Ranges freePages) throws UnsupportedOperationException {
        this.freeRanges.copy(freePages);
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isAllocated(int page) {
        return !this.freeRanges.contains(page);
    }

    public Ranges getFreeRanges() {
        return this.freeRanges;
    }

    public String toString() {
        return "{ free pages: " + this.freeRanges.toString() + " }";
    }
}

