/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.AbstractStreamPagedAccessor;
import org.fusesource.hawtdb.api.BTreeIndexFactory;
import org.fusesource.hawtdb.api.HashIndexFactory;
import org.fusesource.hawtdb.api.Index;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.PagedAccessor;
import org.fusesource.hawtdb.api.SortedIndex;
import org.fusesource.hawtdb.internal.index.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashIndex<Key, Value>
implements Index<Key, Value> {
    private final BTreeIndexFactory<Key, Value> BIN_FACTORY = new BTreeIndexFactory();
    private final Paged paged;
    private final int page;
    private final int maximumBucketCapacity;
    private final int minimumBucketCapacity;
    private final boolean fixedCapacity;
    private final int loadFactor;
    private final int initialBucketCapacity;
    private final boolean deferredEncoding;
    private Buckets<Key, Value> buckets;
    public static final Buffer MAGIC = new Buffer(new byte[]{104, 97, 115, 104});
    public static final int HEADER_SIZE = HashIndex.MAGIC.length + 8;
    private final PagedAccessor<Buckets<Key, Value>> BUCKET_PAGED_ACCESSOR = new AbstractStreamPagedAccessor<Buckets<Key, Value>>(){

        @Override
        protected void encode(Paged paged, DataOutputStream os, Buckets<Key, Value> data) throws IOException {
            os.write(HashIndex.MAGIC.data, HashIndex.MAGIC.offset, HashIndex.MAGIC.length);
            os.writeInt(((HashIndex)HashIndex.this).buckets.active);
            os.writeInt(((HashIndex)HashIndex.this).buckets.capacity);
            for (int i = 0; i < ((HashIndex)HashIndex.this).buckets.capacity; ++i) {
                os.writeInt(((HashIndex)HashIndex.this).buckets.bucketsIndex[i]);
            }
        }

        @Override
        protected Buckets<Key, Value> decode(Paged paged, DataInputStream is) throws IOException {
            Buckets buckets = new Buckets();
            Buffer magic = new Buffer(HashIndex.MAGIC.length);
            is.readFully(magic.data, magic.offset, magic.length);
            if (!magic.equals(MAGIC)) {
                throw new IOException("Not a hash page");
            }
            buckets.active = is.readInt();
            buckets.capacity = is.readInt();
            buckets.bucketsIndex = new int[buckets.capacity];
            for (int i = 0; i < buckets.capacity; ++i) {
                buckets.bucketsIndex[i] = is.readInt();
            }
            return buckets;
        }
    };

    public HashIndex(Paged paged, int page, HashIndexFactory<Key, Value> factory) {
        this.paged = paged;
        this.page = page;
        this.maximumBucketCapacity = factory.getMaximumBucketCapacity();
        this.minimumBucketCapacity = factory.getMinimumBucketCapacity();
        this.loadFactor = factory.getLoadFactor();
        this.deferredEncoding = factory.isDeferredEncoding();
        this.initialBucketCapacity = factory.getBucketCapacity();
        this.BIN_FACTORY.setKeyCodec(factory.getKeyCodec());
        this.BIN_FACTORY.setValueCodec(factory.getValueCodec());
        this.BIN_FACTORY.setDeferredEncoding(this.deferredEncoding);
        this.fixedCapacity = this.minimumBucketCapacity == this.maximumBucketCapacity && this.maximumBucketCapacity == this.initialBucketCapacity;
    }

    public HashIndex<Key, Value> create() {
        this.buckets = new Buckets();
        this.buckets.create(this, this.initialBucketCapacity);
        this.storeBuckets();
        return this;
    }

    public HashIndex<Key, Value> open() {
        this.loadBuckets();
        return this;
    }

    @Override
    public Value get(Key key) {
        return this.buckets.bucket(this, key).get(key);
    }

    @Override
    public boolean containsKey(Key key) {
        return this.buckets.bucket(this, key).containsKey(key);
    }

    @Override
    public Value put(Key key, Value value) {
        int capacity;
        SortedIndex<Key, Value> bucket = this.buckets.bucket(this, key);
        if (this.fixedCapacity) {
            return bucket.put(key, value);
        }
        boolean wasEmpty = bucket.isEmpty();
        Value put = bucket.put(key, value);
        if (wasEmpty) {
            ++this.buckets.active;
            this.storeBuckets();
        }
        if (this.buckets.active >= this.buckets.increaseThreshold && this.buckets.capacity != (capacity = Math.min(this.maximumBucketCapacity, this.buckets.capacity * 4))) {
            this.changeCapacity(capacity);
        }
        return put;
    }

    @Override
    public Value putIfAbsent(Key key, Value value) {
        int capacity;
        SortedIndex<Key, Value> bucket = this.buckets.bucket(this, key);
        if (this.fixedCapacity) {
            return bucket.putIfAbsent(key, value);
        }
        boolean wasEmpty = bucket.isEmpty();
        Value put = bucket.putIfAbsent(key, value);
        if (wasEmpty) {
            ++this.buckets.active;
            this.storeBuckets();
        }
        if (this.buckets.active >= this.buckets.increaseThreshold && this.buckets.capacity != (capacity = Math.min(this.maximumBucketCapacity, this.buckets.capacity * 4))) {
            this.changeCapacity(capacity);
        }
        return put;
    }

    @Override
    public Value remove(Key key) {
        int capacity;
        SortedIndex<Key, Value> bucket = this.buckets.bucket(this, key);
        if (this.fixedCapacity) {
            return bucket.remove(key);
        }
        boolean wasEmpty = bucket.isEmpty();
        Object rc = bucket.remove(key);
        boolean isEmpty = bucket.isEmpty();
        if (!wasEmpty && isEmpty) {
            --this.buckets.active;
            this.storeBuckets();
        }
        if (this.buckets.active <= this.buckets.decreaseThreshold && this.buckets.capacity != (capacity = Math.max(this.minimumBucketCapacity, this.buckets.capacity / 2))) {
            this.changeCapacity(capacity);
        }
        return rc;
    }

    @Override
    public void clear() {
        this.buckets.clear(this);
        if (this.buckets.capacity != this.initialBucketCapacity) {
            this.changeCapacity(this.initialBucketCapacity);
        }
    }

    @Override
    public int size() {
        int rc = 0;
        for (int i = 0; i < this.buckets.capacity; ++i) {
            rc += this.buckets.bucket((HashIndex<int, Value>)this, i).size();
        }
        return rc;
    }

    @Override
    public boolean isEmpty() {
        return this.buckets.active == 0;
    }

    @Override
    public void destroy() {
        this.buckets.destroy(this);
        this.buckets = null;
        this.paged.free(this.page);
    }

    @Override
    public int getIndexLocation() {
        return this.page;
    }

    private void changeCapacity(int capacity) {
        Logging.debug("Resizing to: %d", capacity);
        Buckets next = new Buckets();
        next.create(this, capacity);
        for (int i = 0; i < this.buckets.capacity; ++i) {
            SortedIndex<int, Value> bin = this.buckets.bucket((HashIndex<int, Value>)this, i);
            HashSet<Integer> activeBuckets = new HashSet<Integer>();
            for (Map.Entry<int, Value> entry : bin) {
                int key = entry.getKey();
                Value value = entry.getValue();
                SortedIndex<int, Value> bucket = next.bucket(this, key);
                bucket.put(key, value);
                if (!activeBuckets.add(bucket.getIndexLocation())) continue;
                ++next.active;
            }
        }
        this.buckets.destroy(this);
        this.buckets = next;
        this.storeBuckets();
        Logging.debug("Resizing done.", new Object[0]);
    }

    public String toString() {
        return "{ page: " + this.page + ", buckets: " + this.buckets + " }";
    }

    private void storeBuckets() {
        if (this.deferredEncoding) {
            this.paged.put(this.BUCKET_PAGED_ACCESSOR, this.page, this.buckets);
        } else {
            this.BUCKET_PAGED_ACCESSOR.store(this.paged, this.page, this.buckets);
        }
    }

    private void loadBuckets() {
        this.buckets = this.deferredEncoding ? this.paged.get(this.BUCKET_PAGED_ACCESSOR, this.page) : this.BUCKET_PAGED_ACCESSOR.load(this.paged, this.page);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Buckets<Key, Value> {
        int active;
        int capacity;
        int[] bucketsIndex;
        int increaseThreshold;
        int decreaseThreshold;

        private Buckets() {
        }

        private void calcThresholds(HashIndex<Key, Value> index) {
            this.increaseThreshold = this.capacity * ((HashIndex)index).loadFactor / 100;
            this.decreaseThreshold = this.capacity * ((HashIndex)index).loadFactor * ((HashIndex)index).loadFactor / 20000;
        }

        void create(HashIndex<Key, Value> index, int capacity) {
            this.active = 0;
            this.capacity = capacity;
            this.bucketsIndex = new int[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.bucketsIndex[i] = ((HashIndex)index).BIN_FACTORY.create(((HashIndex)index).paged).getIndexLocation();
            }
            this.calcThresholds(index);
        }

        public void destroy(HashIndex<Key, Value> index) {
            this.clear(index);
            for (int i = 0; i < this.capacity; ++i) {
                ((HashIndex)index).paged.allocator().free(this.bucketsIndex[i], 1);
            }
        }

        public void clear(HashIndex<Key, Value> index) {
            for (int i = 0; i < ((HashIndex)index).buckets.capacity; ++i) {
                ((HashIndex)index).buckets.bucket(index, (Key)i).clear();
            }
            ((HashIndex)index).buckets.active = 0;
            ((HashIndex)index).buckets.calcThresholds(index);
        }

        SortedIndex<Key, Value> bucket(HashIndex<Key, Value> index, int bucket) {
            return ((HashIndex)index).BIN_FACTORY.open(((HashIndex)index).paged, this.bucketsIndex[bucket]);
        }

        SortedIndex<Key, Value> bucket(HashIndex<Key, Value> index, Key key) {
            int i = this.index(key);
            return ((HashIndex)index).BIN_FACTORY.open(((HashIndex)index).paged, this.bucketsIndex[i]);
        }

        int index(Key x) {
            return Math.abs(x.hashCode() % this.capacity);
        }

        public String toString() {
            return "{ capacity: " + this.capacity + ", active: " + this.active + ", increase threshold: " + this.increaseThreshold + ", decrease threshold: " + this.decreaseThreshold + " }";
        }
    }
}

