/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fusesource.hawtdb.api.BTreeIndexFactory;
import org.fusesource.hawtdb.api.Index;
import org.fusesource.hawtdb.api.IndexFactory;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.SortedIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIndexFactory {
    private static final BTreeIndexFactory<String, Integer> INTERNAL_INDEX_FACTORY = new BTreeIndexFactory();
    private final Paged paged;
    private final SortedIndex<String, Integer> multiIndex;

    public MultiIndexFactory(Paged paged) {
        this.paged = paged;
        this.multiIndex = INTERNAL_INDEX_FACTORY.openOrCreate(paged);
    }

    public <Key, Value> Index<Key, Value> create(String indexName, IndexFactory<Key, Value> indexFactory) {
        if (!this.multiIndex.containsKey(indexName)) {
            Index<Key, Value> result = indexFactory.create(this.paged);
            this.multiIndex.put(indexName, result.getIndexLocation());
            return result;
        }
        throw new IllegalStateException("Index " + indexName + " already exists!");
    }

    public <Key, Value> Index<Key, Value> open(String indexName, IndexFactory<Key, Value> indexFactory) {
        Integer location = (Integer)this.multiIndex.get(indexName);
        if (location != null) {
            Index<Key, Value> result = indexFactory.open(this.paged, location);
            return result;
        }
        throw new IllegalStateException("Index " + indexName + " doesn't exist!");
    }

    public <Key, Value> Index<Key, Value> openOrCreate(String indexName, IndexFactory<Key, Value> indexFactory) {
        Integer location = (Integer)this.multiIndex.get(indexName);
        Index<Key, Value> result = null;
        if (location != null) {
            result = indexFactory.open(this.paged, location);
        } else {
            result = indexFactory.create(this.paged);
            this.multiIndex.put(indexName, result.getIndexLocation());
        }
        return result;
    }

    public Set<String> indexes() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.multiIndex) {
            result.add(entry.getKey());
        }
        return result;
    }
}

