/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.List;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.apache.bcel.classfile.annotation.NameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.SimpleElementValue;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.AnnotationAccessVar;
import org.aspectj.weaver.bcel.BcelAnnotation;
import org.aspectj.weaver.bcel.BcelVar;

class AnnotationAccessFieldVar
extends BcelVar {
    private AnnotationAccessVar annoAccessor;
    private ResolvedType annoFieldOfInterest;

    public AnnotationAccessFieldVar(AnnotationAccessVar aav, ResolvedType annoFieldOfInterest) {
        super(annoFieldOfInterest, 0);
        this.annoAccessor = aav;
        this.annoFieldOfInterest = annoFieldOfInterest;
    }

    public void appendLoadAndConvert(InstructionList il, InstructionFactory fact, ResolvedType toType) {
        if (this.annoAccessor.getKind() != Shadow.MethodExecution) {
            return;
        }
        String annotationOfInterestSignature = this.annoAccessor.getType().getSignature();
        Member holder = this.annoAccessor.getMember();
        AnnotationAJ[] annos = holder.getAnnotations();
        for (int i = 0; i < annos.length; ++i) {
            ResolvedType rt;
            AnnotationGen annotation = ((BcelAnnotation)annos[i]).getBcelAnnotation();
            if (!annotation.getTypeSignature().equals(annotationOfInterestSignature)) continue;
            List<NameValuePair> vals = annotation.getValues();
            boolean doneAndDusted = false;
            for (NameValuePair object : vals) {
                ElementValue v;
                ElementValue o = object.getValue();
                if (o instanceof EnumElementValue) {
                    v = (EnumElementValue)object.getValue();
                    String s = ((EnumElementValue)v).getEnumTypeString();
                    rt = toType.getWorld().resolve(UnresolvedType.forSignature(s));
                    if (!rt.equals(toType)) continue;
                    il.append(fact.createGetStatic(rt.getName(), ((EnumElementValue)v).getEnumValueString(), Type.getType(rt.getSignature())));
                    doneAndDusted = true;
                    continue;
                }
                if (!(o instanceof SimpleElementValue)) continue;
                v = (SimpleElementValue)object.getValue();
                il.append(fact.createConstant(((SimpleElementValue)v).getValueString()));
                doneAndDusted = true;
                boolean stop = true;
            }
            if (doneAndDusted) continue;
            ResolvedMember[] annotationFields = toType.getWorld().resolve(UnresolvedType.forSignature(annotation.getTypeSignature())).getDeclaredMethods();
            for (int ii = 0; ii < annotationFields.length; ++ii) {
                if (!annotationFields[ii].getType().equals(this.annoFieldOfInterest)) continue;
                String dvalue = annotationFields[ii].getAnnotationDefaultValue();
                String typename = dvalue.substring(0, dvalue.lastIndexOf(59) + 1);
                String field = dvalue.substring(dvalue.lastIndexOf(59) + 1);
                rt = toType.getWorld().resolve(UnresolvedType.forSignature(typename));
                il.append(fact.createGetStatic(rt.getName(), field, Type.getType(rt.getSignature())));
            }
        }
    }

    public void insertLoad(InstructionList il, InstructionFactory fact) {
        if (this.annoAccessor.getKind() != Shadow.MethodExecution) {
            return;
        }
        this.appendLoadAndConvert(il, fact, this.annoFieldOfInterest);
    }

    public String toString() {
        return super.toString();
    }
}

