/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanOperationInfoSupport
extends MBeanOperationInfo
implements OpenMBeanOperationInfo,
Serializable {
    private static final long serialVersionUID = 4996859732565369366L;
    private OpenType returnOpenType;
    private transient int hashCode = 0;
    private transient String toStringName = null;

    public OpenMBeanOperationInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature, OpenType returnOpenType, int impact) {
        super(name, description, OpenMBeanOperationInfoSupport.createParameterInfo(signature), returnOpenType == null ? "" : returnOpenType.getClassName(), impact);
        this.returnOpenType = returnOpenType;
    }

    public OpenType getReturnOpenType() {
        return this.returnOpenType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof OpenMBeanOperationInfo) {
            OpenMBeanOperationInfo other = (OpenMBeanOperationInfo)obj;
            if (this.getName() == null && other.getName() == null || this.getName() != null && this.getName().equals(other.getName())) {
                if (other.getImpact() != this.getImpact()) {
                    return false;
                }
                if (this.getReturnOpenType() == null ? other.getReturnOpenType() != null : !this.getReturnOpenType().equals(other.getReturnOpenType())) {
                    return false;
                }
                return Arrays.equals(this.getSignature(), other.getSignature());
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getImpact();
            result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
            result = 37 * result + (this.getReturnOpenType() == null ? 0 : this.getReturnOpenType().hashCode());
            this.hashCode = result = 37 * result + (this.getSignature() == null ? 0 : Arrays.asList(this.getSignature()).hashCode());
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringName == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            sb.append("(name=");
            sb.append(this.getName());
            sb.append(",signature=");
            sb.append(Arrays.asList(this.getSignature()).toString());
            sb.append(",returnOpenType=");
            sb.append(this.returnOpenType.toString());
            sb.append(",impact=");
            sb.append(this.getImpact());
            sb.append(")");
            this.toStringName = sb.toString();
        }
        return this.toStringName;
    }

    private static MBeanParameterInfo[] createParameterInfo(OpenMBeanParameterInfo[] signature) {
        if (signature == null) {
            return null;
        }
        MBeanParameterInfo[] paramInfo = new MBeanParameterInfo[signature.length];
        System.arraycopy(signature, 0, paramInfo, 0, paramInfo.length);
        return paramInfo;
    }
}

