/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import com.google.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.SignatureValidationException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.cryptography.SignatureError;
import org.nhindirect.stagent.cryptography.SignatureException;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.cryptography.annotation.IncludeEpilogInSig;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;
import org.nhindirect.stagent.parser.EntitySerializer;

public class SMIMECryptographerImpl
implements Cryptographer {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SMIMECryptographerImpl.class);
    private static final DERObjectIdentifier x509CertificateObjectsIdent = new DERObjectIdentifier("1.2.840.113549.1.9.22.1");
    public static final SMIMECryptographerImpl Default = new SMIMECryptographerImpl();
    private EncryptionAlgorithm m_encryptionAlgorithm;
    private DigestAlgorithm m_digestAlgorithm;
    private boolean m_includeEpilogue = true;

    public SMIMECryptographerImpl() {
        OptionsParameter param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_SMIME_ENCRYPTION_ALGORITHM");
        this.m_encryptionAlgorithm = param == null ? EncryptionAlgorithm.AES128 : EncryptionAlgorithm.fromString(param.getParamValue(), EncryptionAlgorithm.AES128);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_SMIME_DIGEST_ALGORITHM");
        this.m_digestAlgorithm = param == null ? DigestAlgorithm.SHA1 : DigestAlgorithm.fromString(param.getParamValue(), DigestAlgorithm.SHA1);
    }

    public SMIMECryptographerImpl(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        this.m_encryptionAlgorithm = encryptionAlgorithm;
        this.m_digestAlgorithm = digestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.m_encryptionAlgorithm;
    }

    @Inject(optional=true)
    public void setEncryptionAlgorithm(EncryptionAlgorithm value) {
        this.m_encryptionAlgorithm = value;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    @Inject(optional=true)
    public void setDigestAlgorithm(DigestAlgorithm value) {
        this.m_digestAlgorithm = value;
    }

    public boolean isIncludeMultipartEpilogueInSignature() {
        return this.m_includeEpilogue;
    }

    @Inject(optional=true)
    public void setIncludeMultipartEpilogueInSignature(@IncludeEpilogInSig boolean value) {
        this.m_includeEpilogue = value;
    }

    @Override
    public MimeEntity encrypt(MimeMultipart entity, X509Certificate encryptingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(encryptingCertificate);
        return this.encrypt(entity, certs);
    }

    @Override
    public MimeEntity encrypt(MimeMultipart mmEntity, Collection<X509Certificate> encryptingCertificates) {
        MimeEntity entToEncrypt = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        try {
            mmEntity.writeTo((OutputStream)oStream);
            oStream.flush();
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-Type", mmEntity.getContentType());
            entToEncrypt = new MimeEntity(headers, oStream.toByteArray());
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidMimeEntity, e);
        }
        return this.encrypt(entToEncrypt, encryptingCertificates);
    }

    @Override
    public MimeEntity encrypt(MimeEntity entity, X509Certificate encryptingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(encryptingCertificate);
        return this.encrypt(entity, (Collection<X509Certificate>)certs);
    }

    @Override
    public MimeEntity encrypt(MimeEntity entity, Collection<X509Certificate> encryptingCertificates) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        MimeEntity partToEncrypt = entity;
        MimeBodyPart encryptedPart = this.encrypt((MimeBodyPart)partToEncrypt, encryptingCertificates);
        MimeEntity encryptedEntity = null;
        try {
            byte[] encBytes = EntitySerializer.Default.serializeToBytes((MimePart)encryptedPart);
            ByteArrayInputStream inStream = new ByteArrayInputStream(EntitySerializer.Default.serializeToBytes((MimePart)encryptedPart));
            encryptedEntity = new MimeEntity(inStream);
            if (LOGGER.isDebugEnabled()) {
                this.writePostEncypt(encBytes);
            }
            encryptedEntity.setHeader("Content-Type", "application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return encryptedEntity;
    }

    private MimeBodyPart encrypt(MimeBodyPart bodyPart, Collection<X509Certificate> encryptingCertificates) {
        return this.createEncryptedEnvelope(bodyPart, encryptingCertificates);
    }

    private MimeBodyPart createEncryptedEnvelope(MimeBodyPart bodyPart, Collection<X509Certificate> encryptingCertificates) {
        if (bodyPart == null || encryptingCertificates == null || encryptingCertificates.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (LOGGER.isDebugEnabled()) {
            this.writePreEncypt(EntitySerializer.Default.serializeToBytes((MimePart)bodyPart));
        }
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        for (X509Certificate cert : encryptingCertificates) {
            gen.addKeyTransRecipient(cert);
        }
        MimeBodyPart retVal = null;
        try {
            String encryAlgOID = this.toEncyAlgorithmOid(this.m_encryptionAlgorithm);
            retVal = gen.generate(bodyPart, encryAlgOID, CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm("KeyGenerator", encryAlgOID));
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    @Override
    public MimeEntity decrypt(Message message, X509CertificateEx decryptingCertificate) {
        return this.decrypt(message.extractMimeEntity(), decryptingCertificate);
    }

    @Override
    public MimeEntity decrypt(MimeEntity encryptedEntity, X509CertificateEx decryptingCertificate) {
        if (encryptedEntity == null || decryptingCertificate == null) {
            throw new IllegalArgumentException();
        }
        if (!decryptingCertificate.hasPrivateKey()) {
            throw new IllegalArgumentException("Certificate has no private key");
        }
        encryptedEntity.verifyContentType("application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        encryptedEntity.verifyTransferEncoding("base64");
        ArrayList<X509CertificateEx> certs = new ArrayList<X509CertificateEx>();
        certs.add(decryptingCertificate);
        MimeEntity retVal = this.decrypt(encryptedEntity, certs);
        return retVal;
    }

    @Override
    public MimeEntity decrypt(MimeEntity encryptedEntity, Collection<X509CertificateEx> decryptingCertificates) {
        if (decryptingCertificates == null || decryptingCertificates.size() == 0) {
            throw new IllegalArgumentException();
        }
        MimeEntity retEntity = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                byte[] encryptedContent = encryptedEntity.getContentAsBytes();
                this.writePreDecrypt(encryptedContent);
            }
            SMIMEEnveloped m = new SMIMEEnveloped((MimeBodyPart)encryptedEntity);
            for (X509CertificateEx decryptCert : decryptingCertificates) {
                RecipientId recId = this.generateRecipientSelector(decryptCert);
                RecipientInformationStore recipients = m.getRecipientInfos();
                RecipientInformation recipient = recipients.get(recId);
                if (recipient == null) continue;
                byte[] decryptedPayload = recipient.getContent((Key)decryptCert.getPrivateKey(), CryptoExtensions.getJCEProviderName());
                if (LOGGER.isDebugEnabled()) {
                    this.writePostDecrypt(decryptedPayload);
                }
                ByteArrayInputStream inStream = new ByteArrayInputStream(decryptedPayload);
                retEntity = new MimeEntity(inStream);
                break;
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        if (retEntity == null) {
            throw new NHINDException((Object)MimeError.Unexpected, "None of the the provided decryption certs were found in message's RecipientsInfo set.");
        }
        return retEntity;
    }

    private RecipientId generateRecipientSelector(X509Certificate decryptCert) {
        Class<?> loadClass;
        RecipientId retVal;
        block5: {
            retVal = null;
            loadClass = null;
            try {
                loadClass = this.getClass().getClassLoader().loadClass("org.bouncycastle.cms.jcajce.JceKeyTransRecipientId");
                Constructor<?> constructor = loadClass.getConstructor(X509Certificate.class);
                retVal = (RecipientId)constructor.newInstance(decryptCert);
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                StringBuilder builder = new StringBuilder("bcmail-jdk15-146 org.bouncycastle.cms.jcajce.JceKeyTransRecipientId class not found.");
                builder.append("\r\n\tAttempt to fall back to bcmail-jdk15-140 org.bouncycastle.cms.RecipientId");
                LOGGER.debug((Object)builder.toString());
            }
        }
        if (retVal == null) {
            try {
                loadClass = this.getClass().getClassLoader().loadClass("org.bouncycastle.cms.RecipientId");
                retVal = (RecipientId)loadClass.newInstance();
                retVal.setSerialNumber(decryptCert.getSerialNumber());
                retVal.setIssuer(decryptCert.getIssuerX500Principal().getEncoded());
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Attempt to fall back to bcmail-jdk15-140 org.bouncycastle.cms.RecipientId failed.", e);
            }
        }
        return retVal;
    }

    @Override
    public SignedEntity sign(Message message, X509Certificate signingCertificate) {
        return this.sign(message.extractEntityForSignature(this.m_includeEpilogue), signingCertificate);
    }

    @Override
    public SignedEntity sign(Message message, Collection<X509Certificate> signingCertificates) {
        return this.sign(message.extractEntityForSignature(this.m_includeEpilogue), signingCertificates);
    }

    @Override
    public SignedEntity sign(MimeEntity entity, X509Certificate signingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(signingCertificate);
        return this.sign(entity, certs);
    }

    @Override
    public SignedEntity sign(MimeEntity entity, Collection<X509Certificate> signingCertificates) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        MimeMultipart mm = this.createSignatureEntity(messageBytes, signingCertificates);
        SignedEntity retVal = null;
        try {
            retVal = new SignedEntity(new ContentType(mm.getContentType()), mm);
        }
        catch (ParseException e) {
            throw new MimeException(MimeError.InvalidHeader, (Exception)((Object)e));
        }
        return retVal;
    }

    private MimeMultipart createSignatureEntity(byte[] entity, Collection<X509Certificate> signingCertificates) {
        MimeMultipart retVal = null;
        try {
            MimeBodyPart signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(entity));
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.dES_EDE3_CBC);
            caps.addCapability(SMIMECapability.rC2_CBC, 128);
            caps.addCapability(SMIMECapability.dES_CBC);
            caps.addCapability(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            caps.addCapability(x509CertificateObjectsIdent);
            signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            for (X509Certificate signer : signingCertificates) {
                if (!(signer instanceof X509CertificateEx)) continue;
                generator.addSigner(((X509CertificateEx)signer).getPrivateKey(), signer, this.toDigestAlgorithmOid(this.m_digestAlgorithm), this.createAttributeTable(signedAttrs), null);
                certList.add(signer);
            }
            CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm("CertStore", "Collection"));
            generator.addCertificatesAndCRLs(certsAndcrls);
            CMSProcessableBodyPart content = new CMSProcessableBodyPart((BodyPart)signedContent);
            CMSSignedData signedData = generator.generate((CMSProcessable)content, false, CryptoExtensions.getJCEProviderName());
            String header = "signed; protocol=\"application/pkcs7-signature\"; micalg=" + this.toDigestAlgorithmMicalg(this.m_digestAlgorithm);
            String encodedSig = Base64.encodeBase64String((byte[])signedData.getEncoded());
            retVal = new MimeMultipart(header.toString());
            MimeBodyPart sig = new MimeBodyPart(new InternetHeaders(), encodedSig.getBytes("ASCII"));
            sig.addHeader("Content-Type", "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", "base64");
            retVal.addBodyPart((BodyPart)signedContent);
            retVal.addBodyPart((BodyPart)sig);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SignatureException(SignatureError.InvalidMultipartSigned, (Exception)e);
        }
        catch (Exception e) {
            throw new NHINDException((Object)MimeError.Unexpected, e);
        }
        return retVal;
    }

    private AttributeTable createAttributeTable(ASN1EncodableVector signedAttrs) {
        Constructor constr;
        AttributeTable retVal;
        block5: {
            retVal = null;
            try {
                constr = AttributeTable.class.getConstructor(DEREncodableVector.class);
                retVal = (AttributeTable)constr.newInstance(signedAttrs);
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block5;
                StringBuilder builder = new StringBuilder("bcmail-jdk15-140 AttributeTable(DERObjectIdentifier) constructor could not be loaded..");
                builder.append("\r\n\tAttempt to use to bcmail-jdk15-146 DERObjectIdentifier(ASN1EncodableVector)");
                LOGGER.debug((Object)builder.toString());
            }
        }
        if (retVal == null) {
            try {
                constr = AttributeTable.class.getConstructor(ASN1EncodableVector.class);
                retVal = (AttributeTable)constr.newInstance(signedAttrs);
            }
            catch (Throwable t) {
                LOGGER.error((Object)"Attempt to use to bcmail-jdk15-146 DERObjectIdentifier(ASN1EncodableVector constructor failed.", t);
            }
        }
        return retVal;
    }

    @Override
    public void checkSignature(SignedEntity signedEntity, X509Certificate signerCertificate, Collection<X509Certificate> anchors) throws SignatureValidationException {
        CMSSignedData signatureEnvelope = this.deserializeSignatureEnvelope(signedEntity);
        try {
            for (SignerInformation sigInfo : signatureEnvelope.getSignerInfos().getSigners()) {
                if (!sigInfo.verify(signerCertificate, CryptoExtensions.getJCEProviderName())) continue;
                return;
            }
            throw new SignatureValidationException("Signature validation failure.");
        }
        catch (SignatureValidationException sve) {
            throw sve;
        }
        catch (Exception e) {
            throw new SignatureValidationException("Signature validation failure.", e);
        }
    }

    @Override
    public CMSSignedData deserializeSignatureEnvelope(SignedEntity entity) {
        if (entity == null) {
            throw new NHINDException();
        }
        CMSSignedData signed = null;
        try {
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity.getContent());
            MimeBodyPart signedContent = null;
            signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            signed = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart((BodyPart)signedContent), entity.getMimeMultipart().getBodyPart(1).getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MimeException(MimeError.Unexpected, e);
        }
        return signed;
    }

    @Override
    public CMSSignedData deserializeEnvelopedSignature(MimeEntity envelopeEntity) {
        if (envelopeEntity == null) {
            throw new SignatureException(SignatureError.NullEntity);
        }
        if (!SMIMEStandard.isSignedEnvelope(envelopeEntity)) {
            throw new SignatureException(SignatureError.NotSignatureEnvelope);
        }
        byte[] envelopeBytes = EntitySerializer.Default.serializeToBytes((MimePart)envelopeEntity);
        return this.deserializeEnvelopedSignature(envelopeBytes);
    }

    @Override
    public CMSSignedData deserializeEnvelopedSignature(byte[] messageBytes) {
        CMSSignedData signed = null;
        try {
            signed = new CMSSignedData(messageBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MimeException(MimeError.Unexpected, e);
        }
        return signed;
    }

    private String toDigestAlgorithmOid(DigestAlgorithm type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException();
            }
            case SHA1: {
                return CMSSignedDataGenerator.DIGEST_SHA1;
            }
            case SHA256: {
                return CMSSignedDataGenerator.DIGEST_SHA256;
            }
            case SHA384: {
                return CMSSignedDataGenerator.DIGEST_SHA384;
            }
            case SHA512: 
        }
        return CMSSignedDataGenerator.DIGEST_SHA512;
    }

    private String toDigestAlgorithmMicalg(DigestAlgorithm type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException();
            }
            case SHA1: {
                return "sha1";
            }
            case SHA256: {
                return "sha256";
            }
            case SHA384: {
                return "sha384";
            }
            case SHA512: 
        }
        return "sha512";
    }

    private String toEncyAlgorithmOid(EncryptionAlgorithm type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException();
            }
            case RSA_3DES: {
                return SMIMEEnvelopedGenerator.DES_EDE3_CBC;
            }
            case AES128: {
                return SMIMEEnvelopedGenerator.AES128_CBC;
            }
            case AES192: {
                return SMIMEEnvelopedGenerator.AES192_CBC;
            }
            case AES256: 
        }
        return SMIMEEnvelopedGenerator.AES256_CBC;
    }

    private void writePreEncypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/preEncypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePostEncypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/postEncypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePreDecrypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/preDecrypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePostDecrypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/postDecrypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

