/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools.certgen;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.nhindirect.stagent.cert.tools.CreatePKCS12;
import org.nhindirect.stagent.cert.tools.certgen.CAPanel;
import org.nhindirect.stagent.cert.tools.certgen.CertCreateFields;
import org.nhindirect.stagent.cert.tools.certgen.CertGenerator;

class LeafCertGenDialog
extends JDialog {
    static final long serialVersionUID = -4500679031509430866L;
    private LeafGenPanel genPanel;

    public LeafCertGenDialog(Frame parent, CertCreateFields signer) {
        super(parent, "Certificate Creation", true);
        this.setResizable(false);
        this.setSize(700, 250);
        this.setResizable(false);
        Point pt = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(pt.x - 150, pt.y - 120);
        this.initUI(signer);
    }

    private void initUI(CertCreateFields signer) {
        this.getContentPane().setLayout(new BorderLayout());
        this.genPanel = new LeafGenPanel(signer);
        this.getContentPane().add(this.genPanel);
    }

    private static class LeafGenPanel
    extends CAPanel {
        static final long serialVersionUID = -3829240137598058532L;
        private CertCreateFields signer;
        private X509Certificate signerCert;
        private PrivateKey signerKey;

        public LeafGenPanel(CertCreateFields signer) {
            this.signer = signer;
            this.signerCert = signer.getSignerCert();
            this.signerKey = (PrivateKey)signer.getSignerKey();
            this.allowedToSign.setVisible(true);
            this.prePopulateFields();
        }

        @Override
        protected void initUI() {
            super.initUI();
            this.createCA.setVisible(false);
            this.loadCA.setVisible(false);
            this.certFileField.setVisible(false);
            this.keyFileField.setVisible(false);
        }

        private void prePopulateFields() {
            if (this.signer.getAttributes().containsKey("C")) {
                this.countryField.setText(this.signer.getAttributes().get("C").toString());
            } else {
                this.countryField.setText("");
            }
            if (this.signer.getAttributes().containsKey("ST")) {
                this.stateField.setText(this.signer.getAttributes().get("ST").toString());
            } else {
                this.stateField.setText("");
            }
            if (this.signer.getAttributes().containsKey("L")) {
                this.locField.setText(this.signer.getAttributes().get("L").toString());
            } else {
                this.locField.setText("");
            }
            if (this.signer.getAttributes().containsKey("O")) {
                this.orgField.setText(this.signer.getAttributes().get("O").toString());
            } else {
                this.orgField.setText("");
            }
            this.expField.setValue(this.signer.getExpDays());
        }

        @Override
        protected void createCACert() {
            CertCreateFields retCert;
            int selection;
            if (this.passField.getPassword().length == 0 && (selection = JOptionPane.showConfirmDialog(this, "The password field is empty.  Do you wish to create a private key file without a password?", "Empty Password", 0, 3)) == 1) {
                return;
            }
            if (this.cnField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Common Name (CN) must have a value.", "Invalid Cert File", 0);
                return;
            }
            if (this.emailField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "An email address is required.", "Invalid Email Address", 0);
                return;
            }
            try {
                new InternetAddress(this.emailField.getText());
            }
            catch (AddressException e) {
                JOptionPane.showMessageDialog(this, "The email address is an invalid address.", "Invalid Email Address", 0);
                return;
            }
            this.certFileField.setFile(this.createNewFileName(false));
            this.keyFileField.setFile(this.createNewFileName(true));
            if ((this.certFileField.getFile().exists() || this.keyFileField.getFile().exists()) && (selection = JOptionPane.showConfirmDialog(this, "The certificate or key file already exists for this email address.\r\nThis operation will overwrite the file.  Continue?", "Certificate Confilct", 0, 3)) == 1) {
                return;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("CN", this.cnField.getText());
            if (!this.countryField.getText().isEmpty()) {
                attributes.put("C", this.countryField.getText());
            }
            if (!this.stateField.getText().isEmpty()) {
                attributes.put("ST", this.stateField.getText());
            }
            if (!this.locField.getText().isEmpty()) {
                attributes.put("L", this.locField.getText());
            }
            if (!this.orgField.getText().isEmpty()) {
                attributes.put("O", this.orgField.getText());
            }
            if (!this.emailField.getText().isEmpty()) {
                attributes.put("EMAILADDRESS", this.emailField.getText());
            }
            attributes.put("ALLOWTOSIGN", Boolean.toString(this.allowedToSign.isSelected()));
            int exp = Integer.parseInt(this.expField.getValue().toString());
            int keyStre = Integer.parseInt(this.keyStr.getValue().toString());
            CertCreateFields createFields = new CertCreateFields(attributes, this.certFileField.getFile(), this.keyFileField.getFile(), this.passField.getPassword(), exp, keyStre, this.signerCert, this.signerKey);
            try {
                retCert = CertGenerator.createCertificate(createFields, this.addToAltSubjects.isSelected());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "An error occured creating the certificate: " + e.getMessage(), "Certificate Creation Error", 0);
                return;
            }
            if (retCert == null) {
                JOptionPane.showMessageDialog(this, "An error occured creating the certificate: unknown error", "Certificate Creation Error", 0);
                return;
            }
            File pcks12File = CreatePKCS12.create(retCert.getNewCertFile(), retCert.getNewKeyFile(), new String(this.passField.getPassword()), null);
            if (pcks12File == null) {
                JOptionPane.showMessageDialog(this, "An error occured creating the pkcs12 file: unknown error", "Certificate Creation Error", 0);
                return;
            }
            JOptionPane.showMessageDialog(this, "User/org certificate and private key created successfully:\r\n" + retCert.getNewCertFile().getName() + "\r\n" + retCert.getNewKeyFile().getName() + "\r\n" + pcks12File.getName(), "SUCCESS", -1);
            this.cnField.setText("");
            this.emailField.setText("");
            this.passField.clear();
        }
    }
}

