/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.consol.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.openhealthtools.mdht.uml.cda.AssignedAuthor;
import org.openhealthtools.mdht.uml.cda.Author;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Patient;
import org.openhealthtools.mdht.uml.cda.PatientRole;
import org.openhealthtools.mdht.uml.cda.consol.ConsolFactory;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;
import org.openhealthtools.mdht.uml.cda.consol.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.util.CDADiagnostic;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.cda.util.ValidationResult;
import org.openhealthtools.mdht.uml.hl7.datatypes.AD;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;
import org.openhealthtools.mdht.uml.hl7.vocab.NullFlavor;
import org.openhealthtools.mdht.uml.hl7.vocab.PostalAddressUse;

public class TestDischargeSummary {
    public static void main(String[] args) {
        System.out.println("=========================");
        TestDischargeSummary.testUSRealmAddressAndPatientName();
        System.out.println("=========================");
    }

    public static void testDS(String fileName) {
        new StringBuffer();
        String path = "samples/";
        ConsolPackage.eINSTANCE.eClass();
        ValidationResult result = new ValidationResult();
        try {
            ClinicalDocument clinicalDocument = CDAUtil.load((InputStream)new FileInputStream(String.valueOf(path) + fileName + ".xml"), (CDAUtil.ValidationHandler)result);
            System.out.println(clinicalDocument);
            System.out.println(clinicalDocument.getAllSections().size());
            for (Object j : clinicalDocument.getAllSections()) {
                System.out.println(j);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void validateDS(String fileName) {
        StringBuffer sb = new StringBuffer();
        String path = "samples/";
        ConsolPackage.eINSTANCE.eClass();
        ValidationResult result = new ValidationResult();
        try {
            CDAUtil.load((InputStream)new FileInputStream(String.valueOf(path) + fileName + ".xml"), (CDAUtil.ValidationHandler)result);
            for (Diagnostic dq : result.getErrorDiagnostics()) {
                CDADiagnostic cdaDiagnosticq = new CDADiagnostic(dq);
                sb.append("ERROR|" + cdaDiagnosticq.getMessage() + "|" + cdaDiagnosticq.getPath() + "|" + cdaDiagnosticq.getCode() + "|" + cdaDiagnosticq.getSource());
                sb.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sb);
    }

    public static void testUSRealmAddressAndPatientName() {
        ContinuityOfCareDocument document = ConsolFactory.eINSTANCE.createContinuityOfCareDocument().init();
        PatientRole patientRole = CDAFactory.eINSTANCE.createPatientRole();
        document.addPatientRole(patientRole);
        AD addr = DatatypesFactory.eINSTANCE.createAD();
        addr.addStreetAddressLine("123 Mockingbird Lane");
        addr.addCity("Springfield");
        addr.addCountry("US");
        addr.addPostalCode("12345");
        addr.getUses().add((Object)PostalAddressUse.H);
        patientRole.getAddrs().add((Object)addr);
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        patientRole.setPatient(patient);
        PN name = DatatypesFactory.eINSTANCE.createPN();
        name.addFamily("Doe");
        patient.getNames().add((Object)name);
        AD addr1 = DatatypesFactory.eINSTANCE.createAD();
        addr1.setNullFlavor(NullFlavor.NI);
        AssignedAuthor assgndAuthor = CDAFactory.eINSTANCE.createAssignedAuthor();
        Author author = CDAFactory.eINSTANCE.createAuthor();
        author.setAssignedAuthor(assgndAuthor);
        assgndAuthor.getAddrs().add((Object)addr1);
        document.getAuthors().add((Object)author);
        ValidationResult result = new ValidationResult();
        CDAUtil.validate((ClinicalDocument)document, (CDAUtil.ValidationHandler)result);
        System.out.println(result.getAllDiagnostics().size());
        for (Diagnostic diagnostic : result.getAllDiagnostics()) {
            CDADiagnostic cdaDiagnostic = new CDADiagnostic(diagnostic);
            EObject target = cdaDiagnostic.getTarget();
            if (!(target instanceof AD) && !(target instanceof PN)) continue;
            System.out.println(cdaDiagnostic.getMessage());
            System.out.println("target: " + target);
            System.out.println("");
        }
    }
}

