/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.matcher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;

public class RecipHostIsLocal
extends GenericMatcher {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(RecipHostIsLocal.class);
    private Set<String> domains = new HashSet<String>();

    public void init() {
        LOGGER.info((Object)"Initializing RecipHostIsLocal matcher.");
        String localDomains = this.getCondition();
        if (localDomains == null || localDomains.isEmpty()) {
            throw new SmtpAgentException(SmtpAgentError.Uninitialized, "Matcher condition must contain at least 1 local domain.");
        }
        String[] domainsParsed = localDomains.split(",");
        StringBuilder logMessage = new StringBuilder("Local matching domains:\r\n");
        for (String domain : domainsParsed) {
            logMessage.append("\t" + domain + "\r\n");
            this.domains.add(domain.toUpperCase(Locale.getDefault()));
        }
        LOGGER.info((Object)logMessage);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Vector<MailAddress> matching = new Vector<MailAddress>();
        for (MailAddress addr : mail.getRecipients()) {
            if (!this.domains.contains(addr.getDomain().toUpperCase(Locale.getDefault()))) continue;
            LOGGER.debug((Object)("Matched recipient " + addr.toString()));
            matching.add(addr);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)"Interrupted Exception when sleeping thread for RecipHostIsLocal");
        }
        return matching;
    }
}

