/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.MailAddress;
import org.nhindirect.gateway.smtp.james.mailet.MailetProperties;
import org.nhindirect.gateway.smtp.james.mailet.SendErrors;

public class SendMail {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SendMail.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(HashSet<MailAddress> recipients, String sender, String attachments, String subject, String body, String html, long time, long size, String headers, byte[] message, String message_id, String to, String cc, String bcc, int priority, String mailtype, HashSet<Integer> lefttosend) {
        Map<String, String> properties = MailetProperties.getPropertiesList();
        String db_hostname = properties.get("mailet.db.hostname");
        String db_port = properties.get("mailet.db.port");
        String db_name = properties.get("mailet.db.mailname");
        String db_instance = properties.get("mailet.db.instance");
        String db_userid = properties.get("mailet.db.mailusername");
        String db_password = properties.get("mailet.db.mailpassword");
        String folder_path = properties.get("mailet.error.folder");
        String aes = properties.get("mailet.error.aes");
        Connection conn = null;
        try {
            try {
                conn = SendMail.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
            }
            catch (SQLException e) {
                LOGGER.trace((Object)"Failed to connect to SQL Server");
            }
            String sqlQuery = "INSERT INTO messages ([recipients], [sender], [mailbox_id] ,[attachments], [subject], [plain],[html],[timestamp], [folder_id], [size], [flags],[headers] ,[raw_mime],  [message_id],  [seen], [draft], [sent],[archived],[to],[cc],[bcc],[priority],[mailtype]) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CAST(? AS VARCHAR(MAX)), ?, ?, ?,? ,?,?,?,?,?,?)";
            PreparedStatement prepQuery = null;
            try {
                if (conn != null) {
                    prepQuery = conn.prepareStatement(sqlQuery, 1);
                }
                if (prepQuery != null) {
                    if (recipients != null) {
                        String rstrint = "[";
                        Iterator<MailAddress> riterator = recipients.iterator();
                        boolean first = true;
                        while (riterator.hasNext()) {
                            if (first) {
                                first = false;
                            } else {
                                rstrint = rstrint + ",";
                            }
                            rstrint = rstrint + "\"" + riterator.next() + "\"";
                        }
                        prepQuery.setString(1, rstrint + "]");
                    } else {
                        prepQuery.setString(1, null);
                    }
                    prepQuery.setString(2, sender);
                    prepQuery.setString(4, attachments);
                    prepQuery.setString(5, subject);
                    prepQuery.setString(6, body);
                    prepQuery.setString(7, html);
                    prepQuery.setLong(8, time);
                    prepQuery.setString(9, null);
                    prepQuery.setLong(10, size);
                    prepQuery.setString(11, null);
                    prepQuery.setString(12, headers);
                    prepQuery.setBytes(13, message);
                    prepQuery.setString(14, message_id);
                    prepQuery.setInt(15, 0);
                    prepQuery.setInt(16, 0);
                    prepQuery.setInt(17, 0);
                    prepQuery.setInt(18, 0);
                    prepQuery.setString(19, to);
                    prepQuery.setString(20, cc);
                    prepQuery.setString(21, bcc);
                    prepQuery.setInt(22, priority);
                    prepQuery.setString(23, mailtype);
                    if (lefttosend == null) {
                        lefttosend = SendMail.check_users(recipients);
                    }
                    if (lefttosend != null) {
                        for (Integer mailbox : new HashSet<Integer>(lefttosend)) {
                            prepQuery.setInt(3, mailbox);
                            if (prepQuery.executeUpdate() == 0) {
                                SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend);
                                return;
                            }
                            lefttosend.remove(mailbox);
                        }
                    } else {
                        SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend);
                    }
                } else {
                    SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend);
                }
            }
            catch (SQLException e) {
                SendMail.localStore(recipients, sender, attachments, subject, body, html, time, size, headers, message, message_id, folder_path, to, cc, bcc, priority, mailtype, aes, lefttosend);
            }
            finally {
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    }
                    catch (SQLException e) {
                        LOGGER.debug((Object)"Did not close prepQuery");
                    }
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                LOGGER.debug((Object)"Failed to close connection");
            }
        }
    }

    private static Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn = null;
        if (db_hostname == null) {
            return null;
        }
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            return null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void localStore(HashSet<MailAddress> recipients, String sender, String attachments, String subject, String body, String html, long time, long size, String headers, byte[] message, String message_id, String folder_path, String to, String cc, String bcc, int priority, String mailtype, String aes, HashSet<Integer> lefttosend) {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] key = (SendMail.sha256(aes) + salt).getBytes();
        key = Arrays.copyOf(key, 32);
        random.nextBytes(iv);
        String path = folder_path + message_id.hashCode() + System.currentTimeMillis() + ".ser";
        ArrayList<Object> ar = new ArrayList<Object>();
        IvParameterSpec IV = new IvParameterSpec(iv);
        ar.add(iv);
        ar.add(salt);
        ar.add(recipients);
        ar.add(SendMail.encrypt_String(sender, key, IV));
        ar.add(SendMail.encrypt_String(attachments, key, IV));
        ar.add(SendMail.encrypt_String(subject, key, IV));
        ar.add(SendMail.encrypt_String(body, key, IV));
        ar.add(SendMail.encrypt_String(html, key, IV));
        ar.add(SendMail.encrypt_String("" + time, key, IV));
        ar.add(SendMail.encrypt_String("" + size, key, IV));
        ar.add(SendMail.encrypt_String(headers, key, IV));
        ar.add(SendMail.encrypt(message, key, IV));
        ar.add(SendMail.encrypt_String(message_id, key, IV));
        ar.add(SendMail.encrypt_String(to, key, IV));
        ar.add(SendMail.encrypt_String(cc, key, IV));
        ar.add(SendMail.encrypt_String(bcc, key, IV));
        ar.add(SendMail.encrypt_String("" + priority, key, IV));
        ar.add(SendMail.encrypt_String(mailtype, key, IV));
        ar.add(lefttosend);
        SendErrors.lock();
        FileOutputStream fos = null;
        try {
            File file;
            URL url = new URL("file:" + path);
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.error((Object)"Path not found");
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.debug((Object)"failed to close out file");
                }
                SendErrors.unlock();
                return;
            }
            fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(ar);
            oos.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File Not Found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException in local store");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"failed to close out file");
            }
            SendErrors.unlock();
        }
    }

    private static byte[] encrypt_String(String plainText, byte[] encryptionKey, IvParameterSpec IV) {
        if (plainText == null) {
            return null;
        }
        byte[] enc = null;
        try {
            enc = SendMail.encrypt(plainText.getBytes("UTF-8"), encryptionKey, IV);
        }
        catch (UnsupportedEncodingException ex) {
            enc = SendMail.encrypt(plainText.getBytes(), encryptionKey, IV);
        }
        return enc;
    }

    private static byte[] encrypt(byte[] plainText, byte[] encryptionKey, IvParameterSpec IV) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error((Object)"No such algorithm exception while encrypting");
        }
        catch (NoSuchProviderException ex) {
            LOGGER.error((Object)"No such provider exception while encrypting");
        }
        catch (NoSuchPaddingException ex) {
            LOGGER.error((Object)"No such padding exception while encrypting");
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
        try {
            if (cipher == null) {
                return null;
            }
            cipher.init(1, (Key)key, IV);
        }
        catch (InvalidKeyException ex) {
            LOGGER.error((Object)"Invalid key exception while encrypting");
        }
        catch (InvalidAlgorithmParameterException ex) {
            LOGGER.error((Object)"Invalid algorithm paranerter exception while encrypting");
        }
        try {
            return cipher.doFinal(plainText);
        }
        catch (IllegalBlockSizeException ex) {
            LOGGER.error((Object)"Illegal block size exception while encrypting");
        }
        catch (BadPaddingException ex) {
            LOGGER.error((Object)"Bad padding exception while encrypting");
        }
        return null;
    }

    public static boolean isValidEmailAddress(String email) {
        if (email.contains("*")) {
            return false;
        }
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    private static HashSet<Integer> check_users(HashSet<MailAddress> users) {
        Iterator<MailAddress> addresses = users.iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (addresses.hasNext()) {
            names.add(addresses.next().getLocalPart());
        }
        return MailetProperties.usernamesIDs(names);
    }

    private static String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

