/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.gateway.smtp.james.mailet.NHINDSecurityAndTrustMailet;

public class MailetProperties {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(MailetProperties.class);
    private static Map<String, String> propertiesMap = null;

    public static Map<String, String> getPropertiesList() {
        return propertiesMap;
    }

    public static void setPropertiesList(Map<String, String> map) {
        propertiesMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> updatedPropertiesList() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties properties = MailetProperties.getProperties();
        for (String key : properties.stringPropertyNames()) {
            props.put(key, properties.getProperty(key));
        }
        Connection conn = null;
        Statement prepQuery = null;
        ResultSet rs = null;
        try {
            conn = MailetProperties.databaseConnect((String)props.get("mailet.db.hostname"), (String)props.get("mailet.db.port"), (String)props.get("mailet.db.configname"), (String)props.get("mailet.db.instance"), (String)props.get("mailet.db.configusername"), (String)props.get("mailet.db.configprd"));
            String sqlQuery = "select * from mailet_properties";
            try {
                prepQuery = conn.prepareStatement(sqlQuery, 1);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"Failed to execute query");
                Map<String, String> map = null;
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.debug((Object)"Failed to close statement");
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e3) {
                        LOGGER.debug((Object)"Failed to close result set");
                    }
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e4) {
                    LOGGER.debug((Object)"failed to close database connection");
                }
                return map;
            }
            if (prepQuery != null) {
                Object name;
                rs = prepQuery.executeQuery();
                HashMap<Object, String> map = new HashMap<Object, String>();
                while (rs.next()) {
                    name = rs.getString("name");
                    String value = rs.getString("value");
                    map.put(name, value);
                }
                name = map;
                return name;
            }
            Map<String, String> map = null;
            return map;
        }
        catch (SQLException e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (prepQuery != null) {
                try {
                    prepQuery.close();
                }
                catch (SQLException e) {
                    LOGGER.debug((Object)"Failed to close statement");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOGGER.debug((Object)"Failed to close result set");
                }
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.debug((Object)"failed to close database connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        Properties properties = System.getProperties();
        InputStream propertiesFile = null;
        try {
            propertiesFile = NHINDSecurityAndTrustMailet.class.getResourceAsStream("/mailet.properties");
            properties.load(propertiesFile);
        }
        catch (IOException e) {
            LOGGER.trace((Object)"Could not load mailet properties file");
        }
        finally {
            try {
                propertiesFile.close();
            }
            catch (IOException propCloseEx) {
                LOGGER.debug((Object)"Could not close mailet properties file");
            }
        }
        return properties;
    }

    private static Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_prd) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_prd);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            return null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<Integer> usernamesIDs(ArrayList<String> usernames) {
        block26: {
            HashSet<Integer> hs = new HashSet<Integer>();
            Connection conn = null;
            try {
                HashSet<Integer> hashSet;
                block28: {
                    String db_hostname = propertiesMap.get("mailet.db.hostname");
                    String db_port = propertiesMap.get("mailet.db.port");
                    String db_name = propertiesMap.get("mailet.db.mailname");
                    String db_instance = propertiesMap.get("mailet.db.instance");
                    String db_userid = propertiesMap.get("mailet.db.mailusername");
                    String db_password = propertiesMap.get("mailet.db.mailpassword");
                    try {
                        conn = MailetProperties.databaseConnect(db_hostname, db_port, db_name, db_instance, db_userid, db_password);
                    }
                    catch (SQLException e) {
                        LOGGER.trace((Object)"Failed to connect to SQL Server");
                    }
                    Statement prepQuery = null;
                    if (conn == null) break block26;
                    try {
                        String sqlQuery = "SELECT id FROM mailboxes WHERE name in (" + StringUtils.repeat((String)"?,", (int)usernames.size());
                        sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1) + ')';
                        prepQuery = conn.prepareStatement(sqlQuery);
                        for (int c = 0; c < usernames.size(); ++c) {
                            prepQuery.setString(c + 1, usernames.get(c));
                        }
                        ResultSet rs = null;
                        try {
                            rs = prepQuery.executeQuery();
                            while (rs.next()) {
                                hs.add(rs.getInt("id"));
                            }
                            rs.close();
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        hashSet = hs;
                        if (prepQuery == null) break block28;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (prepQuery != null) {
                                prepQuery.close();
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            LOGGER.debug((Object)"SQL Exception for bad query statement in users exists function.");
                            break block26;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    prepQuery.close();
                }
                return hashSet;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        LOGGER.debug((Object)"Failed to close connection");
                    }
                }
            }
        }
        return null;
    }
}

