/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;

public class AntPathMatcherGenericFileFilter<T>
implements GenericFileFilter<T>,
CamelContextAware {
    private static final String ANTPATHMATCHER_CLASSNAME = "org.apache.camel.spring.util.SpringAntPathMatcherFileFilter";
    private CamelContext context;
    private String[] excludes;
    private String[] includes;
    private Object filter;
    private Method includesMethod;
    private Method excludesMethod;
    private Method acceptsMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(GenericFile<T> file) {
        try {
            AntPathMatcherGenericFileFilter antPathMatcherGenericFileFilter = this;
            synchronized (antPathMatcherGenericFileFilter) {
                if (this.filter == null) {
                    this.init();
                }
            }
            ObjectHelper.invokeMethod(this.includesMethod, this.filter, CollectionHelper.collectionAsCommaDelimitedString(this.includes));
            ObjectHelper.invokeMethod(this.excludesMethod, this.filter, CollectionHelper.collectionAsCommaDelimitedString(this.excludes));
            String path = file.getRelativeFilePath();
            return (Boolean)ObjectHelper.invokeMethod(this.acceptsMethod, this.filter, path);
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(ANTPATHMATCHER_CLASSNAME, e);
        }
    }

    private void init() throws NoSuchMethodException {
        Class<?> clazz = this.context.getClassResolver().resolveClass(ANTPATHMATCHER_CLASSNAME);
        ObjectHelper.notNull(clazz, "org.apache.camel.spring.util.SpringAntPathMatcherFileFilter not found in classpath. camel-spring.jar is required in the classpath.");
        this.filter = ObjectHelper.newInstance(clazz);
        this.includesMethod = this.filter.getClass().getMethod("setIncludes", String.class);
        this.excludesMethod = this.filter.getClass().getMethod("setExcludes", String.class);
        this.acceptsMethod = this.filter.getClass().getMethod("acceptPathName", String.class);
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.setExcludes(excludes.split(","));
    }

    public void setIncludes(String includes) {
        this.setIncludes(includes.split(","));
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }
}

