/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.nhindirect.gateway.smtp.GatewayState;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.james.mailet.NHINDSecurityAndTrustMailet;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.NHINDAddress;

public class LocalMailet
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(LocalMailet.class);
    protected SmtpAgent agent;

    public void init() throws MessagingException {
        System.setProperty("enableCBCProtection", "false");
        LOGGER.info((Object)"Initializing IncomingLocalMailet");
        String configURLParam = this.getInitParameter("ConfigURL");
        if (configURLParam == null || configURLParam.isEmpty()) {
            LOGGER.error((Object)"IncomingLocalMailet Configuration URL cannot be empty or null.");
            throw new MessagingException("IncomingLocalMailet Configuration URL cannot be empty or null.");
        }
        URL configURL = null;
        try {
            configURL = new URL(configURLParam);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)("Invalid configuration URL:" + ex.getMessage()), (Throwable)ex);
            throw new MessagingException("Incoming Configuration URL cannot be empty or null.", (Exception)ex);
        }
        LOGGER.info((Object)"IncomingLocalMailet initialization complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        block24: {
            GatewayState.getInstance().lockForProcessing();
            try {
                LOGGER.trace((Object)"Entering service(Mail mail)");
                boolean notificationFlag = false;
                try {
                    if (mail.getSender().toString().equals(this.getMailetContext().getPostmaster().toString())) {
                        notificationFlag = true;
                    }
                    Enumeration headers = mail.getMessage().getAllHeaders();
                    while (headers.hasMoreElements()) {
                        Header h = (Header)headers.nextElement();
                        if (!h.getName().contains("DirectNotification")) continue;
                        notificationFlag = true;
                    }
                }
                catch (MessagingException e) {
                    LOGGER.debug((Object)"Messaging execption while trying to check notification and set flag.");
                }
                if (notificationFlag) break block24;
                InternetAddress senderAddr = NHINDSecurityAndTrustMailet.getSender((Mail)mail);
                if (senderAddr == null) {
                    throw new MessagingException("Failed to process message.  The sender cannot be null or empty.");
                }
                NHINDAddress sender = new NHINDAddress(senderAddr, AddressSource.From);
                Map<String, String> properties = this.getPropertiesList();
                String db_hostname = properties.get("mailet.db.hostname");
                String db_port = properties.get("mailet.db.port");
                String db_apiname = properties.get("mailet.db.apiname");
                String db_webname = properties.get("mailet.db.webname");
                String db_instance = properties.get("mailet.db.instance");
                String db_apiuserid = properties.get("mailet.db.apiusername");
                String db_webuserid = properties.get("mailet.db.webusername");
                String db_apipassword = properties.get("mailet.db.apipassword");
                String db_webpassword = properties.get("mailet.db.webpassword");
                String notificationSender = properties.get("mailet.notification.sender");
                if (sender.toString().toLowerCase(Locale.getDefault()).equals(notificationSender.toLowerCase(Locale.getDefault()))) break block24;
                Connection connapi = null;
                Connection connweb = null;
                LOGGER.info((Object)("Logging local outgoing message from sender " + sender.toString()));
                try {
                    connapi = this.databaseConnect(db_hostname, db_port, db_apiname, db_instance, db_apiuserid, db_apipassword);
                    connweb = this.databaseConnect(db_hostname, db_port, db_webname, db_instance, db_webuserid, db_webpassword);
                    int log_success = 1;
                    this.logMessageToWebmailLog(mail, connweb, 1, 0);
                    this.logMessageToAPILog(mail, connapi, 1, 0, 0);
                    LOGGER.info((Object)"Logged incoming message.");
                    ArrayList<String> badaddress = this.sendExternalNotification(connweb, mail);
                    if (!badaddress.isEmpty()) {
                        log_success = 0;
                    }
                    this.logMessageToWebmailLog(mail, connweb, log_success, 1);
                    this.logMessageToAPILog(mail, connapi, log_success, 1, 0);
                    LOGGER.info((Object)"Logged outgoing message.");
                }
                catch (SQLException sql_ex) {
                    LOGGER.trace((Object)"SQL Exception while sending external notifications and logging messages.");
                }
                finally {
                    try {
                        if (connapi != null) {
                            connapi.close();
                        }
                        if (connweb != null) {
                            connweb.close();
                        }
                    }
                    catch (SQLException closeEx) {
                        LOGGER.debug((Object)"Failed to close SQL Database connection.");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to log message: " + e.getMessage()), (Throwable)e);
            }
            finally {
                GatewayState.getInstance().unlockFromProcessing();
            }
        }
    }

    protected Collection<Module> getInitModules() {
        return null;
    }

    protected Provider<SmtpAgentConfig> getConfigProvider() {
        return null;
    }

    public static InternetAddress getSender(Mail mail) {
        InternetAddress retVal;
        if (mail.getSender() != null) {
            retVal = mail.getSender().toInternetAddress();
        } else {
            Address[] senderAddr;
            try {
                if (mail.getMessage() == null) {
                    return null;
                }
                senderAddr = mail.getMessage().getFrom();
                if (senderAddr == null || senderAddr.length == 0) {
                    return null;
                }
            }
            catch (MessagingException e) {
                return null;
            }
            retVal = (InternetAddress)senderAddr[0];
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        GatewayState.getInstance().lockForUpdating();
        GatewayState.getInstance().unlockFromUpdating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        Properties properties = System.getProperties();
        InputStream propertiesFile = null;
        try {
            propertiesFile = NHINDSecurityAndTrustMailet.class.getResourceAsStream("/mailet.properties");
            properties.load(propertiesFile);
        }
        catch (IOException e) {
            LOGGER.trace((Object)"Could not load mailet properties file");
        }
        finally {
            try {
                if (propertiesFile != null) {
                    propertiesFile.close();
                }
            }
            catch (IOException propCloseEx) {
                LOGGER.debug((Object)"Could not close mailet properties file");
            }
        }
        return properties;
    }

    private Map<String, String> getPropertiesList() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties properties = this.getProperties();
        for (String key : properties.stringPropertyNames()) {
            props.put(key, properties.getProperty(key));
        }
        return props;
    }

    private Connection databaseConnect(String db_hostname, String db_port, String db_name, String db_instance, String db_userid, String db_password) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":" + db_port + ";databaseName=" + db_name + ";ssl=require;hostNameInCertificate=" + db_hostname + ";instanceName=" + db_instance + ";portNumber=" + db_port + ";trustServerCertificate=true";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException f) {
            LOGGER.trace((Object)"Could not load SQL Server DB driver");
        }
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid, db_password);
        }
        catch (SQLException sqlException) {
            LOGGER.trace((Object)"SQL Server database not reachable");
            throw sqlException;
        }
        return conn;
    }

    private boolean usernameExists(Connection conn, String username) {
        try {
            String sqlQuery = "SELECT user_id FROM users WHERE user_deleted_flag <> 1  AND user_name = ?";
            PreparedStatement prepQuery = conn.prepareStatement(sqlQuery);
            prepQuery.setString(1, username);
            String userfound = null;
            try {
                ResultSet rs = prepQuery.executeQuery();
                while (rs.next()) {
                    userfound = rs.getInt("user_id") + "";
                }
                rs.close();
            }
            catch (SQLException f) {
                LOGGER.debug((Object)"SQL query execution for username exists check failed");
            }
            if (userfound != null) {
                return true;
            }
        }
        catch (SQLException e) {
            LOGGER.debug((Object)"SQL Exception for bad query statement in user exists function.");
        }
        return false;
    }

    private void logMessageToWebmailLog(Mail mail, Connection conn, int log_success, int inbound_outbound) {
        block12: {
            String sqlQuery = "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success) VALUES (?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement prepQuery = null;
            try {
                prepQuery = conn.prepareStatement(sqlQuery, 1);
            }
            catch (SQLException se) {
                LOGGER.trace((Object)"Failed to prepare SQL Server statement when logging to webmail.");
            }
            if (prepQuery != null) {
                MimeMessage message = null;
                int log_size = 0;
                String log_inboundOutbound = Integer.toString(inbound_outbound);
                try {
                    message = mail.getMessage();
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message for logging to webmail.");
                }
                try {
                    Long log_time = System.currentTimeMillis() / 1000L;
                    if (message != null) {
                        log_size = message.getSize() / 1024;
                    }
                    String log_sender = this.parseFromAddress(message);
                    String log_recipient = this.parseRecipientsToJSON(message);
                    String log_attachmentTypes = this.parseAttachments(message);
                    try {
                        prepQuery.setString(1, Long.toString(log_time));
                        prepQuery.setString(2, Integer.toString(log_size));
                        prepQuery.setString(3, "" + log_sender);
                        prepQuery.setString(4, log_recipient);
                        prepQuery.setString(5, log_attachmentTypes);
                        prepQuery.setString(6, log_inboundOutbound);
                        prepQuery.setString(7, Integer.toString(log_success));
                        if (!this.hasOnlyLocalRecipients(message)) break block12;
                        try {
                            prepQuery.executeUpdate();
                            LOGGER.info((Object)"Logged message.");
                        }
                        catch (SQLException query_ex) {
                            LOGGER.trace((Object)"Failed to log message.");
                        }
                    }
                    catch (SQLException sql_ex) {
                        LOGGER.debug((Object)"Failed to prepare SQL statement when logging to webmail.");
                    }
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message variables for logging to webmail.");
                }
            }
        }
    }

    private void logMessageToAPILog(Mail mail, Connection conn, int log_success, int inbound_outbound, int mdn) {
        block11: {
            String sqlQuery = "INSERT INTO mail_log (time, size, sender, recipient, attachment_types, inbound_outbound, success, mdn) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement prepQuery = null;
            try {
                prepQuery = conn.prepareStatement(sqlQuery, 1);
            }
            catch (SQLException se) {
                LOGGER.trace((Object)"Failed to prepare SQL Server statement when logging to webmail.");
            }
            if (prepQuery != null) {
                MimeMessage message = null;
                String log_inboundOutbound = Integer.toString(inbound_outbound);
                try {
                    message = mail.getMessage();
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message for logging to webmail.");
                }
                try {
                    Long log_time = System.currentTimeMillis() / 1000L;
                    int log_size = message != null ? message.getSize() / 1024 : 0;
                    String log_sender = this.parseFromAddress(message);
                    String log_recipient = this.parseRecipientsToJSON(message);
                    String log_attachmentTypes = this.parseAttachments(message);
                    try {
                        prepQuery.setString(1, Long.toString(log_time));
                        prepQuery.setString(2, Integer.toString(log_size));
                        prepQuery.setString(3, "" + log_sender);
                        prepQuery.setString(4, log_recipient);
                        prepQuery.setString(5, log_attachmentTypes);
                        prepQuery.setString(6, log_inboundOutbound);
                        prepQuery.setString(7, Integer.toString(log_success));
                        prepQuery.setString(8, Integer.toString(mdn));
                        if (!this.hasOnlyLocalRecipients(message)) break block11;
                        try {
                            prepQuery.executeUpdate();
                            LOGGER.info((Object)"Logged message.");
                        }
                        catch (SQLException query_ex) {
                            LOGGER.trace((Object)"Failed to log message.");
                        }
                    }
                    catch (SQLException sql_ex) {
                        LOGGER.debug((Object)"Failed to prepare SQL statement when logging to webmail.");
                    }
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging execption while retrieving message variables for logging to webmail.");
                }
            }
        }
    }

    private InitialDirContext ldapConnect(String ldap_host, String ldap_port, String ldap_protocol, String ldap_domain, String ldap_user_dn, String ldap_password) {
        InitialDirContext ctx = null;
        String ldapUrl = ldap_protocol + "://" + ldap_host + ":" + ldap_port + "/" + ldap_domain;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ht.put("java.naming.provider.url", ldapUrl);
        ht.put("java.naming.security.authentication", "simple");
        ht.put("java.naming.security.principal", ldap_user_dn);
        ht.put("java.naming.security.credentials", ldap_password);
        try {
            ctx = new InitialDirContext(ht);
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered while sending group external notifications.");
        }
        return ctx;
    }

    private boolean isUserGroup(Connection conn, String username) {
        boolean isGroup = false;
        try {
            String sqlQuery = "SELECT user_is_group FROM users WHERE user_deleted_flag <> 1 AND user_ext_notify_flag = 1 AND user_name = ?";
            PreparedStatement prepQuery = conn.prepareStatement(sqlQuery);
            prepQuery.setString(1, username);
            try {
                ResultSet rs = prepQuery.executeQuery();
                while (rs.next()) {
                    isGroup = rs.getBoolean("user_is_group");
                }
                rs.close();
            }
            catch (SQLException f) {
                LOGGER.debug((Object)"SQL query execution failed");
            }
        }
        catch (SQLException e) {
            LOGGER.debug((Object)"SQL Exception for bad query statement");
        }
        return isGroup;
    }

    private ArrayList<String> getGroupMembership(InitialDirContext ctx, String groupname) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {
                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            }
            catch (NamingException name_ex) {
                LOGGER.debug((Object)"Naming exception encountered while getting group membership.");
            }
            String group_cn = "";
            if (list != null) {
                while (list.hasMore()) {
                    String attr = ((Attribute)list.next()).toString();
                    if (attr.indexOf("member") != 0) continue;
                    String[] members = attr.replace("member: ", "").split(", ");
                    groups = new ArrayList<String>(Arrays.asList(members));
                    for (int j = 0; j < groups.size(); ++j) {
                        if (groups.get(j).toString().indexOf("uid=") == 0) continue;
                        groups.remove(j);
                    }
                }
            }
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered looking up group members.");
        }
        return groups;
    }

    private String getGroupCommonName(InitialDirContext ctx, String groupname) {
        String cn = null;
        try {
            NamingEnumeration<? extends Attribute> list = null;
            try {
                Attributes group_attrs = ctx.getAttributes("ou=" + groupname + ",ou=groups");
                list = group_attrs.getAll();
            }
            catch (NamingException name_ex) {
                LOGGER.debug((Object)"Naming exception encountered while getting group name.");
            }
            if (list != null) {
                while (list.hasMore()) {
                    String attr = ((Attribute)list.next()).toString();
                    if (attr.indexOf("cn") != 0) continue;
                    cn = attr.replace("cn: ", "");
                }
            }
        }
        catch (NamingException name_ex) {
            LOGGER.debug((Object)"Naming exception encountered looking up group name.");
        }
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getGroupExternalAddresses(InitialDirContext ctx, Connection conn, String ldap_domain, ArrayList<String> users) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (int j = 0; j < users.size(); ++j) {
            String membername = users.get(j).toString().replace("uid=", "").replace(",ou=accounts," + ldap_domain, "");
            String sqlQuery = "SELECT user_mail,user_is_group FROM users WHERE user_deleted_flag <> 1 AND user_ext_group_notify_flag = 1 AND user_name = ?";
            PreparedStatement prepQuery = null;
            try {
                prepQuery = conn.prepareStatement(sqlQuery);
                prepQuery.setString(1, membername);
                ResultSet rs = prepQuery.executeQuery();
                while (rs.next()) {
                    String externalMailAddress = rs.getString("user_mail");
                    addresses.add(externalMailAddress);
                }
                rs.close();
                continue;
            }
            catch (SQLException sql_ex) {
                LOGGER.debug((Object)"Query for group member external email address failed.");
                continue;
            }
            finally {
                if (prepQuery != null) {
                    try {
                        prepQuery.close();
                    }
                    catch (SQLException sql_close_ex) {
                        LOGGER.debug((Object)"Failed to close prepared statement for external address lookup query.");
                    }
                }
            }
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExternalAddress(Connection conn, String username) {
        String address = null;
        String sqlQuery = "SELECT user_mail FROM users WHERE user_deleted_flag <> 1 AND user_ext_notify_flag = 1 AND user_name = ?";
        PreparedStatement prepQuery = null;
        try {
            prepQuery = conn.prepareStatement(sqlQuery);
            prepQuery.setString(1, username);
            ResultSet rs = prepQuery.executeQuery();
            while (rs.next()) {
                String externalMailAddress;
                address = externalMailAddress = rs.getString("user_mail");
            }
            rs.close();
        }
        catch (SQLException sql_ex) {
            LOGGER.debug((Object)"Query for group member external email address failed.");
        }
        finally {
            if (prepQuery != null) {
                try {
                    prepQuery.close();
                }
                catch (SQLException sql_close_ex) {
                    LOGGER.debug((Object)"Failed to close prepared statement for external address lookup query.");
                }
            }
        }
        return address;
    }

    public String parseFromAddress(MimeMessage message) {
        String from = null;
        try {
            Address[] froms = message.getFrom();
            if (froms != null) {
                String personal = ((InternetAddress)froms[0]).getPersonal();
                String from_address = ((InternetAddress)froms[0]).getAddress();
                from = personal != null ? "\"" + personal + "\" <" + from_address + ">" : from_address;
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving sender for logging.");
        }
        return from;
    }

    private boolean hasOnlyLocalRecipients(MimeMessage message) {
        Map<String, String> properties = this.getPropertiesList();
        String domainsProperty = properties.get("mailet.domain");
        String[] domainsList = domainsProperty.split(",");
        boolean onlyLocal = true;
        try {
            Address[] recipsAddr = message.getAllRecipients();
            int recipientCount = recipsAddr != null ? recipsAddr.length : 0;
            for (int i = 0; i < recipientCount; ++i) {
                boolean isLocal = false;
                InternetAddress inet_addr_recip = (InternetAddress)recipsAddr[i];
                int atPosition = inet_addr_recip.getAddress().indexOf("@") + 1;
                String currentdomain = inet_addr_recip.getAddress().substring(atPosition);
                for (int c = 0; c < domainsList.length; ++c) {
                    if (!currentdomain.equals(domainsList[c])) continue;
                    isLocal = true;
                }
                if (isLocal) continue;
                onlyLocal = false;
            }
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while checking for external recipients in recipient list.");
        }
        return onlyLocal;
    }

    private String parseRecipientsToJSON(MimeMessage message) {
        String log_recipient = "";
        try {
            Address[] recipsAddr = message.getAllRecipients();
            int recipientCount = recipsAddr != null ? recipsAddr.length : 0;
            log_recipient = "[";
            for (int i = 0; i < recipientCount; ++i) {
                InternetAddress inet_addr_recip = (InternetAddress)recipsAddr[i];
                String cur_recip = "";
                cur_recip = inet_addr_recip.getPersonal() != null ? cur_recip + "\"" + inet_addr_recip.getPersonal() + "\" <" + inet_addr_recip.getAddress() + ">" : cur_recip + inet_addr_recip.getAddress();
                String escaped_recipients = cur_recip.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                log_recipient = log_recipient + "\"" + escaped_recipients + "\",";
            }
            log_recipient = log_recipient.substring(0, log_recipient.length() - 1);
            log_recipient = log_recipient + "]";
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging execption while retrieving recipients for logging.");
        }
        return log_recipient;
    }

    private String parseAttachments(MimeMessage message) {
        String attachmentTypes;
        block8: {
            attachmentTypes = "";
            try {
                if (message.getContentType().equals("text/plain")) break block8;
                MimeMultipart attachments = new MimeMultipart();
                try {
                    attachments = (MimeMultipart)message.getContent();
                }
                catch (ClassCastException ce) {
                    attachments = null;
                }
                catch (IOException ie) {
                    LOGGER.debug((Object)"IO Error while post-processing incoming message.");
                }
                catch (MessagingException me) {
                    LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.getCount(); ++i) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension((String)part.getFileName()) == null) continue;
                        attachmentTypes = attachmentTypes + FilenameUtils.getExtension((String)part.getFileName()) + " ";
                    }
                    attachmentTypes = attachmentTypes.trim();
                }
            }
            catch (MessagingException me) {
                LOGGER.debug((Object)"Messaging Exception while post-processing incoming message.");
            }
        }
        return attachmentTypes;
    }

    private MimeMessage createExternalNotification(InitialDirContext ctx, Mail mail, String username, String address, boolean isGroup) {
        Properties system_properties = this.getProperties();
        Session session = Session.getInstance((Properties)system_properties);
        String notificationSender = system_properties.getProperty("mailet.notification.sender");
        String supportEmail = system_properties.getProperty("mailet.supportEmail");
        String senderEmail = mail.getSender().toString();
        MimeMessage message = null;
        try {
            message = mail.getMessage();
        }
        catch (MessagingException me) {
            LOGGER.debug((Object)"Messaging Exception while creating external notifiction message.");
        }
        try {
            if (address != null && username != null && !address.equals("") && !username.equals("")) {
                String to = address;
                String host = system_properties.getProperty("mail.smtp.host");
                system_properties.setProperty("localhost", host);
                message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(notificationSender));
                message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(to));
                if (isGroup) {
                    String group_cn = this.getGroupCommonName(ctx, username);
                    message.setSubject(group_cn + " has a VLER Direct message from: " + senderEmail);
                } else {
                    message.setSubject("You have a VLER Direct message from: " + senderEmail);
                }
                message.setText("Hello,\r\n\r\nYou have received a new message from ");
                if (isGroup) {
                    message.setContent((Object)("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">VLER Direct</h1><p>Hello,</p><p>Your group has received a <a href=\"https://" + system_properties.get("mailet.domain") + "\">new message from [" + senderEmail + "]</a>.</p><p>Thank you,<br/>VLER Direct Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>"), "text/html");
                } else {
                    message.setContent((Object)("<span style=\"font-family:Verdana\"><h1 style=\"font-size:18px;\">VLER Direct</h1><p>Hello,</p><p>You have received a <a href=\"https://" + system_properties.get("mailet.domain") + "\">new message from [" + senderEmail + "]</a>.</p><p>Thank you,<br/>VLER Direct Team<br/><a href=\"mailto:" + supportEmail + "\">" + supportEmail + "</a></p></span>"), "text/html");
                }
                message.addHeader("DirectNotification", "localhost");
                if (isGroup) {
                    LOGGER.info((Object)("Sent external notifcation to group member: " + username + " at " + address));
                } else {
                    LOGGER.info((Object)("Sent external notifcation to user: " + username + " at " + address));
                }
            }
        }
        catch (MessagingException mex) {
            LOGGER.debug((Object)"Messaging exception encountered while sending group external notifications.");
        }
        return message;
    }

    private ArrayList<String> sendExternalNotification(Connection conn, Mail mail) {
        Transport transport = null;
        Properties system_properties = this.getProperties();
        Map<String, String> properties = this.getPropertiesList();
        Session session = Session.getInstance((Properties)system_properties);
        try {
            transport = session.getTransport();
            transport.connect();
        }
        catch (MessagingException m) {
            LOGGER.trace((Object)"Could not connect to mail server");
        }
        Collection recipientcol = mail.getRecipients();
        Iterator iterator = recipientcol.iterator();
        String ldap_protocol = properties.get("mailet.ldap.protocol");
        String ldap_host = properties.get("mailet.ldap.host");
        String ldap_port = properties.get("mailet.ldap.port");
        String ldap_domain = properties.get("mailet.ldap.domain");
        String ldap_user_dn = properties.get("mailet.ldap.user_dn");
        String ldap_password = properties.get("mailet.ldap.password");
        String domainsProperty = properties.get("mailet.domain");
        String[] domainsList = domainsProperty.split(",");
        ArrayList<String> badaddress = new ArrayList<String>();
        while (iterator.hasNext()) {
            MailAddress recipient = (MailAddress)iterator.next();
            String recipientEmail = recipient.toString();
            int atPosition = recipient.toString().indexOf("@");
            String username = recipientEmail.substring(0, atPosition);
            String currentDomain = recipientEmail.substring(atPosition + 1, recipientEmail.length());
            for (int i = 0; i < domainsList.length; ++i) {
                if (!domainsList[i].equals(currentDomain)) continue;
                if (!this.usernameExists(conn, username)) {
                    badaddress.add(username);
                }
                boolean isGroup = this.isUserGroup(conn, username);
                InitialDirContext ctx = this.ldapConnect(ldap_host, ldap_port, ldap_protocol, ldap_domain, ldap_user_dn, ldap_password);
                if (isGroup) {
                    ArrayList<String> memberList = this.getGroupMembership(ctx, username);
                    ArrayList<String> external_addresses = this.getGroupExternalAddresses(ctx, conn, ldap_domain, memberList);
                    for (int j = 0; j < external_addresses.size(); ++j) {
                        String externalMailAddress = external_addresses.get(j);
                        if (externalMailAddress == null || externalMailAddress.equals("")) continue;
                        MimeMessage message = this.createExternalNotification(ctx, mail, username, externalMailAddress, isGroup);
                        try {
                            if (transport != null) {
                                Transport.send((Message)message);
                                continue;
                            }
                            LOGGER.info((Object)("Failed to send external notification to: " + username));
                            continue;
                        }
                        catch (MessagingException name_ex) {
                            LOGGER.debug((Object)"Exception when sending external notification.");
                        }
                    }
                    continue;
                }
                String external_address = this.getExternalAddress(conn, username);
                if (external_address == null || external_address.equals("")) continue;
                MimeMessage message = this.createExternalNotification(ctx, mail, username, external_address, isGroup);
                try {
                    if (transport != null) {
                        Transport.send((Message)message);
                        continue;
                    }
                    LOGGER.info((Object)("Failed to send external notification to: " + username));
                    continue;
                }
                catch (MessagingException name_ex) {
                    LOGGER.debug((Object)"Exception when sending external notification.");
                }
            }
        }
        return badaddress;
    }
}

