/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.instrument.manager.AbstractValueInstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentProxy;

class MinimumValueInstrumentSample
extends AbstractValueInstrumentSample {
    private int m_lastValue;

    public int getType() {
        return 102;
    }

    protected void advanceToNextSample() {
        this.m_value = this.m_lastValue;
        this.m_valueCount = 0;
    }

    protected void saveState(DefaultConfiguration state) {
        super.saveState(state);
        state.setAttribute("last-value", Integer.toString(this.m_lastValue));
    }

    protected void loadState(int value, Configuration state) throws ConfigurationException {
        super.loadState(value, state);
        this.m_lastValue = state.getAttributeAsInteger("last-value");
    }

    protected void postSaveNeedsReset() {
        super.postSaveNeedsReset();
        this.m_lastValue = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setValueInner(int value, long time) {
        block6: {
            long sampleTime;
            int sampleValue;
            MinimumValueInstrumentSample minimumValueInstrumentSample = this;
            synchronized (minimumValueInstrumentSample) {
                boolean update;
                this.update(time);
                this.m_lastValue = value;
                if (this.m_valueCount > 0) {
                    ++this.m_valueCount;
                    if (value < this.m_value) {
                        this.m_value = value;
                        update = true;
                    }
                } else {
                    this.m_valueCount = 1;
                    this.m_value = value;
                }
                sampleValue = this.m_value;
                sampleTime = this.m_time;
                update = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl19 : MonitorExitStatement: MONITOREXIT : var8_3
                if (!update) break block6;
            }
            this.updateListeners(sampleValue, sampleTime);
        }
    }

    MinimumValueInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        super(instrumentProxy, name, interval, size, description, lease);
    }
}

