/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.configuration.merger;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class ConfigurationMerger {
    public static Configuration merge(Configuration layer, Configuration base) throws ConfigurationException {
        DefaultConfiguration merged = new DefaultConfiguration(base.getName(), "Merged [layer: " + layer.getLocation() + ", base: " + base.getLocation() + "]");
        ConfigurationMerger.copyAttributes(base, merged);
        ConfigurationMerger.copyAttributes(layer, merged);
        ConfigurationMerger.mergeChildren(layer, base, merged);
        merged.setValue(ConfigurationMerger.getValue(layer, base));
        merged.makeReadOnly();
        return merged;
    }

    private static void mergeChildren(Configuration layer, Configuration base, DefaultConfiguration merged) throws ConfigurationException {
        int i;
        Configuration[] lc = layer.getChildren();
        Configuration[] bc = base.getChildren();
        HashSet<Configuration> baseUsed = new HashSet<Configuration>();
        for (i = 0; i < lc.length; ++i) {
            Configuration mergeWith = ConfigurationMerger.getMergePartner(lc[i], layer, base);
            if (null == mergeWith) {
                merged.addChild(lc[i]);
                continue;
            }
            merged.addChild(ConfigurationMerger.merge(lc[i], mergeWith));
            baseUsed.add(mergeWith);
        }
        for (i = 0; i < bc.length; ++i) {
            if (baseUsed.contains(bc[i])) continue;
            merged.addChild(bc[i]);
        }
    }

    private static Configuration getMergePartner(Configuration toMerge, Configuration layer, Configuration base) throws ConfigurationException {
        if (toMerge.getAttributeAsBoolean("excalibur-configuration:merge", false)) {
            String keyAttribute = toMerge.getAttribute("excalibur-configuration:key-attribute", null);
            String keyvalue = keyAttribute == null ? null : toMerge.getAttribute(keyAttribute);
            Configuration[] layerKids = ConfigurationMerger.match(layer, toMerge.getName(), keyAttribute, keyvalue);
            Configuration[] baseKids = ConfigurationMerger.match(base, toMerge.getName(), keyAttribute, keyvalue);
            if (layerKids.length == 1 && baseKids.length == 1) {
                return baseKids[0];
            }
            throw new ConfigurationException("Unable to merge configuration item, multiple matches on child or base [name: " + toMerge.getName() + "]");
        }
        return null;
    }

    private static String getValue(Configuration layer, Configuration base) {
        try {
            return layer.getValue();
        }
        catch (ConfigurationException e) {
            return base.getValue(null);
        }
    }

    private static void copyAttributes(Configuration source, DefaultConfiguration dest) throws ConfigurationException {
        String[] names = source.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].startsWith("excalibur-configuration:")) continue;
            dest.setAttribute(names[i], source.getAttribute(names[i]));
        }
    }

    public static Configuration[] match(Configuration config, String element, String attribute) {
        return ConfigurationMerger.match(config, element, attribute, null);
    }

    public static Configuration[] match(Configuration config, String element, String attribute, String value) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        Configuration[] children = config.getChildren(element);
        for (int i = 0; i < children.length; ++i) {
            if (null == attribute) {
                list.add(children[i]);
                continue;
            }
            String v = children[i].getAttribute(attribute, null);
            if (v == null || value != null && !v.equals(value)) continue;
            list.add(children[i]);
        }
        return list.toArray(new Configuration[list.size()]);
    }
}

