/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.emf.runtime.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Initializer<T extends EObject> {
    public T initialize(T var1);

    public Class<? extends T> getTargetType();

    public boolean equals(Object var1);

    public int hashCode();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public Iterable<? extends Initializer<? extends EObject>> createInitializers(EClass var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public static final Registry INSTANCE = new Impl();

        public <T extends EObject> Iterable<? extends Initializer<? super T>> getInitializers(EClass var1);

        public <T extends EObject> Iterable<? extends Initializer<? super T>> getInitializers(EClass var1, boolean var2);

        public Registry addInitializer(EClass var1, Initializer<? extends EObject> var2);

        public Registry addAllInitializers(EClass var1, Iterable<? extends Initializer<? extends EObject>> var2);

        public Registry initializeEPackage(EPackage var1);

        public Registry initializeEPackage(EPackage var1, Factory var2);

        public Factory getFactory(String var1);

        public Registry registerFactory(String var1, Factory var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Impl
        implements Registry {
            private final Impl delegate;
            private final Set<String> initializedPackages = new HashSet<String>();
            private final Map<EClass, List<Initializer<? extends EObject>>> initializers = new HashMap<EClass, List<Initializer<? extends EObject>>>();
            private final Map<String, Factory> factories = new HashMap<String, Factory>();

            Impl() {
                this(null);
            }

            Impl(Impl delegate) {
                this.delegate = delegate;
            }

            @Override
            public <T extends EObject> Iterable<? extends Initializer<? super T>> getInitializers(EClass eclass) {
                return this.getInitializers(eclass, true);
            }

            @Override
            public <T extends EObject> Iterable<? extends Initializer<? super T>> getInitializers(EClass eclass, boolean inherit) {
                Iterable<Initializer<T>> result = this.initializersFor(eclass);
                if (inherit) {
                    ArrayList<Initializer<T>> listResult = new ArrayList<Initializer<T>>();
                    for (Initializer<T> next : result) {
                        listResult.add(next);
                    }
                    for (EClass super_ : eclass.getEAllSuperTypes()) {
                        for (Initializer<T> next : this.initializersFor(super_)) {
                            listResult.add(next);
                        }
                    }
                    result = listResult;
                }
                return result;
            }

            private <T extends EObject> Iterable<? extends Initializer<? super T>> initializersFor(EClass eclass) {
                List listResult;
                Iterable unfiltered = this.initializers.get(eclass);
                if (unfiltered == null) {
                    listResult = Collections.emptyList();
                } else {
                    listResult = new ArrayList();
                    for (Initializer next : unfiltered) {
                        if (!Impl.initializes(next, eclass.getInstanceClass())) continue;
                        Initializer asSuperT = next;
                        listResult.add(asSuperT);
                    }
                }
                Iterable<Object> result = listResult;
                if (this.delegate != null) {
                    if (listResult.isEmpty()) {
                        result = this.delegate.getInitializers(eclass);
                    } else {
                        for (Initializer<T> next : this.delegate.getInitializers(eclass)) {
                            listResult.add(next);
                        }
                    }
                }
                return result;
            }

            @Override
            public Registry addInitializer(EClass eclass, Initializer<? extends EObject> initializer) {
                if (!initializer.getTargetType().isAssignableFrom(eclass.getInstanceClass())) {
                    throw new IllegalArgumentException(String.format("Cannot initialize EClass %s with %s.", eclass.getName(), initializer));
                }
                List<Initializer<? extends EObject>> list = this.initializers.get(eclass);
                if (list == null) {
                    list = new ArrayList<Initializer<? extends EObject>>();
                    this.initializers.put(eclass, list);
                }
                boolean alreadyHaveIt = false;
                for (Initializer next : this.getInitializers(eclass)) {
                    if (next != initializer) continue;
                    alreadyHaveIt = true;
                    break;
                }
                if (!alreadyHaveIt) {
                    list.add(initializer);
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Registry addAllInitializers(EClass eclass, Iterable<? extends Initializer<? extends EObject>> initializers) {
                for (Initializer<? extends EObject> initializer : initializers) {
                    if (initializer.getTargetType().isAssignableFrom(eclass.getInstanceClass())) continue;
                    throw new IllegalArgumentException(String.format("Cannot initialize EClass %s with %s.", eclass.getName(), initializer));
                }
                List<Initializer<? extends EObject>> list = this.initializers.get(eclass);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    this.initializers.put(eclass, arrayList);
                }
                HashSet existing = new HashSet();
                for (Initializer initializer : this.getInitializers(eclass)) {
                    existing.add(initializer);
                }
                for (Initializer initializer : initializers) {
                    void var3_7;
                    if (existing.contains(initializer)) continue;
                    var3_7.add(initializer);
                }
                return this;
            }

            private static boolean initializes(Initializer<?> initializer, Class<?> type) {
                return initializer.getTargetType().isAssignableFrom(type);
            }

            @Override
            public Registry initializeEPackage(EPackage epackage) {
                Factory factory = Util.getInitializerFactory(this, epackage);
                if (factory != null) {
                    this.initializeEPackage(epackage, factory);
                }
                return this;
            }

            @Override
            public Registry initializeEPackage(EPackage epackage, Factory factory) {
                String nsURI = epackage.getNsURI();
                if (this.initializedPackages.add(nsURI) && (this.delegate == null || !this.delegate.initializedPackages.contains(nsURI))) {
                    for (EClassifier next : epackage.getEClassifiers()) {
                        if (!(next instanceof EClass)) continue;
                        EClass eclass = (EClass)next;
                        this.addAllInitializers(eclass, factory.createInitializers(eclass));
                    }
                }
                return this;
            }

            @Override
            public Factory getFactory(String initializersURI) {
                Factory result = this.factories.get(initializersURI);
                if (result == null && this.delegate != null) {
                    result = this.delegate.getFactory(initializersURI);
                }
                return result;
            }

            @Override
            public Registry registerFactory(String initializersURI, Factory factory) {
                this.factories.put(initializersURI, factory);
                return this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Util {
        public static final String INITIALIZERS_ANNOTATION_SOURCE = "http://www.openhealthtools.org/mdht/uml";
        public static final String INITIALIZERS_ANNOTATION_DETAIL = "initializers";

        private Util() {
        }

        public static Registry getRegistry(ResourceSet resourceSet) {
            RegistryAdapter adapter = (RegistryAdapter)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), Registry.class);
            if (adapter == null) {
                adapter = new RegistryAdapter(new Registry.Impl((Registry.Impl)Registry.INSTANCE));
                resourceSet.eAdapters().add((Object)adapter);
            }
            return adapter.get();
        }

        public static Registry getRegistry(EObject object) {
            ResourceSet rset = null;
            Resource res = object.eResource();
            if (res != null) {
                rset = res.getResourceSet();
            }
            return rset != null ? Util.getRegistry(rset) : Registry.INSTANCE;
        }

        public static <T extends EObject> T init(T object) {
            Util.init(object, Util.getRegistry(object).getInitializers(object.eClass()));
            return object;
        }

        public static <T extends EObject, I extends Initializer<? extends T>> void init(EObject object, Iterable<? extends I> initializers) {
            for (Initializer next : initializers) {
                Util.init(object, next);
            }
        }

        private static <T extends EObject> void init(EObject object, Initializer<T> initializer) {
            initializer.initialize((EObject)initializer.getTargetType().cast(object));
        }

        public static boolean hasInitializers(EPackage epackage) {
            return EcoreUtil.getAnnotation((EModelElement)epackage, (String)INITIALIZERS_ANNOTATION_SOURCE, (String)INITIALIZERS_ANNOTATION_DETAIL) != null;
        }

        public static Iterable<Factory> getInitializerFactories(Registry registry, EPackage epackage) {
            List<Factory> result = Collections.emptyList();
            String uris = EcoreUtil.getAnnotation((EModelElement)epackage, (String)INITIALIZERS_ANNOTATION_SOURCE, (String)INITIALIZERS_ANNOTATION_DETAIL);
            if (uris != null) {
                ArrayList<Factory> listResult = new ArrayList<Factory>();
                String[] stringArray = uris.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    Factory factory = registry.getFactory(next);
                    if (factory != null) {
                        listResult.add(factory);
                    }
                    ++n2;
                }
                result = Collections.unmodifiableList(listResult);
            }
            return result;
        }

        static Factory getInitializerFactory(Registry registry, EPackage epackage) {
            Factory result;
            Iterable<Factory> factories = Util.getInitializerFactories(registry, epackage);
            Iterator<Factory> iter = factories.iterator();
            if (!iter.hasNext()) {
                result = NullFactory.INSTANCE;
            } else {
                result = iter.next();
                if (iter.hasNext()) {
                    result = new ChainedFactory(factories);
                }
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ChainedFactory
        implements Factory {
            private final Iterable<? extends Factory> factories;

            ChainedFactory(Iterable<? extends Factory> factories) {
                this.factories = factories;
            }

            @Override
            public Iterable<? extends Initializer<? extends EObject>> createInitializers(EClass eclass) {
                ArrayList<Initializer<? extends EObject>> result = new ArrayList<Initializer<? extends EObject>>();
                for (Factory factory : this.factories) {
                    for (Initializer<? extends EObject> initializer : factory.createInitializers(eclass)) {
                        result.add(initializer);
                    }
                }
                return Collections.unmodifiableList(result);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class NullFactory
        implements Factory {
            static final Factory INSTANCE = new NullFactory();

            private NullFactory() {
            }

            @Override
            public Iterable<? extends Initializer<? extends EObject>> createInitializers(EClass eclass) {
                return Collections.emptyList();
            }
        }

        private static class RegistryAdapter
        extends AdapterImpl {
            private final Registry registry;

            RegistryAdapter(Registry registry) {
                this.registry = registry;
            }

            Registry get() {
                return this.registry;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return type == Registry.class;
            }
        }
    }
}

