/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.emf.runtime.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.openhealthtools.mdht.emf.runtime.internal.Logger;
import org.openhealthtools.mdht.emf.runtime.resource.DOMDocumentHandler;
import org.openhealthtools.mdht.emf.runtime.resource.DOMElementHandler;
import org.openhealthtools.mdht.emf.runtime.resource.FleXMLResource;
import org.openhealthtools.mdht.emf.runtime.resource.FleXMLResourceSet;
import org.openhealthtools.mdht.emf.runtime.resource.impl.FleXMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleXMLLoadImpl
extends XMLLoadImpl {
    private DOMElementHandler.Registry elementHandlerRegistry;

    public FleXMLLoadImpl(XMLHelper helper) {
        super(helper);
    }

    protected DefaultHandler makeDefaultHandler() {
        return new FleXMLHandler(this.resource, this.helper, this.options);
    }

    public void load(XMLResource resource, InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            this.load(resource, FleXMLLoadImpl.newDocumentBuilder().parse(inputStream), options);
        }
        catch (SAXException e) {
            throw new Resource.IOWrappedException((Exception)e);
        }
    }

    public void load(XMLResource resource, InputSource inputSource, Map<?, ?> options) throws IOException {
        try {
            this.load(resource, FleXMLLoadImpl.newDocumentBuilder().parse(inputSource), options);
        }
        catch (SAXException e) {
            throw new Resource.IOWrappedException((Exception)e);
        }
    }

    public void load(XMLResource resource, Node node, Map<?, ?> options) throws IOException {
        Document doc = null;
        DOMDocumentHandler docHandler = (DOMDocumentHandler)options.get(FleXMLResource.OPTION_DOM_DOCUMENT_HANDLER);
        if (docHandler != null) {
            Document document = doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
            if (doc != null) {
                try {
                    docHandler.aboutToLoadDOM(doc);
                }
                catch (Exception e) {
                    Logger.logException("Uncaught exception in pre-load DOM document handler.", e);
                }
            }
        }
        super.load(resource, node, options);
        if (doc != null && docHandler != null) {
            try {
                docHandler.afterDOMLoaded(doc);
            }
            catch (Exception e) {
                Logger.logException("Uncaught exception in post-load DOM document handler.", e);
            }
        }
    }

    private static DocumentBuilder newDocumentBuilder() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new Resource.IOWrappedException(e);
        }
    }

    protected void traverse(Node node, XMLLoadImpl.AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
        this.processNode(node, handler);
        super.traverse(node, attributesProxy, handler, lexicalHandler);
    }

    protected void traverseElement(Element element, XMLLoadImpl.AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
        this.processNode(element, handler);
        super.traverseElement(element, attributesProxy, handler, lexicalHandler);
    }

    private void processNode(Node node, DefaultHandler handler) {
        if (node instanceof Element) {
            EPackage epackage;
            FleXMLHandler flexHandler = (FleXMLHandler)((Object)handler);
            Element element = (Element)node;
            Element root = element.getOwnerDocument().getDocumentElement();
            String namespaceURI = element.getNamespaceURI();
            EPackage ePackage = epackage = namespaceURI == null ? this.helper.getNoNamespacePackage() : flexHandler.getPackageForURI(namespaceURI);
            if (epackage != null) {
                for (DOMElementHandler next : this.getElementHandlers(epackage)) {
                    if (next.handleElement(element, root, this.helper)) break;
                }
            }
        }
    }

    private Iterable<DOMElementHandler> getElementHandlers(EPackage epackage) {
        if (this.elementHandlerRegistry == null) {
            if (this.resource.getResourceSet() instanceof FleXMLResourceSet) {
                this.elementHandlerRegistry = ((FleXMLResourceSet)this.resource.getResourceSet()).getDOMElementHandlerRegistry();
            }
            if (this.elementHandlerRegistry == null) {
                this.elementHandlerRegistry = DOMElementHandler.Registry.INSTANCE;
            }
        }
        return this.elementHandlerRegistry.getHandlers(epackage);
    }

    protected void handleErrors() throws IOException {
        if (!this.resource.getErrors().isEmpty()) {
            Resource.Diagnostic error = (Resource.Diagnostic)this.resource.getErrors().get(0);
            if (error instanceof Exception) {
                if (this.shouldThrow((Exception)error)) {
                    throw new Resource.IOWrappedException((Exception)error);
                }
            } else {
                throw new IOException(error.getMessage());
            }
        }
    }

    protected boolean shouldThrow(Exception exception) {
        return true;
    }
}

