/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.salt.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EnumSet {
    private final Map _nameMap = new HashMap();
    private final Map _codeMap = new HashMap();

    public final Set getNames() {
        return Collections.unmodifiableSet(this._nameMap.keySet());
    }

    public final Set getCodes() {
        return Collections.unmodifiableSet(this._codeMap.keySet());
    }

    public final String getNameFor(int code) {
        String name = (String)this._codeMap.get(new Integer(code));
        if (null == name) {
            String message = "Unknown code " + code;
            throw new IllegalArgumentException(message);
        }
        return name;
    }

    public final int getCodeFor(String name) {
        Integer code = (Integer)this._nameMap.get(name);
        if (null == code) {
            String message = "Unknown name " + name;
            throw new IllegalArgumentException(message);
        }
        return code;
    }

    public static EnumSet createFrom(Class clazz) {
        return EnumSet.createFrom(clazz, "(.*)");
    }

    public static EnumSet createFrom(Class clazz, String match) {
        return EnumSet.createFrom(clazz, match, true);
    }

    public static EnumSet createFrom(Class clazz, String match, boolean deep) {
        Pattern pattern = Pattern.compile(match);
        EnumSet set = new EnumSet();
        Field[] fields = EnumSet.getFields(clazz, deep);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && field.getType() == Integer.TYPE) {
                int value;
                String name = field.getName();
                try {
                    value = field.getInt(null);
                }
                catch (Exception e) {
                    String message = "Unable to get value from field";
                    throw new IllegalStateException("Unable to get value from field");
                }
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    int count = matcher.groupCount();
                    String key = name;
                    if (0 != count) {
                        key = matcher.group(1);
                    }
                    set.add(key, value);
                }
            }
            ++i;
        }
        return set;
    }

    private static Field[] getFields(Class clazz, boolean deep) {
        Field[] fields = deep ? clazz.getFields() : clazz.getDeclaredFields();
        return fields;
    }

    private void add(String name, int code) {
        this._nameMap.put(name, new Integer(code));
        this._codeMap.put(new Integer(code), name);
    }
}

