/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.salt.io;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class PathMatcher {
    private final Pattern[] m_includes;
    private final Pattern[] m_excludes;
    private final Perl5Matcher m_matcher = new Perl5Matcher();
    private final char m_separator;

    public PathMatcher(String[] includes, String[] excludes) {
        this(includes, excludes, '/');
    }

    public PathMatcher(String[] includes, String[] excludes, char separator) {
        if (null == includes) {
            throw new NullPointerException("includes");
        }
        if (null == excludes) {
            throw new NullPointerException("excludes");
        }
        this.m_separator = separator;
        this.m_includes = this.toPatterns(includes);
        this.m_excludes = this.toPatterns(excludes);
    }

    public boolean match(String vPath) {
        if (this.isExcluded(vPath)) {
            return false;
        }
        return this.isIncluded(vPath);
    }

    private boolean isExcluded(String vPath) {
        return this.testMatch(this.m_excludes, vPath);
    }

    private boolean isIncluded(String vPath) {
        return this.testMatch(this.m_includes, vPath);
    }

    private boolean testMatch(Pattern[] patterns, String vPath) {
        int i = 0;
        while (i < patterns.length) {
            if (this.m_matcher.matches(vPath, patterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Pattern[] toPatterns(String[] strs) {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern[] patterns = new Pattern[strs.length];
        int i = 0;
        while (i < patterns.length) {
            String perlPatternStr = this.toPerlPatternStr(strs[i]);
            try {
                patterns[i] = compiler.compile(perlPatternStr);
            }
            catch (MalformedPatternException mpe) {
                throw new IllegalArgumentException(mpe.toString());
            }
            ++i;
        }
        return patterns;
    }

    private String toPerlPatternStr(String str) {
        StringBuffer sb = new StringBuffer();
        int size = str.length();
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if ('.' == ch || this.m_separator == ch || '\\' == ch) {
                sb.append('\\');
                sb.append(ch);
            } else if ('*' == ch) {
                if (i + 2 < size && '*' == str.charAt(i + 1) && this.m_separator == str.charAt(i + 2)) {
                    sb.append("([^\\");
                    sb.append(this.m_separator);
                    sb.append("]*\\");
                    sb.append(this.m_separator);
                    sb.append(")*");
                    i += 2;
                } else if (i + 2 == size && '*' == str.charAt(i + 1)) {
                    sb.append("([^\\");
                    sb.append(this.m_separator);
                    sb.append("]*\\");
                    sb.append(this.m_separator);
                    sb.append(")*");
                    ++i;
                } else {
                    sb.append("[^\\");
                    sb.append(this.m_separator);
                    sb.append("]+");
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

