/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.phoenix.launcher.FreeNEasyPolicy;
import org.apache.avalon.phoenix.launcher.JMXLauncherMBean;
import org.apache.avalon.phoenix.launcher.LauncherUtils;

public class JMXLauncher
implements JMXLauncherMBean {
    private static final String MAIN_CLASS = "org.apache.avalon.phoenix.frontends.CLIMain";
    private int m_state;
    private String m_phoenixHome = "../../phoenix/";
    private String m_phoenixConfigFile = "../../phoenix/conf/kernel.xml";
    private String m_appsPath = "../../phoenix/apps/";
    private String m_logFilename = "../../phoenix/logs/phoenix.log";
    private boolean m_debugPhoenix = false;
    private Object m_frontend;
    private Method m_shutdownMethod;
    static /* synthetic */ Class class$java$util$Map;

    public int getState() {
        return this.m_state;
    }

    public String getStateString() {
        return JMXLauncherMBean.states[this.m_state];
    }

    public void setPhoenixHome(String value) {
        this.m_phoenixHome = value;
    }

    public String getPhoenixHome() {
        return this.m_phoenixHome;
    }

    public void setPhoenixConfigFile(String value) {
        this.m_phoenixConfigFile = value;
    }

    public String getPhoenixConfigFile() {
        return this.m_phoenixConfigFile;
    }

    public void setAppsPath(String value) {
        this.m_appsPath = value;
    }

    public String getAppsPath() {
        return this.m_appsPath;
    }

    public void setLogFilename(String value) {
        this.m_logFilename = value;
    }

    public String getLogFilename() {
        return this.m_logFilename;
    }

    public void setPhoenixDebug(String value) {
        this.m_debugPhoenix = new Boolean(value);
    }

    public String getPhoenixDebug() {
        return new Boolean(this.m_debugPhoenix).toString();
    }

    public void create() throws Exception {
        this.m_state = 0;
    }

    public void start() throws Exception {
        this.m_state = 2;
        HashMap data = new HashMap();
        if (this.m_debugPhoenix) {
            System.out.println("JMXLauncher: Starting up Phoenix");
            File f = new File(this.m_phoenixHome);
            System.out.println("JMXLauncher setting phoenix home to " + f.getCanonicalPath());
            f = new File(this.m_phoenixConfigFile);
            System.out.println("JMXLauncher setting phoenix config file to " + f.getCanonicalPath());
            f = new File(this.m_appsPath);
            System.out.println("JMXLauncher setting phoenix apps path to " + f.getCanonicalPath());
            f = new File(this.m_logFilename);
            System.out.println("JMXLauncher setting phoenix log file to " + f.getCanonicalPath());
        }
        try {
            String[] args = this.m_debugPhoenix ? new String[8] : new String[7];
            int idx = 0;
            args[idx++] = "-f";
            args[idx++] = this.m_phoenixConfigFile;
            args[idx++] = "-a";
            args[idx++] = this.m_appsPath;
            args[idx++] = "-l";
            args[idx++] = this.m_logFilename;
            args[idx++] = "--disable-hook";
            if (this.m_debugPhoenix) {
                args[idx] = "-d";
            }
            System.setProperty("phoenix.home", this.m_phoenixHome);
            this.startPhoenix(args, data);
            this.m_state = 3;
            if (this.m_debugPhoenix) {
                System.out.println("JMXLauncher: Phoenix startup completed");
            }
        }
        catch (Exception e) {
            this.m_state = 4;
            System.out.println("JMXLauncher: Failed to start Phoenix launcher thread");
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.m_state != 0 && this.m_state != 1) {
            this.m_state = 1;
            if (this.m_debugPhoenix) {
                System.out.println("JMXLauncher: Stopping Phoenix");
            }
            try {
                this.shutdownPhoenix();
            }
            catch (Exception e) {
                System.out.println("JMXLauncher: Failed to stop Phoenix");
                e.printStackTrace();
            }
            this.m_state = 0;
        }
    }

    public void destroy() {
    }

    private void startPhoenix(String[] args, Map data) {
        try {
            Policy.setPolicy(new FreeNEasyPolicy());
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URL[] libUrls = JMXLauncher.getLibClassPath();
            URLClassLoader libClassLoader = new URLClassLoader(libUrls, contextClassLoader);
            URL[] engineUrls = LauncherUtils.getEngineClassPath();
            URLClassLoader engineClassLoader = new URLClassLoader(engineUrls, (ClassLoader)libClassLoader);
            data.put("common.classloader", libClassLoader);
            data.put("container.classloader", engineClassLoader);
            data.put("phoenix.home", new File(LauncherUtils.findPhoenixHome()));
            Thread.currentThread().setContextClassLoader(libClassLoader);
            Class<?> clazz = engineClassLoader.loadClass(MAIN_CLASS);
            Class[] paramTypes = new Class[]{args.getClass(), class$java$util$Map == null ? (class$java$util$Map = JMXLauncher.class$("java.util.Map")) : class$java$util$Map, Boolean.TYPE};
            Method startupMethod = clazz.getMethod("main", paramTypes);
            this.m_shutdownMethod = clazz.getMethod("shutdown", new Class[0]);
            this.m_frontend = clazz.newInstance();
            Integer integer = (Integer)startupMethod.invoke(this.m_frontend, args, data, new Boolean(false));
            int exitCode = integer;
            if (exitCode != 0) {
                throw new Exception("Result " + exitCode + " from main()");
            }
        }
        catch (Exception e) {
            System.out.println("JMXLauncher: Failed to start Phoenix");
            e.printStackTrace();
        }
    }

    private void shutdownPhoenix() throws Exception {
        if (this.m_frontend != null && this.m_shutdownMethod != null) {
            this.m_shutdownMethod.invoke(this.m_frontend, new Object[0]);
        }
        this.m_shutdownMethod = null;
        this.m_frontend = null;
    }

    private static URL[] getLibClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        File dir = JMXLauncher.findLibDir();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".jar")) continue;
            urls.add(file.toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static File findLibDir() throws Exception {
        String phoenixHome = LauncherUtils.findPhoenixHome();
        String libDir = phoenixHome + File.separator + "lib";
        File dir = new File(libDir).getCanonicalFile();
        if (!dir.exists()) {
            throw new Exception("Unable to locate engine lib directory at " + dir.getCanonicalPath());
        }
        return dir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

