/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.common;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.ObjectFactory;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AssociationType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.IdentifiableType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryPackageType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocumentUtils;
import org.nhindirect.xd.common.XdmPackage;
import org.nhindirect.xd.common.exception.MetadataException;
import org.nhindirect.xd.common.type.AssociationType1Enum;
import org.nhindirect.xd.common.type.ClassificationTypeEnum;
import org.nhindirect.xd.common.type.ExternalIdentifierTypeEnum;
import org.nhindirect.xd.common.type.SlotType1Enum;
import org.nhindirect.xd.common.type.SubmitObjectsRequestEnum;
import org.nhindirect.xd.transform.util.XmlUtils;

public class DirectDocuments {
    private List<DirectDocument2> documents = new ArrayList<DirectDocument2>();
    private SubmissionSet submissionSet = new SubmissionSet();
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DirectDocuments.class);

    public SubmissionSet getSubmissionSet() {
        return this.submissionSet;
    }

    public void setSubmissionSet(SubmissionSet submissionSet) {
        if (this.submissionSet != null && !this.submissionSet.equals(submissionSet)) {
            LOGGER.warn((Object)"Overwriting existing SubmissionSet values");
        }
        this.submissionSet = submissionSet;
    }

    public List<DirectDocument2> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<DirectDocument2> documents) {
        this.documents = documents;
    }

    public SubmitObjectsRequest getSubmitObjectsRequest() {
        RegistryPackageType registryPackageType = this.submissionSet.generateRegistryPackageType();
        ClassificationType classificationType = this.submissionSet.generateClassificationType();
        QName qname = null;
        qname = new QName(SubmitObjectsRequestEnum.EXTRINSIC_OBJECT.getNamespaceUri(), SubmitObjectsRequestEnum.EXTRINSIC_OBJECT.getName());
        ArrayList<JAXBElement> jaxb_extrinsicObjectTypes = new ArrayList<JAXBElement>();
        for (DirectDocument2 document : this.documents) {
            ExtrinsicObjectType extrinsicObjectType = document.getMetadata().generateExtrinsicObjectType();
            JAXBElement jaxb_extrinsicObjectType = new JAXBElement(qname, ExtrinsicObjectType.class, (Object)extrinsicObjectType);
            jaxb_extrinsicObjectTypes.add(jaxb_extrinsicObjectType);
        }
        qname = new QName(SubmitObjectsRequestEnum.REGISTRY_PACKAGE.getNamespaceUri(), SubmitObjectsRequestEnum.REGISTRY_PACKAGE.getName());
        JAXBElement jaxb_registryPackageType = new JAXBElement(qname, RegistryPackageType.class, (Object)registryPackageType);
        qname = new QName(SubmitObjectsRequestEnum.CLASSIFICATION.getNamespaceUri(), SubmitObjectsRequestEnum.CLASSIFICATION.getName());
        JAXBElement jaxb_classificationType = new JAXBElement(qname, ClassificationType.class, (Object)classificationType);
        qname = new QName(SubmitObjectsRequestEnum.ASSOCIATION.getNamespaceUri(), SubmitObjectsRequestEnum.ASSOCIATION.getName());
        ArrayList<JAXBElement> jaxb_associationType1s = new ArrayList<JAXBElement>();
        for (DirectDocument2 document : this.documents) {
            AssociationType1 associationType = this.submissionSet.generateAssociationType(document.getMetadata().getId(), document.getMetadata().getSubmissionSetStatus());
            JAXBElement jaxb_AssociationType1 = new JAXBElement(qname, AssociationType1.class, (Object)associationType);
            jaxb_associationType1s.add(jaxb_AssociationType1);
        }
        SubmitObjectsRequest submitObjectsRequest = new SubmitObjectsRequest();
        RegistryObjectListType registryObjectListType = new RegistryObjectListType();
        List<JAXBElement<? extends IdentifiableType>> elements = registryObjectListType.getIdentifiable();
        elements.addAll(jaxb_extrinsicObjectTypes);
        elements.add((JAXBElement<? extends IdentifiableType>)jaxb_registryPackageType);
        elements.add((JAXBElement<? extends IdentifiableType>)jaxb_classificationType);
        elements.addAll(jaxb_associationType1s);
        submitObjectsRequest.setRegistryObjectList(registryObjectListType);
        return submitObjectsRequest;
    }

    public void setValues(String submitObjectsRequestXml) throws Exception {
        SubmitObjectsRequest sor = (SubmitObjectsRequest)XmlUtils.unmarshal(new String(submitObjectsRequestXml), ObjectFactory.class);
        this.setValues(sor);
    }

    public void setValues(SubmitObjectsRequest submitObjectsRequest) throws MetadataException {
        RegistryObjectListType rol = submitObjectsRequest.getRegistryObjectList();
        List<JAXBElement<? extends IdentifiableType>> elements = rol.getIdentifiable();
        for (JAXBElement<? extends IdentifiableType> element : elements) {
            if (element.getValue() instanceof ExtrinsicObjectType) {
                ExtrinsicObjectType eot = (ExtrinsicObjectType)element.getValue();
                DirectDocument2 document = new DirectDocument2();
                DirectDocument2.Metadata metadata = document.getMetadata();
                metadata.setValues(eot);
                this.documents.add(document);
                continue;
            }
            if (element.getValue() instanceof RegistryPackageType) {
                RegistryPackageType rpt = (RegistryPackageType)element.getValue();
                SubmissionSet submissionSet = new SubmissionSet();
                submissionSet.setValues(rpt);
                this.submissionSet = submissionSet;
                continue;
            }
            if (!(element.getValue() instanceof ClassificationType)) continue;
        }
        for (JAXBElement<? extends IdentifiableType> element : elements) {
            if (!(element.getValue() instanceof AssociationType1)) continue;
            AssociationType1 at = (AssociationType1)element.getValue();
            for (SlotType1 slot : at.getSlot()) {
                if (!SlotType1Enum.SUBMISSION_SET_STATUS.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                this.getDocumentById(at.getTargetObject()).getMetadata().setSubmissionSetStatus(slot.getName());
            }
        }
    }

    public DirectDocument2 getDocumentById(String targetObject) {
        for (DirectDocument2 document : this.documents) {
            if (!StringUtils.equalsIgnoreCase((String)document.getMetadata().getId(), (String)targetObject)) continue;
            return document;
        }
        return null;
    }

    public DirectDocument2 getDocumentByUniqueId(String uniqueId) {
        for (DirectDocument2 document : this.documents) {
            if (!StringUtils.equalsIgnoreCase((String)document.getMetadata().getUniqueId(), (String)uniqueId)) continue;
            return document;
        }
        return null;
    }

    public DirectDocument2 getDocumentByHash(String hash) {
        for (DirectDocument2 document : this.documents) {
            if (!StringUtils.equalsIgnoreCase((String)document.getMetadata().getHash(), (String)hash)) continue;
            return document;
        }
        return null;
    }

    public DirectDocument2 getDocument(String identifier) {
        DirectDocument2 document = null;
        document = this.getDocumentById(identifier);
        if (document != null) {
            return document;
        }
        document = this.getDocumentByUniqueId(identifier);
        if (document != null) {
            return document;
        }
        document = this.getDocumentByHash(identifier);
        if (document != null) {
            return document;
        }
        return document;
    }

    public String getSubmitObjectsRequestAsString() {
        QName qname = new QName(SubmitObjectsRequestEnum.SUBMIT_OBJECTS_REQUEST.getNamespaceUri(), SubmitObjectsRequestEnum.SUBMIT_OBJECTS_REQUEST.getName());
        return XmlUtils.marshal(qname, this.getSubmitObjectsRequest(), ihe.iti.xds_b._2007.ObjectFactory.class);
    }

    public ProvideAndRegisterDocumentSetRequestType toProvideAndRegisterDocumentSetRequestType() throws IOException {
        ProvideAndRegisterDocumentSetRequestType request = new ProvideAndRegisterDocumentSetRequestType();
        request.setSubmitObjectsRequest(this.getSubmitObjectsRequest());
        for (DirectDocument2 document : this.documents) {
            if (document.getData() == null) continue;
            ByteArrayDataSource source = new ByteArrayDataSource(document.getData(), document.getMetadata().getMimeType());
            DataHandler dhnew = new DataHandler((DataSource)source);
            ProvideAndRegisterDocumentSetRequestType.Document pdoc = new ProvideAndRegisterDocumentSetRequestType.Document();
            pdoc.setValue(dhnew);
            String id = document.getMetadata().getId();
            pdoc.setId(id);
            request.getDocument().add(pdoc);
        }
        return request;
    }

    public XdmPackage toXdmPackage(String messageId) {
        XdmPackage xdmPackage = new XdmPackage(messageId);
        xdmPackage.setDocuments(this);
        return xdmPackage;
    }

    public static class SubmissionSet {
        private String id = "SubmissionSet01";
        private String name;
        private String description;
        private Date submissionTime;
        private List<String> intendedRecipient = new ArrayList<String>();
        private String authorPerson;
        private List<String> authorInstitution = new ArrayList<String>();
        private String authorRole;
        private String authorSpecialty;
        private String authorTelecommunication;
        private String contentTypeCode;
        private String contentTypeCode_localized;
        private String uniqueId;
        private String sourceId;
        private String patientId;

        protected RegistryPackageType generateRegistryPackageType() {
            RegistryPackageType rpt = new RegistryPackageType();
            rpt.setId(this.id);
            List<SlotType1> slots = rpt.getSlot();
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SUBMISSION_TIME, this.submissionTime != null ? new SimpleDateFormat("yyyyMMddHHmmss").format(this.submissionTime) : null));
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.INTENDED_RECIPIENT, this.intendedRecipient));
            rpt.setName(DirectDocumentUtils.makeInternationalStringType(this.name));
            rpt.setDescription(DirectDocumentUtils.makeInternationalStringType(this.description));
            ClassificationType authorClassification = new ClassificationType();
            authorClassification.setClassifiedObject(this.id);
            authorClassification.setNodeRepresentation("");
            authorClassification.setId(ClassificationTypeEnum.SS_AUTHOR.getClassificationId());
            authorClassification.setClassificationScheme(ClassificationTypeEnum.SS_AUTHOR.getClassificationScheme());
            List<SlotType1> authorClassificationSlots = authorClassification.getSlot();
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_PERSON, this.authorPerson));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_INSTITUTION, this.authorInstitution));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_ROLE, this.authorRole));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_SPECIALTY, this.authorSpecialty));
            DirectDocumentUtils.addSlot(authorClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.AUTHOR_TELECOMMUNICATION, this.authorTelecommunication));
            rpt.getClassification().add(authorClassification);
            ClassificationType contentTypeCodeClassification = new ClassificationType();
            contentTypeCodeClassification.setClassifiedObject(this.id);
            contentTypeCodeClassification.setNodeRepresentation(this.contentTypeCode);
            contentTypeCodeClassification.setName(DirectDocumentUtils.makeInternationalStringType(this.contentTypeCode_localized));
            contentTypeCodeClassification.setId(ClassificationTypeEnum.SS_CONTENT_TYPE_CODE.getClassificationId());
            contentTypeCodeClassification.setClassificationScheme(ClassificationTypeEnum.SS_CONTENT_TYPE_CODE.getClassificationScheme());
            List<SlotType1> contentTypeCodeClassificationSlots = contentTypeCodeClassification.getSlot();
            DirectDocumentUtils.addSlot(contentTypeCodeClassificationSlots, DirectDocumentUtils.makeSlot(SlotType1Enum.CODING_SCHEME, ClassificationTypeEnum.SS_CONTENT_TYPE_CODE.getCodingScheme()));
            rpt.getClassification().add(contentTypeCodeClassification);
            ExternalIdentifierType xdsSubmissionSet_uniqueId = new ExternalIdentifierType();
            xdsSubmissionSet_uniqueId.setValue(this.uniqueId);
            xdsSubmissionSet_uniqueId.setRegistryObject(this.id);
            xdsSubmissionSet_uniqueId.setId(ExternalIdentifierTypeEnum.SS_UNIQUE_ID.getIdentificationId());
            xdsSubmissionSet_uniqueId.setIdentificationScheme(ExternalIdentifierTypeEnum.SS_UNIQUE_ID.getIdentificationScheme());
            xdsSubmissionSet_uniqueId.setName(DirectDocumentUtils.makeInternationalStringType(ExternalIdentifierTypeEnum.SS_UNIQUE_ID.getLocalizedString()));
            rpt.getExternalIdentifier().add(xdsSubmissionSet_uniqueId);
            ExternalIdentifierType xdsSubmissionSet_sourceId = new ExternalIdentifierType();
            xdsSubmissionSet_sourceId.setValue(this.sourceId);
            xdsSubmissionSet_sourceId.setRegistryObject(this.id);
            xdsSubmissionSet_sourceId.setId(ExternalIdentifierTypeEnum.SS_SOURCE_ID.getIdentificationId());
            xdsSubmissionSet_sourceId.setIdentificationScheme(ExternalIdentifierTypeEnum.SS_SOURCE_ID.getIdentificationScheme());
            xdsSubmissionSet_sourceId.setName(DirectDocumentUtils.makeInternationalStringType(ExternalIdentifierTypeEnum.SS_SOURCE_ID.getLocalizedString()));
            rpt.getExternalIdentifier().add(xdsSubmissionSet_sourceId);
            ExternalIdentifierType xdsSubmissionSet_patientId = new ExternalIdentifierType();
            xdsSubmissionSet_patientId.setValue(this.patientId);
            xdsSubmissionSet_patientId.setRegistryObject(this.id);
            xdsSubmissionSet_patientId.setId(ExternalIdentifierTypeEnum.SS_PATIENT_ID.getIdentificationId());
            xdsSubmissionSet_patientId.setIdentificationScheme(ExternalIdentifierTypeEnum.SS_PATIENT_ID.getIdentificationScheme());
            xdsSubmissionSet_patientId.setName(DirectDocumentUtils.makeInternationalStringType(ExternalIdentifierTypeEnum.SS_PATIENT_ID.getLocalizedString()));
            rpt.getExternalIdentifier().add(xdsSubmissionSet_patientId);
            return rpt;
        }

        protected ClassificationType generateClassificationType() {
            ClassificationType ct = new ClassificationType();
            ct.setClassifiedObject(this.id);
            ct.setId(ClassificationTypeEnum.SS.getClassificationId());
            ct.setClassificationScheme(ClassificationTypeEnum.SS.getClassificationScheme());
            return ct;
        }

        protected AssociationType1 generateAssociationType(String documentId, String submissionSetStatus) {
            AssociationType1 at = new AssociationType1();
            at.setSourceObject(this.id);
            at.setTargetObject(documentId);
            at.setId(AssociationType1Enum.HAS_MEMBER.getAssociationId());
            at.setAssociationType(AssociationType1Enum.HAS_MEMBER.getAssociationType());
            List<SlotType1> slots = at.getSlot();
            DirectDocumentUtils.addSlot(slots, DirectDocumentUtils.makeSlot(SlotType1Enum.SUBMISSION_SET_STATUS, submissionSetStatus));
            return at;
        }

        protected void setValues(RegistryPackageType rpt) throws MetadataException {
            this.id = rpt.getId();
            this.name = rpt.getName().getLocalizedString().get(0).getValue();
            if (rpt.getDescription() != null) {
                this.description = rpt.getDescription().getLocalizedString().get(0).getValue();
            }
            for (SlotType1 slot : rpt.getSlot()) {
                if (SlotType1Enum.SUBMISSION_TIME.matches(slot.getName())) {
                    if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    try {
                        this.submissionTime = DateUtils.parseDate((String)slot.getValueList().getValue().get(0), (String[])new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMdd"});
                        continue;
                    }
                    catch (ParseException e) {
                        LOGGER.error((Object)"Unable to parse submissionTime", (Throwable)e);
                        throw new MetadataException("Unable to parse submissionTime", e);
                    }
                }
                if (!SlotType1Enum.INTENDED_RECIPIENT.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                for (String value : slot.getValueList().getValue()) {
                    this.intendedRecipient.add(value);
                }
            }
            for (ClassificationType ct : rpt.getClassification()) {
                if (ClassificationTypeEnum.SS_AUTHOR.matchesScheme(ct.getClassificationScheme())) {
                    for (SlotType1 slot : ct.getSlot()) {
                        if (SlotType1Enum.AUTHOR_PERSON.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            this.authorPerson = slot.getValueList().getValue().get(0);
                            continue;
                        }
                        if (SlotType1Enum.AUTHOR_INSTITUTION.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            for (String value : slot.getValueList().getValue()) {
                                this.authorInstitution.add(value);
                            }
                            continue;
                        }
                        if (SlotType1Enum.AUTHOR_ROLE.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            this.authorRole = slot.getValueList().getValue().get(0);
                            continue;
                        }
                        if (SlotType1Enum.AUTHOR_SPECIALTY.matches(slot.getName())) {
                            if (!DirectDocumentUtils.slotNotEmpty(slot)) continue;
                            this.authorSpecialty = slot.getValueList().getValue().get(0);
                            continue;
                        }
                        if (!SlotType1Enum.AUTHOR_TELECOMMUNICATION.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                        this.authorTelecommunication = slot.getValueList().getValue().get(0);
                    }
                }
                if (!ClassificationTypeEnum.SS_CONTENT_TYPE_CODE.matchesScheme(ct.getClassificationScheme())) continue;
                for (SlotType1 slot : ct.getSlot()) {
                    if (!SlotType1Enum.CODING_SCHEME.matches(slot.getName()) || !DirectDocumentUtils.slotNotEmpty(slot)) continue;
                    String codingScheme = slot.getValueList().getValue().get(0);
                }
                this.contentTypeCode = ct.getNodeRepresentation();
                if (ct.getName() == null || ct.getName().getLocalizedString() == null || ct.getName().getLocalizedString().isEmpty()) continue;
                this.contentTypeCode_localized = ct.getName().getLocalizedString().get(0).getValue();
            }
            for (ExternalIdentifierType eit : rpt.getExternalIdentifier()) {
                if (ExternalIdentifierTypeEnum.SS_UNIQUE_ID.matchesScheme(eit.getIdentificationScheme())) {
                    this.uniqueId = eit.getValue();
                    continue;
                }
                if (ExternalIdentifierTypeEnum.SS_SOURCE_ID.matchesScheme(eit.getIdentificationScheme())) {
                    this.sourceId = eit.getValue();
                    continue;
                }
                if (!ExternalIdentifierTypeEnum.SS_PATIENT_ID.matchesScheme(eit.getIdentificationScheme())) continue;
                this.patientId = eit.getValue();
            }
        }

        public String toString() {
            QName qname = new QName(SubmitObjectsRequestEnum.REGISTRY_PACKAGE.getNamespaceUri(), SubmitObjectsRequestEnum.REGISTRY_PACKAGE.getName());
            return XmlUtils.marshal(qname, this.generateRegistryPackageType(), ihe.iti.xds_b._2007.ObjectFactory.class);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Date getSubmissionTime() {
            return this.submissionTime;
        }

        public void setSubmissionTime(Date submissionTime) {
            this.submissionTime = submissionTime;
        }

        public List<String> getIntendedRecipient() {
            return this.intendedRecipient;
        }

        public void setIntendedRecipient(List<String> intendedRecipient) {
            this.intendedRecipient = intendedRecipient;
        }

        public String getAuthorPerson() {
            return this.authorPerson;
        }

        public void setAuthorPerson(String authorPerson) {
            this.authorPerson = authorPerson;
        }

        public List<String> getAuthorInstitution() {
            return this.authorInstitution;
        }

        public void setAuthorInstitution(List<String> authorInstitution) {
            this.authorInstitution = authorInstitution;
        }

        public String getAuthorRole() {
            return this.authorRole;
        }

        public void setAuthorRole(String authorRole) {
            this.authorRole = authorRole;
        }

        public String getAuthorSpecialty() {
            return this.authorSpecialty;
        }

        public void setAuthorSpecialty(String authorSpecialty) {
            this.authorSpecialty = authorSpecialty;
        }

        public String getAuthorTelecommunication() {
            return this.authorTelecommunication;
        }

        public void setAuthorTelecommunication(String authorTelecommunication) {
            this.authorTelecommunication = authorTelecommunication;
        }

        public String getContentTypeCode() {
            return this.contentTypeCode;
        }

        public void setContentTypeCode(String contentTypeCode) {
            this.setContentTypeCode(contentTypeCode, false);
        }

        public void setContentTypeCode(String contentTypeCode, boolean setLocalized) {
            this.contentTypeCode = contentTypeCode;
            if (setLocalized) {
                this.contentTypeCode_localized = contentTypeCode;
            }
        }

        public String getContentTypeCode_localized() {
            return this.contentTypeCode_localized;
        }

        public void setContentTypeCode_localized(String contentTypeCodeLocalized) {
            this.contentTypeCode_localized = contentTypeCodeLocalized;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getPatientId() {
            return this.patientId;
        }

        public void setPatientId(String patientId) {
            this.patientId = patientId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.authorInstitution == null ? 0 : ((Object)this.authorInstitution).hashCode());
            result = 31 * result + (this.authorPerson == null ? 0 : this.authorPerson.hashCode());
            result = 31 * result + (this.authorRole == null ? 0 : this.authorRole.hashCode());
            result = 31 * result + (this.authorSpecialty == null ? 0 : this.authorSpecialty.hashCode());
            result = 31 * result + (this.authorTelecommunication == null ? 0 : this.authorTelecommunication.hashCode());
            result = 31 * result + (this.contentTypeCode == null ? 0 : this.contentTypeCode.hashCode());
            result = 31 * result + (this.contentTypeCode_localized == null ? 0 : this.contentTypeCode_localized.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.intendedRecipient == null ? 0 : ((Object)this.intendedRecipient).hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.patientId == null ? 0 : this.patientId.hashCode());
            result = 31 * result + (this.sourceId == null ? 0 : this.sourceId.hashCode());
            result = 31 * result + (this.submissionTime == null ? 0 : this.submissionTime.hashCode());
            result = 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubmissionSet)) {
                return false;
            }
            SubmissionSet other = (SubmissionSet)obj;
            if (this.authorInstitution == null ? other.authorInstitution != null : !((Object)this.authorInstitution).equals(other.authorInstitution)) {
                return false;
            }
            if (this.authorPerson == null ? other.authorPerson != null : !this.authorPerson.equals(other.authorPerson)) {
                return false;
            }
            if (this.authorRole == null ? other.authorRole != null : !this.authorRole.equals(other.authorRole)) {
                return false;
            }
            if (this.authorSpecialty == null ? other.authorSpecialty != null : !this.authorSpecialty.equals(other.authorSpecialty)) {
                return false;
            }
            if (this.authorTelecommunication == null ? other.authorTelecommunication != null : !this.authorTelecommunication.equals(other.authorTelecommunication)) {
                return false;
            }
            if (this.contentTypeCode == null ? other.contentTypeCode != null : !this.contentTypeCode.equals(other.contentTypeCode)) {
                return false;
            }
            if (this.contentTypeCode_localized == null ? other.contentTypeCode_localized != null : !this.contentTypeCode_localized.equals(other.contentTypeCode_localized)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.intendedRecipient == null ? other.intendedRecipient != null : !((Object)this.intendedRecipient).equals(other.intendedRecipient)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.patientId == null ? other.patientId != null : !this.patientId.equals(other.patientId)) {
                return false;
            }
            if (this.sourceId == null ? other.sourceId != null : !this.sourceId.equals(other.sourceId)) {
                return false;
            }
            if (this.submissionTime == null ? other.submissionTime != null : !this.submissionTime.equals(other.submissionTime)) {
                return false;
            }
            return !(this.uniqueId == null ? other.uniqueId != null : !this.uniqueId.equals(other.uniqueId));
        }
    }
}

