/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.AbstractHTTPServlet;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;

public abstract class AbstractCXFServlet
extends AbstractHTTPServlet {
    static final Map<String, WeakReference<Bus>> BUS_MAP = new Hashtable<String, WeakReference<Bus>>();
    static final Logger LOG = AbstractCXFServlet.getLogger();
    protected Bus bus;
    protected ServletTransportFactory servletTransportFactory;
    protected ServletController controller;

    public static Logger getLogger() {
        return LogUtils.getL7dLogger(AbstractCXFServlet.class);
    }

    public ServletController createServletController(ServletConfig servletConfig) {
        ServletController newController = new ServletController(this.servletTransportFactory, servletConfig, this.getServletContext(), this.bus);
        return newController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            WeakReference<Bus> ref;
            BusFactory.setThreadDefaultBus(null);
            String busid = servletConfig.getInitParameter("bus.id");
            if (null != busid && null != (ref = BUS_MAP.get(busid))) {
                this.bus = (Bus)ref.get();
                BusFactory.setThreadDefaultBus((Bus)this.bus);
            }
            this.loadBus(servletConfig);
            if (null != busid) {
                BUS_MAP.put(busid, new WeakReference<Bus>(this.bus));
            }
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public abstract void loadBus(ServletConfig var1) throws ServletException;

    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new ServletTransportFactory(this.bus);
        }
        return this.servletTransportFactory;
    }

    private void registerTransport(DestinationFactory factory, String namespace) {
        ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).registerDestinationFactory(namespace, factory);
    }

    protected void replaceDestinationFactory() {
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof ServletTransportFactory) {
                this.servletTransportFactory = (ServletTransportFactory)df;
                LOG.info("DESTIONFACTORY_ALREADY_REGISTERED");
                return;
            }
        }
        catch (BusException e) {
            // empty catch block
        }
        DestinationFactory factory = this.createServletTransportFactory();
        for (String s : factory.getTransportIds()) {
            this.registerTransport(factory, s);
        }
        LOG.info("REPLACED_HTTP_DESTIONFACTORY");
    }

    public ServletController getController() {
        return this.controller;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void destroy() {
        String s = this.bus.getId();
        BUS_MAP.remove(s);
        this.bus.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus((Bus)this.getBus());
            this.controller.invoke(request, response);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }
}

