/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.utils.PolicyUtils;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtentionIdentifier;

public class SubjectKeyIdentifierExtensionField
extends AbstractExtensionField<String>
implements ExtensionField<String> {
    static final long serialVersionUID = 4940506438781925043L;

    public SubjectKeyIdentifierExtensionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        DERObject exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            this.policyValue = PolicyValueFactory.getInstance("");
            return;
        }
        SubjectKeyIdentifier keyId = SubjectKeyIdentifier.getInstance((Object)exValue);
        keyId.getKeyIdentifier();
        this.policyValue = PolicyValueFactory.getInstance(PolicyUtils.createByteStringRep(keyId.getKeyIdentifier()));
    }

    @Override
    public ExtentionIdentifier getExtentionIdentifier() {
        return ExtentionIdentifier.SUBJECT_KEY_IDENTIFIER;
    }
}

