/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtentionIdentifier;

public class KeyUsageExtensionField
extends AbstractExtensionField<Integer>
implements ExtensionField<Integer> {
    static final long serialVersionUID = 9206471801632337363L;

    public KeyUsageExtensionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        DERObject exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            this.policyValue = PolicyValueFactory.getInstance(0);
            return;
        }
        KeyUsage keyUsage = new KeyUsage((DERBitString)exValue);
        byte[] data = keyUsage.getBytes();
        int intValue = data.length == 1 ? data[0] & 0xFF : (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.policyValue = PolicyValueFactory.getInstance(intValue);
    }

    @Override
    public ExtentionIdentifier getExtentionIdentifier() {
        return ExtentionIdentifier.KEY_USAGE;
    }
}

